/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.annotation.processor;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.glassfish.admin.rest.composite.RestModelExtension;

@SupportedAnnotationTypes(value={"org.glassfish.admin.rest.composite.RestModelExtension"})
public class RestModelExtensionProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> elements, RoundEnvironment env) {
        try {
            HashMap<String, ArrayList<String>> classes = new HashMap<String, ArrayList<String>>();
            for (TypeElement typeElement : elements) {
                for (Element element : env.getElementsAnnotatedWith(typeElement)) {
                    RestModelExtension annotation = element.getAnnotation(RestModelExtension.class);
                    String parent = annotation.parent();
                    ArrayList<String> list = (ArrayList<String>)classes.get(parent);
                    if (list == null) {
                        list = new ArrayList<String>();
                        classes.put(parent, list);
                    }
                    list.add(element.toString());
                }
            }
            if (classes.isEmpty()) {
                return true;
            }
            Filer filer = this.processingEnv.getFiler();
            FileObject fileObject = filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/restmodelextensions", new Element[0]);
            try (BufferedWriter bw = new BufferedWriter(fileObject.openWriter());){
                for (Map.Entry entry : classes.entrySet()) {
                    String key = (String)entry.getKey();
                    for (String ext : (List)entry.getValue()) {
                        bw.write(key);
                        bw.write(":");
                        bw.write(ext);
                        bw.write(10);
                    }
                }
            }
        }
        catch (IOException ex) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, ex.getLocalizedMessage());
        }
        return true;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

