/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.Platform.dd;

import ee.jakarta.tck.concurrent.common.context.IntContext;
import ee.jakarta.tck.concurrent.common.context.StringContext;
import ee.jakarta.tck.concurrent.common.qualifiers.CustomQualifier1;
import ee.jakarta.tck.concurrent.common.qualifiers.CustomQualifier2;
import ee.jakarta.tck.concurrent.common.qualifiers.InvalidQualifier3;
import ee.jakarta.tck.concurrent.framework.TestServlet;
import ee.jakarta.tck.concurrent.spec.Platform.dd.DeploymentDescriptorTestBeanInterface;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.enterprise.concurrent.ContextService;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import jakarta.servlet.annotation.WebServlet;
import jakarta.transaction.UserTransaction;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;

@WebServlet(value={"/DeploymentDescriptorServlet"})
@Dependent
public class DeploymentDescriptorServlet
extends TestServlet {
    private static final long serialVersionUID = 1L;
    private static final long MAX_WAIT_SECONDS = TimeUnit.MINUTES.toSeconds(2L);
    private static final Runnable NOOP_RUNNABLE = () -> {};
    @EJB
    private DeploymentDescriptorTestBeanInterface enterpriseBean;
    @Resource
    private UserTransaction tx;
    @Inject
    private ContextService injectedDefContextSvc;
    @Inject
    @CustomQualifier1
    private ContextService injectedContextD;
    @Inject
    private ManagedExecutorService injectedDefMES;
    @Inject
    @CustomQualifier2
    private ManagedExecutorService injectedMESD;
    @Inject
    private ManagedScheduledExecutorService injectedDefMSES;
    @Inject
    @CustomQualifier1
    @CustomQualifier2
    private ManagedScheduledExecutorService injectedMSESD;
    @Inject
    private ManagedThreadFactory injectedDefMTF;
    @Resource(lookup="java:app/concurrent/ThreadFactoryD")
    private ManagedThreadFactory resourceMTFD;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer executeCallableWithContext(ContextService svc, int value) throws Exception {
        try {
            IntContext.set(value);
            Callable result = svc.contextualCallable(() -> IntContext.get());
            Integer n = (Integer)result.call();
            return n;
        }
        finally {
            IntContext.set(0);
        }
    }

    public void testDeploymentDescriptorDefinedContextServiceQualifiers() throws Throwable {
        Assertions.assertAll((String)"Context Service Tests", (Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)this.injectedDefContextSvc, (String)"Default contextService was not registered with default qualifier."), () -> Assertions.assertNotNull((Object)this.injectedContextD, (String)"Deployment Descriptor defined contextService was not registered with required qualifier."), () -> Assertions.assertTrue((boolean)CDI.current().select(ContextService.class, new Annotation[]{InvalidQualifier3.Literal.get()}).isUnsatisfied(), (String)"A contextService was satisfied with a qualifier which was not defined in it's deployment descriptior")});
        ContextService lookupDefContextSvc = (ContextService)InitialContext.doLookup("java:comp/DefaultContextService");
        Integer expected1 = this.executeCallableWithContext(lookupDefContextSvc, 95);
        Integer actual1 = this.executeCallableWithContext(this.injectedDefContextSvc, 95);
        Assertions.assertEquals((Integer)expected1, (Integer)actual1, (String)"Default Context Service behavior differed between injection and lookup");
        ContextService lookupContextD = (ContextService)InitialContext.doLookup("java:app/concurrent/ContextD");
        Assertions.assertEquals((Integer)0, (Integer)this.executeCallableWithContext(lookupContextD, 65), (String)"Deployment descriptor defined Context Service that was looked up did not clear the IntContext as configured.");
        Assertions.assertEquals((Integer)0, (Integer)this.executeCallableWithContext(this.injectedContextD, 85), (String)"Deployment descriptor defined Context Service that was injected based on a qualifier did not clear the IntContext as configured.");
    }

    public void testDeploymentDescriptorDefinedManagedExecutorSvcQualifiers() throws Throwable {
        Assertions.assertAll((String)"Managed Executor Service Tests", (Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)this.injectedDefMES, (String)"Default managedExecutorService was not registered with default qualifier."), () -> Assertions.assertNotNull((Object)this.injectedMESD, (String)"Deployment Descriptor defined managedExecutorService was not registered with required qualifiers."), () -> Assertions.assertTrue((boolean)CDI.current().select(ManagedExecutorService.class, new Annotation[]{CustomQualifier2.Literal.get(), InvalidQualifier3.Literal.get()}).isUnsatisfied(), (String)"A managedExecutorService was satisfied with both a required and non-required qualifier.")});
        ManagedExecutorService lookupDefMES = (ManagedExecutorService)InitialContext.doLookup("java:comp/DefaultManagedExecutorService");
        ContextService lookupDefContextSvc = lookupDefMES.getContextService();
        ContextService extractedDefContextSvc = this.injectedDefMES.getContextService();
        Integer expected1 = this.executeCallableWithContext(lookupDefContextSvc, 95);
        Integer actual1 = this.executeCallableWithContext(extractedDefContextSvc, 95);
        Assertions.assertEquals((Integer)expected1, (Integer)actual1, (String)"Default ManagedExecutorService behavior via context service differed between injection and lookup");
        ManagedExecutorService lookupMESD = (ManagedExecutorService)InitialContext.doLookup("java:app/concurrent/ExecutorD");
        ContextService lookupContextE = lookupMESD.getContextService();
        ContextService extractedContextE = this.injectedMESD.getContextService();
        Assertions.assertEquals((Integer)0, (Integer)this.executeCallableWithContext(lookupContextE, 65), (String)"Deployment descriptor defined and looked up ManagedExecutorService was configured with a context service that did not clear the IntContext as configured.");
        Assertions.assertEquals((Integer)0, (Integer)this.executeCallableWithContext(extractedContextE, 85), (String)"Deployment descriptor defined and injected ManagedExecutorService was configured with a context service that did not clear the IntContext as configured.");
    }

    public void testDeploymentDescriptorDefinedManagedScheduledExecutorSvcQualifers() throws Throwable {
        Assertions.assertAll((String)"Managed Scheduled Executor Service Tests", (Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)this.injectedDefMSES, (String)"Default managedScheduledExecutorService was not registered with default qualifier."), () -> Assertions.assertNotNull((Object)this.injectedMSESD, (String)"Deployment Descriptor defined managedScheduledExecutorService was not registered with required qualifiers."), () -> Assertions.assertTrue((boolean)CDI.current().select(ManagedScheduledExecutorService.class, new Annotation[]{CustomQualifier1.Literal.get()}).isResolvable(), (String)"A managedScheduledExecutorService was not satisfied with one of two configured qualifiers.")});
        ManagedScheduledExecutorService lookupDefMSES = (ManagedScheduledExecutorService)InitialContext.doLookup("java:comp/DefaultManagedScheduledExecutorService");
        ContextService lookupDefContextSvc = lookupDefMSES.getContextService();
        ContextService extractedDefContextSvc = this.injectedDefMSES.getContextService();
        Integer expected1 = this.executeCallableWithContext(lookupDefContextSvc, 95);
        Integer actual1 = this.executeCallableWithContext(extractedDefContextSvc, 95);
        Assertions.assertEquals((Integer)expected1, (Integer)actual1, (String)"Default ManagedScheduledExecutorService behavior via context service differed between injection and lookup");
        ManagedScheduledExecutorService lookupMSESD = (ManagedScheduledExecutorService)InitialContext.doLookup("java:app/concurrent/ScheduledExecutorD");
        ContextService lookupContextE = lookupMSESD.getContextService();
        ContextService extractedContextE = this.injectedMSESD.getContextService();
        Assertions.assertEquals((Integer)0, (Integer)this.executeCallableWithContext(lookupContextE, 65), (String)"Deployment descriptor defined and looked up ManagedScheduledExecutorService was configured with a context service that did not clear the IntContext as configured.");
        Assertions.assertEquals((Integer)0, (Integer)this.executeCallableWithContext(extractedContextE, 85), (String)"Deployment descriptor defined and injected ManagedScheduledExecutorService was configured with a context service that did not clear the IntContext as configured.");
    }

    public void testDeploymentDescriptorDefinedManagedThreadFactoryQualifers() throws Throwable {
        ManagedThreadFactory lookupDefMTF = (ManagedThreadFactory)InitialContext.doLookup("java:comp/DefaultManagedThreadFactory");
        ManagedThreadFactory lookupMTFD = (ManagedThreadFactory)InitialContext.doLookup("java:app/concurrent/ThreadFactoryD");
        Assertions.assertAll((String)"Thread Factory Tests", (Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)this.injectedDefMTF, (String)"A managedThreadFactory was not registered with the default qualifier when the application included a producer."), () -> Assertions.assertEquals((int)5, (int)lookupDefMTF.newThread(NOOP_RUNNABLE).getPriority(), (String)"Default managedThreadFactory from lookup did not have the default priority."), () -> Assertions.assertEquals((int)7, (int)this.injectedDefMTF.newThread(NOOP_RUNNABLE).getPriority(), (String)"Default managedThreadFactory from injection did not have the expected priority."), () -> Assertions.assertNotNull((Object)this.resourceMTFD, (String)"Deployment Descriptor defined managedThreadFactory with no qualifiers could not be found via @Resource."), () -> Assertions.assertEquals((int)lookupMTFD.newThread(NOOP_RUNNABLE).getPriority(), (int)this.resourceMTFD.newThread(NOOP_RUNNABLE).getPriority(), (String)"The managedThreadFactory from resource injection and lookup did not have the same priority."), () -> Assertions.assertTrue((boolean)CDI.current().select(ManagedThreadFactory.class, new Annotation[]{CustomQualifier1.Literal.get()}).isUnsatisfied(), (String)"A managedThreadFactory was satisfied with a required qualifier that was not configured on the deployment descriptor.")});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeploymentDescriptorDefinesContextService() throws Throwable {
        int status;
        Callable checkContextAndGetTransactionStatus;
        ContextService contextSvc = (ContextService)InitialContext.doLookup("java:app/concurrent/ContextD");
        this.tx.begin();
        try {
            IntContext.set(1001);
            StringContext.set("testDeploymentDescriptorDefinesContextService-1");
            checkContextAndGetTransactionStatus = contextSvc.contextualCallable(() -> {
                Assertions.assertEquals((int)0, (int)IntContext.get());
                Assertions.assertEquals((Object)"testDeploymentDescriptorDefinesContextService-1", (Object)StringContext.get());
                Assertions.assertNotNull(InitialContext.doLookup("java:app/concurrent/ExecutorD"));
                return this.tx.getStatus();
            });
            StringContext.set("testDeploymentDescriptorDefinesContextService-2");
            status = (Integer)checkContextAndGetTransactionStatus.call();
            Assertions.assertEquals((int)0, (int)status);
            Assertions.assertEquals((int)1001, (int)IntContext.get());
            Assertions.assertEquals((Object)"testDeploymentDescriptorDefinesContextService-2", (Object)StringContext.get());
        }
        finally {
            IntContext.set(0);
            StringContext.set(null);
            this.tx.rollback();
        }
        status = (Integer)checkContextAndGetTransactionStatus.call();
        Assertions.assertEquals((int)6, (int)status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeploymentDescriptorDefinesManagedExecutor() throws Throwable {
        LinkedBlockingQueue started = new LinkedBlockingQueue();
        CountDownLatch taskCanEnd = new CountDownLatch(1);
        Supplier<String> task = () -> {
            try {
                started.add(InitialContext.doLookup("java:app/concurrent/ExecutorD"));
                Assertions.assertTrue((boolean)taskCanEnd.await(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            }
            catch (InterruptedException | NamingException x) {
                throw new CompletionException(x);
            }
            return StringContext.get();
        };
        ManagedExecutorService executor = (ManagedExecutorService)InitialContext.doLookup("java:app/concurrent/ExecutorD");
        try {
            StringContext.set("testDeploymentDescriptorDefinesManagedExecutor-1");
            CompletableFuture future1 = executor.supplyAsync(task);
            StringContext.set("testDeploymentDescriptorDefinesManagedExecutor-2");
            CompletableFuture future2 = executor.supplyAsync(task);
            StringContext.set("testDeploymentDescriptorDefinesManagedExecutor-3");
            CompletableFuture future3 = executor.supplyAsync(task);
            StringContext.set("testDeploymentDescriptorDefinesManagedExecutor-4");
            CompletableFuture future4 = executor.supplyAsync(task);
            StringContext.set("testDeploymentDescriptorDefinesManagedExecutor-5");
            Assertions.assertNotNull(started.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Assertions.assertNotNull(started.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Assertions.assertNotNull(started.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Assertions.assertEquals(null, started.poll(1L, TimeUnit.SECONDS));
            taskCanEnd.countDown();
            Assertions.assertEquals((Object)"testDeploymentDescriptorDefinesManagedExecutor-1", future1.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Assertions.assertEquals((Object)"testDeploymentDescriptorDefinesManagedExecutor-2", future2.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Assertions.assertEquals((Object)"testDeploymentDescriptorDefinesManagedExecutor-3", future3.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Assertions.assertEquals((Object)"testDeploymentDescriptorDefinesManagedExecutor-4", future4.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Assertions.assertNotNull(started.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
        }
        finally {
            IntContext.set(0);
            StringContext.set(null);
        }
    }

    public void testDeploymentDescriptorDefinesManagedScheduledExecutor() throws Throwable {
        this.enterpriseBean.testDeploymentDescriptorDefinesManagedScheduledExecutor();
    }

    public void testDeploymentDescriptorDefinesManagedThreadFactory() throws Throwable {
        this.enterpriseBean.testDeploymentDescriptorDefinesManagedThreadFactory();
    }
}

