/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.invokers.lookup;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.build.compatible.spi.BeanInfo;
import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.build.compatible.spi.InvokerFactory;
import jakarta.enterprise.inject.build.compatible.spi.Registration;
import jakarta.enterprise.inject.build.compatible.spi.Synthesis;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticComponents;
import jakarta.enterprise.invoke.Invoker;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.invokers.InvokerHolder;
import org.jboss.cdi.tck.tests.invokers.InvokerHolderCreator;
import org.jboss.cdi.tck.tests.invokers.InvokerHolderExtensionBase;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="4.1")
public class ArgumentArraySizeWithLookupTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(ArgumentArraySizeWithLookupTest.class)).withClasses(MyService.class, MyDependency1.class, MyDependency2.class)).withBuildCompatibleExtension(TestExtension.class)).withClasses(InvokerHolder.class, InvokerHolderCreator.class, InvokerHolderExtensionBase.class)).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="configuring_lookups", id="a"), @SpecAssertion(section="configuring_lookups", id="f")})
    public void test(MyService service, InvokerHolder invokers) throws Exception {
        Invoker invoker = invokers.get("hello");
        Assert.assertThrows(RuntimeException.class, () -> invoker.invoke((Object)service, null));
        Assert.assertThrows(RuntimeException.class, () -> invoker.invoke((Object)service, new Object[0]));
        Assert.assertThrows(RuntimeException.class, () -> invoker.invoke((Object)service, new Object[]{null}));
        Assert.assertEquals((String)"foobar_1_2", (String)((String)invoker.invoke((Object)service, new Object[]{null, null})));
        Assert.assertEquals((String)"foobar_1_2", (String)((String)invoker.invoke((Object)service, new Object[]{null, null, null})));
    }

    @ApplicationScoped
    static class MyService {
        MyService() {
        }

        public String hello(MyDependency1 dependency1, MyDependency2 dependency2) {
            return "foobar_" + dependency1 + "_" + dependency2;
        }
    }

    @Dependent
    static class MyDependency1 {
        MyDependency1() {
        }

        public String toString() {
            return "1";
        }
    }

    @Dependent
    static class MyDependency2 {
        MyDependency2() {
        }

        public String toString() {
            return "2";
        }
    }

    public static class TestExtension
    extends InvokerHolderExtensionBase
    implements BuildCompatibleExtension {
        @Registration(types={MyService.class})
        public void myServiceRegistration(BeanInfo bean, InvokerFactory invokers) {
            this.registerInvokers(bean, invokers, Set.of("hello"), builder -> builder.withArgumentLookup(0).withArgumentLookup(1));
        }

        @Synthesis
        public void synthesis(SyntheticComponents syn) {
            this.synthesizeInvokerHolder(syn);
        }
    }
}

