/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.extensions.lifecycle;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.SimpleBean;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.SimpleEvent;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.SimpleExtension;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.SuperExtension;
import org.jboss.shrinkwrap.api.BeanDiscoveryMode;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"cdi-full"})
@SpecVersion(spec="cdi", version="2.0")
public class ExtensionLifecycleTest
extends AbstractTest {
    @Inject
    SimpleBean simpleBean;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ExtensionLifecycleTest.class)).withExtension(SimpleExtension.class)).withBeansXml(new BeansXml(BeanDiscoveryMode.ALL))).build();
    }

    @Test
    @SpecAssertion(section="init_events", id="f")
    public void testContainerProvidesBeanForExtension() {
        Set beans = this.getCurrentManager().getBeans(SimpleExtension.class, new Annotation[0]);
        Assert.assertEquals((int)beans.size(), (int)1);
        Bean simpleExtensionBean = (Bean)beans.iterator().next();
        Assert.assertEquals((Object)simpleExtensionBean.getScope(), ApplicationScoped.class);
        Assert.assertEquals((int)simpleExtensionBean.getQualifiers().size(), (int)2);
        Assert.assertTrue((boolean)simpleExtensionBean.getQualifiers().contains(Default.Literal.INSTANCE));
        Assert.assertTrue((boolean)simpleExtensionBean.getQualifiers().contains(Any.Literal.INSTANCE));
        Set types = simpleExtensionBean.getTypes();
        Assert.assertEquals((int)types.size(), (int)4);
        Assert.assertTrue((boolean)types.contains(SuperExtension.class));
        Assert.assertTrue((boolean)types.contains(Extension.class));
        Assert.assertTrue((boolean)types.contains(SimpleExtension.class));
        Assert.assertTrue((boolean)types.contains(Object.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="init_events", id="d"), @SpecAssertion(section="init_events", id="f")})
    public void testContainerInstantiatesSingleInstanceOfExtension() {
        long id = this.simpleBean.getSimpleExtension().getId();
        Assert.assertEquals((long)this.getContextualReference(SimpleExtension.class, new Annotation[0]).getId(), (long)id);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="init_events", id="d"), @SpecAssertion(section="init_events", id="f"), @SpecAssertion(section="init_events", id="bb")})
    public void testContainerDeliversEventNotifications() {
        Assert.assertTrue((boolean)this.simpleBean.getSimpleExtension().isContainerEventObserved());
        this.getCurrentManager().getEvent().select(SimpleEvent.class, new Annotation[0]).fire((Object)new SimpleEvent(System.currentTimeMillis()));
        Assert.assertTrue((boolean)this.simpleBean.getSimpleExtension().isSimpleEventObserved());
    }
}

