/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.extensions.annotated.delivery;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.WithAnnotations;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.cdi.tck.tests.full.extensions.annotated.delivery.Desired;
import org.jboss.cdi.tck.tests.full.extensions.annotated.delivery.MetaAnnotation;
import org.jboss.cdi.tck.tests.full.extensions.annotated.delivery.Wanted;

public class ProcessAnnotatedTypeObserver
implements Extension {
    private List<Class<?>> processedDesiredTypes = new ArrayList();
    private List<Class<?>> processedDesiredAndWantedTypes = new ArrayList();
    private List<Class<?>> processedMetaAnnotationTypes = new ArrayList();
    private List<Class<?>> processedRequestScopeTypes = new ArrayList();

    public void observeDesiredTypes(@WithAnnotations(value={Desired.class}) @Observes ProcessAnnotatedType<?> pat) {
        this.processedDesiredTypes.add(pat.getAnnotatedType().getJavaClass());
    }

    public void observeDesiredAndWanted(@WithAnnotations(value={Desired.class, Wanted.class}) @Observes ProcessAnnotatedType<?> pat) {
        this.processedDesiredAndWantedTypes.add(pat.getAnnotatedType().getJavaClass());
    }

    public void observeMetaAnnotationTypes(@WithAnnotations(value={MetaAnnotation.class}) @Observes ProcessAnnotatedType<?> pat) {
        this.processedMetaAnnotationTypes.add(pat.getAnnotatedType().getJavaClass());
    }

    public void observeRequestScopeTypes(@WithAnnotations(value={RequestScoped.class}) @Observes ProcessAnnotatedType<?> pat) {
        this.processedRequestScopeTypes.add(pat.getAnnotatedType().getJavaClass());
    }

    public List<Class<?>> getProcessedDesiredTypes() {
        return Collections.unmodifiableList(this.processedDesiredTypes);
    }

    public List<Class<?>> getProcessedDesiredAndWantedTypes() {
        return Collections.unmodifiableList(this.processedDesiredAndWantedTypes);
    }

    public List<Class<?>> getProcessedMetaAnnotationTypes() {
        return Collections.unmodifiableList(this.processedMetaAnnotationTypes);
    }

    public List<Class<?>> getProcessedRequestScopeTypes() {
        return Collections.unmodifiableList(this.processedRequestScopeTypes);
    }
}

