/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.MyRequestBean;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class DestroyedInstanceReturnedByGetTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(DestroyedInstanceReturnedByGetTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="context", id="q"), @SpecAssertion(section="bean", id="aa")})
    public void testDestroyedInstanceMustNotBeReturnedByGet() {
        assert (this.getBeans(MyRequestBean.class, new Annotation[0]).size() == 1);
        Bean<MyRequestBean> myRequestBean = this.getBeans(MyRequestBean.class, new Annotation[0]).iterator().next();
        CreationalContext sessionCreationalContext = this.getCurrentManager().createCreationalContext(myRequestBean);
        MyRequestBean beanInstance = (MyRequestBean)myRequestBean.create(sessionCreationalContext);
        assert (beanInstance != null);
        Context requestContext = this.getCurrentManager().getContext(RequestScoped.class);
        this.destroyContext(requestContext);
        this.setContextActive(requestContext);
        beanInstance = (MyRequestBean)requestContext.get(myRequestBean);
        assert (beanInstance == null);
    }
}

