/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.instantiation.ui;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edapt.internal.common.URIUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ReleaseWizardPage
extends WizardPage {
    private final Map<EPackage, String> packageToInferedSource = new LinkedHashMap<EPackage, String>();
    private final Map<EPackage, Text> packageToSourceText = new LinkedHashMap<EPackage, Text>();
    private final Map<EPackage, Text> packageToTargetText = new LinkedHashMap<EPackage, Text>();
    private final Map<EPackage, Button> packageToUpdateButton = new LinkedHashMap<EPackage, Button>();
    private final List<EPackage> packages;
    private final Set<EPackage> changedPackages;

    protected ReleaseWizardPage(String pageName, String description, ImageDescriptor titleImage, List<EPackage> packages, Set<EPackage> changedPackages) {
        super(pageName, pageName, titleImage);
        this.setDescription(description);
        this.packages = packages;
        for (EPackage ePackage : packages) {
            this.packageToInferedSource.put(ePackage, this.inferSource(ePackage));
        }
        this.changedPackages = changedPackages;
    }

    private String inferSource(EPackage ePackage) {
        try {
            String nsURI = ePackage.getNsURI();
            int index = nsURI.lastIndexOf(47);
            return nsURI.substring(index + 1);
        }
        catch (RuntimeException e) {
            return "";
        }
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(mainComposite);
        ScrolledComposite scrolledComposite = new ScrolledComposite(mainComposite, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setShowFocusedControl(true);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo((Composite)scrolledComposite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)scrolledComposite);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(5).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).align(1, 1).applyTo((Control)composite);
        composite.setBackground(composite.getDisplay().getSystemColor(1));
        composite.setBackgroundMode(2);
        this.createLabel(composite, "#", 10);
        this.createLabel(composite, "Package", 10);
        GridDataFactory.fillDefaults().hint(250, -1).applyTo((Control)this.createLabel(composite, "Label to match", 10));
        GridDataFactory.fillDefaults().hint(250, -1).applyTo((Control)this.createLabel(composite, "Label to replace with", 10));
        this.createLabel(composite, "Update?", 10).setToolTipText("Whether to update the NS-URI at all.");
        int i = 0;
        while (i < this.packages.size()) {
            EPackage ePackage = this.packages.get(i);
            this.createLabel(composite, String.valueOf(i + 1) + ".");
            this.createLabel(composite, ePackage.getNsURI());
            Text sourceText = new Text(composite, 2048);
            this.packageToSourceText.put(ePackage, sourceText);
            sourceText.setText(this.packageToInferedSource.get(ePackage));
            sourceText.setLayoutData((Object)new GridData(768));
            this.initSourceText(sourceText);
            Text targetText = new Text(composite, 2048);
            this.packageToTargetText.put(ePackage, targetText);
            targetText.setLayoutData((Object)new GridData(768));
            this.initTargetText(targetText);
            Button updateButton = new Button(composite, 32);
            updateButton.setToolTipText("Whether to update the NS-URI at all.");
            this.packageToUpdateButton.put(ePackage, updateButton);
            updateButton.setSelection(this.changedPackages.contains(ePackage));
            this.initUpdateButton(updateButton, ePackage);
            this.setTextEnablement(updateButton, ePackage);
            ++i;
        }
        scrolledComposite.setContent((Control)composite);
        composite.layout();
        Point point = composite.computeSize(-1, -1);
        scrolledComposite.setMinSize(point);
        if (this.packages.size() > 1) {
            Composite buttonsComposite = new Composite(mainComposite, 0);
            GridDataFactory.swtDefaults().align(0x1000008, 1).applyTo((Control)buttonsComposite);
            buttonsComposite.setLayout((Layout)new FillLayout(256));
            this.createSelectAllButton(buttonsComposite, "Select &All", true);
            this.createSelectAllButton(buttonsComposite, "&Deselect All", false);
        }
        this.setControl((Control)mainComposite);
        this.checkIfPageComplete();
    }

    private Label createLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setText(string);
        return label;
    }

    private Label createLabel(Composite composite, String string, int color) {
        Label label = this.createLabel(composite, string);
        label.setForeground(label.getDisplay().getSystemColor(color));
        return label;
    }

    private void initSourceText(Text sourceText) {
        sourceText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ReleaseWizardPage.this.checkIfPageComplete();
            }
        });
    }

    private void initTargetText(Text targetText) {
        targetText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ReleaseWizardPage.this.checkIfPageComplete();
            }
        });
    }

    private void initUpdateButton(final Button updateButton, final EPackage ePackage) {
        updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReleaseWizardPage.this.setTextEnablement(updateButton, ePackage);
                ReleaseWizardPage.this.checkIfPageComplete();
            }
        });
    }

    private Button createSelectAllButton(Composite parent, String label, final boolean select) {
        Button result = new Button(parent, 8);
        result.setText(label);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReleaseWizardPage.this.selectAll(select);
            }
        });
        return result;
    }

    private void selectAll(boolean select) {
        for (Map.Entry<EPackage, Button> next : this.packageToUpdateButton.entrySet()) {
            EPackage ePackage = next.getKey();
            Button checkbox = next.getValue();
            if (checkbox.getSelection() == select) continue;
            checkbox.setSelection(select);
            this.setTextEnablement(checkbox, ePackage);
        }
        this.checkIfPageComplete();
    }

    private void setTextEnablement(Button updateButton, EPackage ePackage) {
        String newTarget;
        String source;
        boolean selected = updateButton.getSelection();
        Text sourceText = this.packageToSourceText.get(ePackage);
        Text targetText = this.packageToTargetText.get(ePackage);
        sourceText.setEnabled(selected);
        targetText.setEnabled(selected);
        String target = targetText.getText().trim();
        if (selected && target.isEmpty() && !(source = sourceText.getText().trim()).equals(newTarget = URIUtils.incrementVersionSegment((String)source))) {
            targetText.setText(newTarget);
        }
    }

    private void checkIfPageComplete() {
        int i = 0;
        while (i < this.packages.size()) {
            EPackage ePackage = this.packages.get(i);
            Button updateButton = this.packageToUpdateButton.get(ePackage);
            Text sourceText = this.packageToSourceText.get(ePackage);
            Text targetText = this.packageToTargetText.get(ePackage);
            if (updateButton.getSelection()) {
                if (sourceText.getText().isEmpty()) {
                    this.setErrorMessage("Package at index " + (i + 1) + ":\n Label to match may not be empty");
                    this.setPageComplete(false);
                    return;
                }
                if (targetText.getText().isEmpty()) {
                    this.setErrorMessage("Package at index " + (i + 1) + ":\n Label to replace may not be empty");
                    this.setPageComplete(false);
                    return;
                }
                if (sourceText.getText().equals(targetText.getText())) {
                    this.setErrorMessage("Package at index " + (i + 1) + ":\n Source and target label may not be equal");
                    this.setPageComplete(false);
                    return;
                }
            }
            ++i;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    public String getSource(EPackage ePackage) {
        return this.packageToSourceText.get(ePackage).getText();
    }

    public String getTarget(EPackage ePackage) {
        return this.packageToTargetText.get(ePackage).getText();
    }

    public boolean isUpdate(EPackage ePackage) {
        return this.packageToUpdateButton.get(ePackage).getSelection();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.packageToTargetText.get(this.packages.get(0)).setFocus();
        }
    }

    public void setTarget(EPackage ePackage, String target) {
        this.packageToTargetText.get(ePackage).setText(target);
        this.checkIfPageComplete();
    }
}

