/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.inheritance;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.internal.common.MetamodelFactory;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="extractSubClass", label="Extract Subclass", description="In the metamodel, a feature is extracted into a new subclass and the feature is made mandatory. In the model, all instances of the superclass that have the feature set are migrated to the new subclass.", breaking=true)
public class ExtractSubClass
extends OperationImplementation {
    @EdaptParameter(main=true, description="The superclass from which the feature is extracted")
    public EClass superClass;
    @EdaptParameter(description="The feature to be extracted")
    public EStructuralFeature feature;
    @EdaptParameter(description="The name of the new subclass")
    public String className;

    @EdaptConstraint(restricts="feature", description="The feature has to belong to the super class")
    public boolean checkFeature(EStructuralFeature feature) {
        return this.superClass.getEStructuralFeatures().contains((Object)feature);
    }

    @EdaptConstraint(restricts="superClass", description="The super class may not have a sub class")
    public boolean checkSuperClassNoSubTypes(EClass superClass, Metamodel metamodel) {
        return metamodel.getESubTypes(superClass).isEmpty();
    }

    @Override
    public void execute(Metamodel metamodel, Model model) {
        EPackage ePackage = this.superClass.getEPackage();
        EClass subClass = MetamodelFactory.newEClass((EPackage)ePackage, (String)this.className, (EClass)this.superClass);
        subClass.getEStructuralFeatures().add((Object)this.feature);
        this.feature.setLowerBound(1);
        for (Instance instance : model.getInstances(this.superClass)) {
            if (!instance.isSet(this.feature)) continue;
            instance.migrate(subClass);
        }
    }
}

