/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.inheritance;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.edapt.common.MetamodelUtils;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="pushOperation", label="Push down Operation", description="In the metamodel, an operation is pushed down to its sub classes. In the model, nothing needs to be done.")
public class PushOperation
extends OperationImplementation {
    @EdaptParameter(main=true, description="The operation to be pushed down")
    public EOperation operation;

    public void execute(Metamodel metamodel, Model model) {
        EClass superClass = this.operation.getEContainingClass();
        EList subClasses = metamodel.getESubTypes(superClass);
        boolean first = true;
        for (EClass subClass : subClasses) {
            if (first) {
                subClass.getEOperations().add((Object)this.operation);
            } else {
                EOperation clone = (EOperation)MetamodelUtils.copy((EModelElement)this.operation);
                subClass.getEOperations().add((Object)clone);
            }
            first = false;
        }
    }
}

