/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.presentation.action;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edapt.common.LoggingUtils;
import org.eclipse.emf.edapt.common.URIUtils;
import org.eclipse.emf.edapt.history.MigrationChange;
import org.eclipse.emf.edapt.history.presentation.HistoryEditorPlugin;
import org.eclipse.emf.edapt.migration.CustomMigration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.OpenNewClassWizardAction;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.ide.IDE;

public final class JavaUIUtils {
    private JavaUIUtils() {
    }

    public static IType createCustomMigration(EObject element) {
        OpenNewClassWizardAction action = new OpenNewClassWizardAction();
        IProject project = JavaUIUtils.getProject(element);
        NewClassWizardPage page = new NewClassWizardPage();
        page.init((IStructuredSelection)new StructuredSelection((Object)project));
        page.setSuperClass(CustomMigration.class.getName(), true);
        action.setConfiguredWizardPage(page);
        action.run();
        IType type = (IType)action.getCreatedElement();
        return type;
    }

    private static IProject getProject(EObject element) {
        IFile file = URIUtils.getFile((URI)element.eResource().getURI());
        IProject project = file.getProject();
        return project;
    }

    public static void showCustomMigration(MigrationChange change) {
        IProject project = JavaUIUtils.getProject((EObject)change);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            IType type = javaProject.findType(change.getMigration());
            JavaUIUtils.openResource((IFile)type.getResource());
        }
        catch (JavaModelException e) {
            LoggingUtils.logError((Plugin)HistoryEditorPlugin.getPlugin(), (Throwable)e);
        }
    }

    public static IType selectCustomMigration(MigrationChange change) {
        IProject project = JavaUIUtils.getProject((EObject)change);
        try {
            IJavaSearchScope searchScope = null;
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IType superType = javaProject.findType(CustomMigration.class.getName());
            if (superType != null) {
                searchScope = SearchEngine.createHierarchyScope((IType)superType);
            }
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)Display.getDefault().getActiveShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)searchScope, (int)2, (boolean)false, (String)change.getMigration());
            dialog.setTitle("Select Custom Migration");
            if (dialog.open() == 0) {
                IType type = (IType)dialog.getResult()[0];
                return type;
            }
        }
        catch (JavaModelException e) {
            LoggingUtils.logError((Plugin)HistoryEditorPlugin.getPlugin(), (Throwable)e);
        }
        return null;
    }

    private static void openResource(IFile resource) {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null) {
            try {
                IDE.openEditor((IWorkbenchPage)activePage, (IFile)resource, (boolean)true);
            }
            catch (PartInitException e) {
                LoggingUtils.logError((Plugin)HistoryEditorPlugin.getPlugin(), (Throwable)e);
            }
        }
    }
}

