/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.mappingprovider.table;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.UniqueSetting;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.core.services.mappingprovider.EMFFormsMappingProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(name="EMFFormsMappingProviderTable")
public class EMFFormsMappingProviderTable
implements EMFFormsMappingProvider {
    private EMFFormsDatabindingEMF emfFormsDatabinding;
    private ReportService reportService;

    @Reference
    protected void setEMFFormsDatabinding(EMFFormsDatabindingEMF emfFormsDatabinding) {
        this.emfFormsDatabinding = emfFormsDatabinding;
    }

    @Reference
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public Set<UniqueSetting> getMappingFor(VDomainModelReference domainModelReference, EObject domainObject) {
        EStructuralFeature.Setting tableSetting;
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)domainObject).notNull();
        VTableDomainModelReference tableDMR = (VTableDomainModelReference)domainModelReference;
        try {
            tableSetting = this.emfFormsDatabinding.getSetting((VDomainModelReference)tableDMR, domainObject);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return Collections.emptySet();
        }
        LinkedHashSet<UniqueSetting> settingsMap = new LinkedHashSet<UniqueSetting>();
        settingsMap.add(UniqueSetting.createSetting((EStructuralFeature.Setting)tableSetting));
        for (EObject eObject : (List)tableSetting.get(true)) {
            for (VDomainModelReference columnDMR : tableDMR.getColumnDomainModelReferences()) {
                try {
                    EStructuralFeature.Setting columnSetting = this.emfFormsDatabinding.getSetting(columnDMR, eObject);
                    settingsMap.add(UniqueSetting.createSetting((EStructuralFeature.Setting)columnSetting));
                }
                catch (DatabindingFailedException ex) {
                    this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                }
            }
        }
        return settingsMap;
    }

    public double isApplicable(VDomainModelReference domainModelReference, EObject domainObject) {
        if (domainModelReference == null) {
            this.reportService.report(new AbstractReport("Warning: The given VDomainModelReference was null."));
            return Double.NEGATIVE_INFINITY;
        }
        if (domainObject == null) {
            this.reportService.report(new AbstractReport("Warning: The given domain object was null."));
            return Double.NEGATIVE_INFINITY;
        }
        if (VTableDomainModelReference.class.isInstance(domainModelReference)) {
            return 5.0;
        }
        return Double.NEGATIVE_INFINITY;
    }
}

