/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.legacy;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecp.view.spi.context.EMFFormsLegacyServicesManager;
import org.eclipse.emf.ecp.view.spi.context.GlobalViewModelService;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emfforms.internal.core.services.legacy.EMFFormsLegacyGlobalServiceFactory;
import org.eclipse.emfforms.internal.core.services.legacy.EMFFormsLegacyLocalServiceFactory;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewServiceFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component
public class EMFFormsLegacyServicesManagerImpl
implements EMFFormsLegacyServicesManager {
    private ReportService reportService;
    private final Set<ServiceRegistration<EMFFormsViewServiceFactory>> registrations = new LinkedHashSet<ServiceRegistration<EMFFormsViewServiceFactory>>();
    private BundleContext bundleContext;
    private boolean instantiated;

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    protected void unsetReportService(ReportService reportService) {
        this.reportService = null;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Deactivate
    protected void deactivate() {
        for (ServiceRegistration<EMFFormsViewServiceFactory> registration : this.registrations) {
            registration.unregister();
        }
        this.registrations.clear();
    }

    private Set<EMFFormsViewServiceFactory<? extends ViewModelService>> parseExtensions() {
        IConfigurationElement[] controls;
        LinkedHashSet<EMFFormsViewServiceFactory<? extends ViewModelService>> legacyServiceProviders = new LinkedHashSet<EMFFormsViewServiceFactory<? extends ViewModelService>>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return legacyServiceProviders;
        }
        IConfigurationElement[] iConfigurationElementArray = controls = extensionRegistry.getConfigurationElementsFor("org.eclipse.emf.ecp.view.context.viewServices");
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                ViewModelService viewService = (ViewModelService)e.createExecutableExtension("class");
                if (GlobalViewModelService.class.isInstance(viewService)) {
                    legacyServiceProviders.add(new EMFFormsLegacyGlobalServiceFactory(viewService.getClass(), viewService.getPriority(), this.reportService));
                } else {
                    legacyServiceProviders.add(new EMFFormsLegacyLocalServiceFactory(viewService.getClass(), viewService.getPriority(), this.reportService));
                }
            }
            catch (CoreException e1) {
                this.reportService.report(new AbstractReport((Throwable)e1));
            }
            ++n2;
        }
        return legacyServiceProviders;
    }

    public void instantiate() {
        if (this.instantiated) {
            return;
        }
        Set<EMFFormsViewServiceFactory<? extends ViewModelService>> legacyServiceProviders = this.parseExtensions();
        for (EMFFormsViewServiceFactory<? extends ViewModelService> provider : legacyServiceProviders) {
            ServiceRegistration registerService = this.bundleContext.registerService(EMFFormsViewServiceFactory.class, provider, null);
            this.registrations.add((ServiceRegistration<EMFFormsViewServiceFactory>)registerService);
        }
        this.instantiated = true;
    }
}

