/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.template.tooling.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecp.view.template.internal.tooling.Activator;
import org.eclipse.emf.ecp.view.template.internal.tooling.Messages;
import org.eclipse.emf.ecp.view.template.model.VTTemplateFactory;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplate;
import org.eclipse.emf.ecp.view.template.tooling.wizards.EMFFormsTemplateWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class EMFFormsTemplateWizard
extends Wizard
implements INewWizard {
    private EMFFormsTemplateWizardPage page;
    private ISelection selection;

    public EMFFormsTemplateWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new EMFFormsTemplateWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String containerName = this.page.getContainerName();
        final String fileName = this.page.getFileName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        EMFFormsTemplateWizard.this.doFinish(containerName, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.EMFFormsTemplateWizard_errorTitle, (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void addToPluginXML(IFile modelFile, IProgressMonitor monitor) {
        IProject project = modelFile.getProject();
        IFile pluginFile = project.getFile("plugin.xml");
        try {
            if (!pluginFile.exists()) {
                pluginFile.create((InputStream)new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?eclipse version=\"3.4\"?>\n<plugin>\n</plugin>".getBytes()), true, null);
                project.refreshLocal(2, null);
            }
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(pluginFile.getLocationURI().toString());
            Element element = doc.createElement("extension");
            element.setAttribute("point", "org.eclipse.emf.ecp.view.template");
            Element templateElement = doc.createElement("viewTemplate");
            templateElement.setAttribute("xmi", modelFile.getProjectRelativePath().toString());
            element.appendChild(templateElement);
            doc.getDocumentElement().appendChild(element);
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            StreamResult file = new StreamResult(pluginFile.getLocation().toFile());
            tf.transform(new DOMSource(doc), file);
        }
        catch (SAXException ex) {
            Activator.log(ex);
        }
        catch (IOException ex) {
            Activator.log(ex);
        }
        catch (ParserConfigurationException ex) {
            Activator.log(ex);
        }
        catch (TransformerException ex) {
            Activator.log(ex);
        }
        catch (CoreException ex) {
            Activator.log((Exception)((Object)ex));
        }
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.valueOf(Messages.EMFFormsTemplateWizard_creatingTask) + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException(String.format("Container \"%s\" does not exist.", containerName));
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            VTViewTemplate template = VTTemplateFactory.eINSTANCE.createViewTemplate();
            ResourceSetImpl rs = new ResourceSetImpl();
            Resource templateResource = rs.createResource(URI.createURI((String)file.getLocationURI().toString()));
            templateResource.getContents().add((Object)template);
            templateResource.save(null);
            container.refreshLocal(1, monitor);
        }
        catch (IOException iOException) {}
        monitor.worked(1);
        monitor.setTaskName(Messages.EMFFormsTemplateWizard_editingTask);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
        this.addToPluginXML(file, monitor);
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.emf.ecp.view.template.tooling", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

