/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.core.swt.renderer;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.util.DateUtil;
import org.eclipse.emf.ecp.edit.spi.swt.util.ECPDialogExecutor;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.renderer.TextControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.util.swt.ImageRegistryService;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emfforms.spi.common.locale.EMFFormsLocaleChangeListener;
import org.eclipse.emfforms.spi.common.locale.EMFFormsLocaleProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.FrameworkUtil;

public class XMLDateControlSWTRenderer
extends TextControlSWTRenderer {
    private final EMFFormsLocaleProvider localeProvider;
    private final EMFFormsLocalizationService localizationService;
    private final ImageRegistryService imageRegistryService;
    private static final DateFormat CHECK_FORMAT = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
    private static final Pattern CHECK_PATTERN = Pattern.compile("^\\d{4}-\\d{2}-\\d{2}$");
    private Shell dialog;
    private EMFFormsLocaleChangeListener emfFormsLocaleChangeListener;

    @Inject
    public XMLDateControlSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsEditSupport emfFormsEditSupport, EMFFormsLocalizationService localizationService, EMFFormsLocaleProvider localeProvider, ImageRegistryService imageRegistryService) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, emfFormsEditSupport);
        this.localizationService = localizationService;
        this.localeProvider = localeProvider;
        this.imageRegistryService = imageRegistryService;
    }

    @Override
    protected Control createSWTControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(main);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)main);
        Text text = (Text)super.createSWTControl(main);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)text);
        Button bDate = new Button(main, 8);
        GridDataFactory.fillDefaults().grab(false, false).align(0x1000000, 0x1000000).applyTo((Control)bDate);
        bDate.setImage(this.imageRegistryService.getImage(FrameworkUtil.getBundle(((Object)((Object)this)).getClass()), "icons/date.png"));
        bDate.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_xmldate");
        return main;
    }

    @Override
    protected String getTextMessage() {
        return ((SimpleDateFormat)this.setupFormat()).toPattern();
    }

    @Override
    protected String getTextVariantID() {
        return "org_eclipse_emf_ecp_control_xmldate";
    }

    @Override
    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        EStructuralFeature structuralFeature = (EStructuralFeature)this.getModelValue().getValueType();
        final Text text = (Text)((Composite)control).getChildren()[0];
        Button button = (Button)((Composite)control).getChildren()[1];
        button.addSelectionListener((SelectionListener)new SelectionAdapterExtension(text, button, this.getModelValue(), this.getViewModelContext(), this.getDataBindingContext(), structuralFeature));
        ISWTObservableValue value = SWTObservables.observeText((Control)text, (int)16);
        DateTargetToModelUpdateStrategy targetToModelUpdateStrategy = new DateTargetToModelUpdateStrategy(structuralFeature, this.getModelValue(), this.getDataBindingContext(), text);
        DateModelToTargetUpdateStrategy modelToTargetUpdateStrategy = new DateModelToTargetUpdateStrategy(false);
        final Binding binding = this.getDataBindingContext().bindValue((IObservableValue)value, this.getModelValue(), (UpdateValueStrategy)targetToModelUpdateStrategy, (UpdateValueStrategy)modelToTargetUpdateStrategy);
        Binding tooltipBinding = this.createTooltipBinding(control, this.getModelValue(), this.getDataBindingContext(), (UpdateValueStrategy)targetToModelUpdateStrategy, (UpdateValueStrategy)new DateModelToTargetUpdateStrategy(true));
        this.emfFormsLocaleChangeListener = new EMFFormsLocaleChangeListener(){

            public void notifyLocaleChange() {
                text.setMessage(XMLDateControlSWTRenderer.this.getTextMessage());
                binding.updateModelToTarget();
            }
        };
        this.localeProvider.addEMFFormsLocaleChangeListener(this.emfFormsLocaleChangeListener);
        return new Binding[]{binding, tooltipBinding};
    }

    protected DateFormat setupFormat() {
        DateFormat df = DateFormat.getDateInstance(2, this.localeProvider.getLocale());
        df.setLenient(false);
        return df;
    }

    @Override
    protected void setValidationColor(Control control, Color validationColor) {
        ((Composite)control).getChildren()[0].setBackground(validationColor);
    }

    @Override
    protected void setControlEnabled(SWTGridCell gridCell, Control control, boolean enabled) {
        if (((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.NONE && gridCell.getColumn() == 1 || this.hasLeftLabelAlignment() && gridCell.getColumn() == 2) {
            ((Text)((Composite)control).getChildren()[0]).setEditable(enabled);
            ((Button)((Composite)control).getChildren()[1]).setVisible(enabled);
        } else {
            super.setControlEnabled(gridCell, control, enabled);
        }
    }

    @Override
    protected String getUnsetText() {
        return this.localizationService.getString(((Object)((Object)this)).getClass(), "XmlDateControlText_NoDateSetClickToSetDate");
    }

    @Override
    protected void dispose() {
        if (this.dialog != null && !this.dialog.isDisposed()) {
            this.dialog.dispose();
        }
        this.localeProvider.removeEMFFormsLocaleChangeListener(this.emfFormsLocaleChangeListener);
        super.dispose();
    }

    private class DateModelToTargetUpdateStrategy
    extends TextControlSWTRenderer.ModelToTargetUpdateStrategy {
        public DateModelToTargetUpdateStrategy(boolean tooltip) {
            super(tooltip);
        }

        @Override
        public Object convertValue(Object value) {
            DateFormat format = XMLDateControlSWTRenderer.this.setupFormat();
            XMLGregorianCalendar gregorianCalendar = (XMLGregorianCalendar)value;
            if (gregorianCalendar == null) {
                return null;
            }
            Date date = gregorianCalendar.toGregorianCalendar().getTime();
            return format.format(date);
        }
    }

    private class DateTargetToModelUpdateStrategy
    extends TextControlSWTRenderer.TargetToModelUpdateStrategy {
        private final EStructuralFeature eStructuralFeature;
        private final Text text;
        private final IObservableValue modelValue;

        DateTargetToModelUpdateStrategy(EStructuralFeature eStructuralFeature, IObservableValue modelValue, DataBindingContext dataBindingContext, Text text) {
            super(eStructuralFeature.isUnsettable());
            this.eStructuralFeature = eStructuralFeature;
            this.modelValue = modelValue;
            this.text = text;
        }

        @Override
        protected Object convertValue(Object value) {
            try {
                Date date = null;
                if (String.class.isInstance(value)) {
                    date = XMLDateControlSWTRenderer.this.setupFormat().parse((String)value);
                } else if (Date.class.isInstance(value)) {
                    date = (Date)value;
                } else if (value == null) {
                    return value;
                }
                String xmlFormat = CHECK_FORMAT.format(date);
                if (!CHECK_PATTERN.matcher(xmlFormat).matches()) {
                    return this.revertToOldValue(value);
                }
                String formatedDate = XMLDateControlSWTRenderer.this.setupFormat().format(date);
                this.text.setText(formatedDate);
                Calendar targetCal = Calendar.getInstance();
                targetCal.setTime(date);
                return DateUtil.convertOnlyDateToXMLGregorianCalendar((Calendar)targetCal);
            }
            catch (ParseException parseException) {
                return this.revertToOldValue(value);
            }
        }

        private Object revertToOldValue(Object value) {
            if (this.eStructuralFeature.getDefaultValue() == null && (value == null || value.equals(""))) {
                return null;
            }
            Object result = this.modelValue.getValue();
            MessageDialog messageDialog = new MessageDialog(this.text.getShell(), LocalizationServiceHelper.getString(((Object)((Object)this)).getClass(), (String)"XmlDateControlText_InvalidNumber"), null, LocalizationServiceHelper.getString(((Object)((Object)this)).getClass(), (String)"XmlDateControlText_NumberInvalidValueWillBeUnset"), 1, new String[]{JFaceResources.getString((String)"ok")}, 0);
            new ECPDialogExecutor((Dialog)messageDialog){

                public void handleResult(int codeResult) {
                }
            }.execute();
            XMLDateControlSWTRenderer.this.getDataBindingContext().updateTargets();
            if (this.eStructuralFeature.isUnsettable() && result == null) {
                return SetCommand.UNSET_VALUE;
            }
            return result;
        }
    }

    private final class SelectionAdapterExtension
    extends SelectionAdapter {
        private final Control button;
        private final IObservableValue modelValue;
        private final ViewModelContext viewModelContext;
        private final DataBindingContext dataBindingContext;
        private final Text text;
        private final EStructuralFeature eStructuralFeature;

        private SelectionAdapterExtension(Text text, Button button, IObservableValue modelValue, ViewModelContext viewModelContext, DataBindingContext dataBindingContext, EStructuralFeature eStructuralFeature) {
            this.text = text;
            this.button = button;
            this.modelValue = modelValue;
            this.viewModelContext = viewModelContext;
            this.dataBindingContext = dataBindingContext;
            this.eStructuralFeature = eStructuralFeature;
        }

        public void widgetSelected(SelectionEvent e) {
            if (XMLDateControlSWTRenderer.this.dialog != null && !XMLDateControlSWTRenderer.this.dialog.isDisposed()) {
                XMLDateControlSWTRenderer.this.dialog.dispose();
                return;
            }
            XMLDateControlSWTRenderer.this.dialog = new Shell(this.button.getShell(), 0);
            XMLDateControlSWTRenderer.this.dialog.setLayout((Layout)new GridLayout(1, false));
            DateTime calendar = new DateTime((Composite)XMLDateControlSWTRenderer.this.dialog, 3072);
            XMLGregorianCalendar gregorianCalendar = (XMLGregorianCalendar)this.modelValue.getValue();
            Calendar cal = Calendar.getInstance(XMLDateControlSWTRenderer.this.localeProvider.getLocale());
            if (gregorianCalendar != null) {
                cal.setTime(gregorianCalendar.toGregorianCalendar().getTime());
            }
            calendar.setDate(cal.get(1), cal.get(2), cal.get(5));
            ISWTObservableValue dateObserver = SWTObservables.observeSelection((Control)calendar);
            final Binding binding = this.dataBindingContext.bindValue((IObservableValue)dateObserver, this.modelValue, (UpdateValueStrategy)new DateTargetToModelUpdateStrategy(this.eStructuralFeature, this.modelValue, this.dataBindingContext, this.text), (UpdateValueStrategy)new DateModelToTargetUpdateStrategy(false));
            binding.updateModelToTarget();
            Button okButton = new Button((Composite)XMLDateControlSWTRenderer.this.dialog, 8);
            okButton.setText(JFaceResources.getString((String)"ok"));
            GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(false, false).applyTo((Control)okButton);
            okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    binding.updateTargetToModel();
                    binding.dispose();
                    XMLDateControlSWTRenderer.this.dialog.close();
                }
            });
            XMLDateControlSWTRenderer.this.dialog.pack();
            XMLDateControlSWTRenderer.this.dialog.layout();
            Point dialogSize = XMLDateControlSWTRenderer.this.dialog.getSize();
            Rectangle displayBounds = XMLDateControlSWTRenderer.this.dialog.getDisplay().getBounds();
            Point buttonLocation = this.button.toDisplay(this.button.getSize().x, this.button.getSize().y);
            int dialogX = buttonLocation.x - dialogSize.x;
            int dialogY = buttonLocation.y;
            if (dialogY + dialogSize.y > displayBounds.height) {
                dialogY = dialogY - this.button.getSize().y - dialogSize.y;
            }
            if (dialogX + dialogSize.x > displayBounds.width) {
                dialogX -= dialogSize.x;
            } else if (dialogX - dialogSize.x < displayBounds.x) {
                dialogX = buttonLocation.x - this.button.getSize().x;
            }
            XMLDateControlSWTRenderer.this.dialog.setLocation(dialogX, dialogY);
            XMLDateControlSWTRenderer.this.dialog.open();
        }
    }
}

