/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.swt;

import javax.inject.Inject;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.edit.spi.swt.util.ECPDialogExecutor;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.model.util.ViewModelPropertiesHelper;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.swt.DetailDialog;
import org.eclipse.emf.ecp.view.spi.table.swt.TableControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.table.swt.action.TableActionIconButton;
import org.eclipse.emf.ecp.view.spi.table.swt.action.TableRendererAction;
import org.eclipse.emf.ecp.view.spi.table.swt.action.TableRendererViewerActionContext;
import org.eclipse.emf.ecp.view.spi.util.swt.ImageRegistryService;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.eclipse.emfforms.spi.swt.table.action.Action;
import org.eclipse.emfforms.spi.swt.table.action.ActionConfiguration;
import org.eclipse.emfforms.spi.swt.table.action.ActionConfigurationBuilder;
import org.eclipse.emfforms.spi.swt.table.action.ActionControlCreator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class TableControlDetailDialogSWTRenderer
extends TableControlSWTRenderer {
    private Button detailEditButton;
    private VView view;

    @Deprecated
    public TableControlDetailDialogSWTRenderer(VTableControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabindingEMF emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, ImageRegistryService imageRegistryService, EMFFormsEditSupport emfFormsEditSupport) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, imageRegistryService, emfFormsEditSupport);
    }

    @Inject
    public TableControlDetailDialogSWTRenderer(VTableControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabindingEMF emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, ImageRegistryService imageRegistryService, EMFFormsEditSupport emfFormsEditSupport, EMFFormsLocalizationService localizationService) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, imageRegistryService, emfFormsEditSupport, localizationService);
    }

    @Override
    protected int addButtonsToButtonBar(Composite buttonComposite) {
        this.createDetailEditButton(buttonComposite);
        return 1;
    }

    private void createDetailEditButton(Composite buttonComposite) {
        this.detailEditButton = new Button(buttonComposite, 8);
        this.detailEditButton.setImage(this.getImage("icons/detailEdit.png"));
        this.detailEditButton.setEnabled(false);
        this.detailEditButton.addSelectionListener((SelectionListener)new DetailEditButtonSelectionAdapter(buttonComposite.getShell()));
    }

    private VView getView() {
        if (this.view == null) {
            VView detailView = ((VTableControl)this.getVElement()).getDetailView();
            if (detailView == null) {
                IEMFValueProperty valueProperty;
                try {
                    valueProperty = this.getEMFFormsDatabinding().getValueProperty(((VTableControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
                }
                catch (DatabindingFailedException ex) {
                    this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                    return null;
                }
                EReference reference = (EReference)valueProperty.getValueType();
                VElement viewModel = this.getViewModelContext().getViewModel();
                VViewModelProperties properties = ViewModelPropertiesHelper.getInhertitedPropertiesOrEmpty((VElement)viewModel);
                detailView = ViewProviderHelper.getView((EObject)EcoreUtil.create((EClass)reference.getEReferenceType()), (VViewModelProperties)properties);
            }
            this.view = detailView;
        }
        VView copy = (VView)EcoreUtil.copy((EObject)this.view);
        copy.setReadonly(!((VTableControl)this.getVElement()).isEffectivelyEnabled() || ((VTableControl)this.getVElement()).isEffectivelyReadonly() || copy.isReadonly());
        return copy;
    }

    @Override
    protected void viewerSelectionChanged(SelectionChangedEvent event) {
        if (event.getSelection().isEmpty()) {
            if (this.detailEditButton != null) {
                this.detailEditButton.setEnabled(false);
            }
        } else if (this.detailEditButton != null && ((IStructuredSelection)IStructuredSelection.class.cast(event.getSelection())).size() == 1) {
            this.detailEditButton.setEnabled(true);
        }
        super.viewerSelectionChanged(event);
    }

    @Override
    protected ActionConfiguration configureActions(TableRendererViewerActionContext actionContext) {
        ActionConfigurationBuilder actionConfigBuilder = ActionConfigurationBuilder.usingConfiguration((ActionConfiguration)super.configureActions(actionContext));
        DetailEditAction detailEditAction = new DetailEditAction(actionContext);
        EStructuralFeature.Setting setting = actionContext.getSetting();
        EClass eClass = ((EReference)setting.getEStructuralFeature()).getEReferenceType();
        actionConfigBuilder.addAction((Action)detailEditAction).addControlFor((Action)detailEditAction, (ActionControlCreator)new TableActionIconButton(this.formatTooltipText(eClass, "TableControl_DetailEdit"), this.getImage("icons/detailEdit.png")));
        return actionConfigBuilder.build();
    }

    @Override
    protected void dispose() {
        this.detailEditButton = null;
        super.dispose();
    }

    private Dialog createDialog(Shell shell) {
        Object dialog = this.getTableViewer().getSelection().isEmpty() ? new MessageDialog(shell, "No Table Selection", null, "You must select one element in order to edit it.", 4, new String[]{JFaceResources.getString((String)"ok")}, 0) : (this.getView() == null ? new MessageDialog(shell, "No View Model", null, "Detail editing is not possible since there is no UI description for the selection.", 1, new String[]{JFaceResources.getString((String)"ok")}, 0) : new DetailDialog(shell, (EObject)((IStructuredSelection)IStructuredSelection.class.cast(this.getTableViewer().getSelection())).getFirstElement(), (VTableControl)this.getVElement(), this.getView()));
        return dialog;
    }

    private class DetailEditAction
    extends TableRendererAction {
        public static final String ACTION_ID = "org.eclipse.emfforms.action.tablecontrol.dialog_edit";

        DetailEditAction(TableRendererViewerActionContext actionContext) {
            super(actionContext);
        }

        public String getId() {
            return ACTION_ID;
        }

        public void execute() {
            Dialog dialog = TableControlDetailDialogSWTRenderer.this.createDialog(this.getTableViewer().getControl().getShell());
            new ECPDialogExecutor(dialog){

                public void handleResult(int codeResult) {
                }
            }.execute();
        }

        public boolean canExecute() {
            return !this.getTableViewer().getSelection().isEmpty();
        }
    }

    @Deprecated
    private class DetailEditButtonSelectionAdapter
    extends SelectionAdapter {
        private final Shell shell;

        DetailEditButtonSelectionAdapter(Shell shell) {
            this.shell = shell;
        }

        public void widgetSelected(SelectionEvent e) {
            super.widgetSelected(e);
            Dialog dialog = TableControlDetailDialogSWTRenderer.this.createDialog(this.shell);
            new ECPDialogExecutor(dialog){

                public void handleResult(int codeResult) {
                }
            }.execute();
        }
    }
}

