/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.swt;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecp.edit.internal.swt.controls.ECPFocusCellDrawHighlighter;
import org.eclipse.emf.ecp.edit.spi.DeleteService;
import org.eclipse.emf.ecp.edit.spi.EMFDeleteServiceImpl;
import org.eclipse.emf.ecp.edit.spi.ReferenceService;
import org.eclipse.emf.ecp.edit.spi.swt.table.ECPCellEditor;
import org.eclipse.emf.ecp.edit.spi.swt.table.ECPCellEditorComparator;
import org.eclipse.emf.ecp.edit.spi.swt.table.ECPCustomUpdateCellEditor;
import org.eclipse.emf.ecp.edit.spi.swt.table.ECPElementAwareCellEditor;
import org.eclipse.emf.ecp.edit.spi.swt.table.ECPViewerAwareCellEditor;
import org.eclipse.emf.ecp.edit.spi.swt.util.ECPDialogExecutor;
import org.eclipse.emf.ecp.view.internal.table.swt.Activator;
import org.eclipse.emf.ecp.view.internal.table.swt.CellReadOnlyTesterHelper;
import org.eclipse.emf.ecp.view.internal.table.swt.RunnableManager;
import org.eclipse.emf.ecp.view.internal.table.swt.TableConfigurationHelper;
import org.eclipse.emf.ecp.view.model.common.util.RendererUtil;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.AbstractControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.core.swt.AbstractControlSWTRendererUtil;
import org.eclipse.emf.ecp.view.spi.model.DiagnosticMessageExtractor;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.provider.ECPTooltipModifierHelper;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.ecp.view.spi.table.model.VEnablementConfiguration;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emf.ecp.view.spi.table.swt.CellEditorFactory;
import org.eclipse.emf.ecp.view.spi.table.swt.Messages;
import org.eclipse.emf.ecp.view.spi.table.swt.TableControlService;
import org.eclipse.emf.ecp.view.spi.table.swt.action.AddRowAction;
import org.eclipse.emf.ecp.view.spi.table.swt.action.DuplicateRowAction;
import org.eclipse.emf.ecp.view.spi.table.swt.action.MoveRowDownAction;
import org.eclipse.emf.ecp.view.spi.table.swt.action.MoveRowUpAction;
import org.eclipse.emf.ecp.view.spi.table.swt.action.RemoveRowAction;
import org.eclipse.emf.ecp.view.spi.table.swt.action.TableActionIconButton;
import org.eclipse.emf.ecp.view.spi.table.swt.action.TableRendererActionBar;
import org.eclipse.emf.ecp.view.spi.table.swt.action.TableRendererViewerActionContext;
import org.eclipse.emf.ecp.view.spi.util.swt.ImageRegistryService;
import org.eclipse.emf.ecp.view.template.model.VTStyleProperty;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.ecp.view.template.style.background.model.VTBackgroundFactory;
import org.eclipse.emf.ecp.view.template.style.background.model.VTBackgroundStyleProperty;
import org.eclipse.emf.ecp.view.template.style.fontProperties.model.VTFontPropertiesFactory;
import org.eclipse.emf.ecp.view.template.style.fontProperties.model.VTFontPropertiesStyleProperty;
import org.eclipse.emf.ecp.view.template.style.keybinding.model.VTKeyBinding;
import org.eclipse.emf.ecp.view.template.style.keybinding.model.VTKeyBindings;
import org.eclipse.emf.ecp.view.template.style.tableStyleProperty.model.RenderMode;
import org.eclipse.emf.ecp.view.template.style.tableStyleProperty.model.VTTableStyleProperty;
import org.eclipse.emf.ecp.view.template.style.tableStyleProperty.model.VTTableStylePropertyFactory;
import org.eclipse.emf.ecp.view.template.style.tableValidation.model.VTTableValidationFactory;
import org.eclipse.emf.ecp.view.template.style.tableValidation.model.VTTableValidationStyleProperty;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.common.sort.NumberAwareStringComparator;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.core.services.label.NoLabelFoundException;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.SWTDataElementIdHelper;
import org.eclipse.emfforms.spi.swt.core.layout.EMFFormsSWTLayoutUtil;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.emfforms.spi.swt.table.AbstractTableViewerComposite;
import org.eclipse.emfforms.spi.swt.table.CellLabelProviderFactory;
import org.eclipse.emfforms.spi.swt.table.ColumnConfiguration;
import org.eclipse.emfforms.spi.swt.table.ColumnConfigurationBuilder;
import org.eclipse.emfforms.spi.swt.table.CompactVerticallyTableViewerCompositeBuilder;
import org.eclipse.emfforms.spi.swt.table.DNDProvider;
import org.eclipse.emfforms.spi.swt.table.DefaultTableViewerCompositeBuilder;
import org.eclipse.emfforms.spi.swt.table.EditingSupportCreator;
import org.eclipse.emfforms.spi.swt.table.TableConfigurationBuilder;
import org.eclipse.emfforms.spi.swt.table.TableControl;
import org.eclipse.emfforms.spi.swt.table.TableViewerComparator;
import org.eclipse.emfforms.spi.swt.table.TableViewerCompositeBuilder;
import org.eclipse.emfforms.spi.swt.table.TableViewerCreator;
import org.eclipse.emfforms.spi.swt.table.TableViewerFactory;
import org.eclipse.emfforms.spi.swt.table.TableViewerSWTBuilder;
import org.eclipse.emfforms.spi.swt.table.TableViewerSWTCustomization;
import org.eclipse.emfforms.spi.swt.table.action.Action;
import org.eclipse.emfforms.spi.swt.table.action.ActionBar;
import org.eclipse.emfforms.spi.swt.table.action.ActionConfiguration;
import org.eclipse.emfforms.spi.swt.table.action.ActionConfigurationBuilder;
import org.eclipse.emfforms.spi.swt.table.action.ActionControlCreator;
import org.eclipse.emfforms.spi.swt.table.action.TableActionBar;
import org.eclipse.emfforms.view.spi.multisegment.model.MultiSegmentUtil;
import org.eclipse.emfforms.view.spi.multisegment.model.VMultiDomainModelReferenceSegment;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapCellLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.FrameworkUtil;

public class TableControlSWTRenderer
extends AbstractControlSWTRenderer<VTableControl> {
    protected static final String FIXED_COLUMNS = "org.eclipse.rap.rwt.fixedColumns";
    protected static final String TABLE_CUSTOM_VARIANT = "org_eclipse_emf_ecp_control_table";
    protected static final Point VALIDATION_PREFERRED_SIZE = new Point(16, 17);
    private final Map<Integer, ECPCellEditorComparator> columnIndexToComparatorMap = new LinkedHashMap<Integer, ECPCellEditorComparator>();
    private final ImageRegistryService imageRegistryService;
    private final EMFDataBindingContext viewModelDBC;
    private final EMFFormsEditSupport emfFormsEditSupport;
    private SWTGridDescription rendererGridDescription;
    private AbstractTableViewer tableViewer;
    private Label validationIcon;
    private boolean showValidationSummaryTooltip;
    private org.eclipse.emfforms.common.Optional<Integer> minimumHeight;
    private org.eclipse.emfforms.common.Optional<Integer> maximumHeight;
    private org.eclipse.emfforms.common.Optional<Integer> visibleLines;
    private AbstractTableViewerComposite<? extends AbstractTableViewer> tableViewerComposite;
    private int regularColumnsStartIndex;
    private boolean isDisposing;
    private IObservableList<?> list;
    private final RunnableManager runnableManager = new RunnableManager(Display.getDefault());
    private TableViewerSWTCustomization<?> customization;
    private EReference tableEReference;
    private EStructuralFeature[] columnFeatures;
    private Optional<EStructuralFeature> sortColumnFeature = Optional.empty();
    private ModelChangeListener autoSortModelChangeListener;

    @Inject
    public TableControlSWTRenderer(VTableControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabindingEMF emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, ImageRegistryService imageRegistryService, EMFFormsEditSupport emfFormsEditSupport) {
        super((VControl)vElement, viewContext, reportService, (EMFFormsDatabinding)emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
        this.imageRegistryService = imageRegistryService;
        this.emfFormsEditSupport = emfFormsEditSupport;
        this.viewModelDBC = new EMFDataBindingContext();
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            if (this.getTableStyleProperty().getRenderMode() == RenderMode.COMPACT_VERTICALLY) {
                boolean includeLabel;
                boolean bl = includeLabel = ((VTableControl)this.getVElement()).getLabelAlignment() != LabelAlignment.NONE;
                if (((VTableControl)this.getVElement()).getLabelAlignment() == LabelAlignment.TOP) {
                    Activator.getInstance().log(2, MessageFormat.format(Messages.TableControlSWTRenderer_LabelAlignmentTopNotSupportForRenderModeCompactVertically, ((VTableControl)this.getVElement()).getName()));
                }
                this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createCompactGrid(includeLabel, true, (AbstractSWTRenderer)this);
            } else {
                this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
            }
        }
        return this.rendererGridDescription;
    }

    protected EMFFormsDatabindingEMF getEMFFormsDatabinding() {
        return (EMFFormsDatabindingEMF)super.getEMFFormsDatabinding();
    }

    protected Control renderControl(SWTGridCell gridCell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        if (gridCell.getColumn() == 0 && this.rendererGridDescription.getColumns() == 3) {
            return this.createLabel(parent);
        }
        if (gridCell.getColumn() == 0 && this.rendererGridDescription.getColumns() == 2 || gridCell.getColumn() == 1 && this.rendererGridDescription.getColumns() == 3) {
            this.validationIcon = this.createValidationIcon(parent);
            return this.validationIcon;
        }
        return this.renderTableControl(gridCell, parent);
    }

    protected Control createLabel(Composite parent) {
        VDomainModelReference dmrToCheck = this.getDMRToMultiReference();
        IObservableValue<?> labelText = this.getLabelText(dmrToCheck);
        IObservableValue<?> labelTooltipText = this.getLabelTooltipText(dmrToCheck);
        Label titleLabel = new Label(parent, AbstractControlSWTRendererUtil.getLabelStyleBits((VTViewTemplateProvider)this.getVTViewTemplateProvider(), (VElement)this.getVElement(), (ViewModelContext)this.getViewModelContext()));
        titleLabel.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_label");
        titleLabel.setBackground(parent.getBackground());
        this.viewModelDBC.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)titleLabel), labelText);
        this.viewModelDBC.bindValue((IObservableValue)WidgetProperties.tooltipText().observe((Widget)titleLabel), labelTooltipText);
        return titleLabel;
    }

    protected Control renderTableControl(SWTGridCell gridCell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        try {
            VDomainModelReference dmrToCheck = this.getDMRToMultiReference();
            this.list = this.getEMFFormsDatabinding().getObservableList(dmrToCheck, this.getViewModelContext().getDomainModel());
            this.tableEReference = (EReference)this.list.getElementType();
            TableRendererViewerActionContext actionContext = this.createViewerActionContext();
            ActionConfiguration actionConfiguration = this.configureActions(actionContext);
            TableActionBar<? extends AbstractTableViewer> actionBar = this.createActionBar(actionContext, actionConfiguration);
            IObservableValue<?> labelText = this.getLabelText(dmrToCheck);
            IObservableValue<?> labelTooltipText = this.getLabelTooltipText(dmrToCheck);
            ObservableListContentProvider cp = new ObservableListContentProvider();
            ECPTableViewerComparator comparator = ((VTableControl)this.getVElement()).isMoveUpDownDisabled() ? new ECPTableViewerComparator() : null;
            TableViewerCompositeBuilder compositeBuilder = this.createTableViewerCompositeBuilder();
            TableViewerSWTBuilder tableViewerSWTBuilder = this.createTableViewerSWTBuilder(parent, this.list, labelText, labelTooltipText, compositeBuilder, cp, comparator, actionBar);
            tableViewerSWTBuilder.customizeActionConfiguration(actionConfiguration);
            tableViewerSWTBuilder.configureTable(TableConfigurationBuilder.from((TableViewerSWTBuilder)tableViewerSWTBuilder).dataMapEntry("domain_model_reference", (Object)dmrToCheck).build());
            this.regularColumnsStartIndex = 0;
            if (!((VTableControl)this.getVElement()).isEffectivelyReadonly()) {
                ++this.regularColumnsStartIndex;
                this.createFixedValidationStatusColumn(tableViewerSWTBuilder);
            }
            this.regularColumnsStartIndex += this.addAdditionalColumns(tableViewerSWTBuilder);
            this.addColumns(tableViewerSWTBuilder, ((EReference)EReference.class.cast(this.list.getElementType())).getEReferenceType(), cp);
            this.initCompositeHeight();
            this.tableViewerComposite = tableViewerSWTBuilder.build();
            this.tableViewerComposite.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)new ViewerSelectionChangedListener());
            this.tableViewerComposite.getTableViewer().addDoubleClickListener((IDoubleClickListener)new DoubleClickListener());
            if (((VTableControl)this.getVElement()).isMoveUpDownDisabled()) {
                this.setupSorting(comparator, this.regularColumnsStartIndex, this.tableViewerComposite);
            }
            this.setupValidation(this.tableViewerComposite);
            this.setTableViewer(this.tableViewerComposite.getTableViewer());
            SWTDataElementIdHelper.setElementIdDataForVControl(this.tableViewerComposite, (VControl)((VControl)this.getVElement()), (ViewModelContext)this.getViewModelContext());
            ((GridData)GridData.class.cast((Object)compositeBuilder.getViewerComposite().getLayoutData())).heightHint = this.getTableHeightHint();
            this.addRelayoutListenerIfNeeded(this.list, compositeBuilder.getViewerComposite());
            this.addResizeListener(this.tableViewerComposite.getTableViewer().getControl(), this.regularColumnsStartIndex);
            this.customization = tableViewerSWTBuilder.getCustomization();
            this.autoSortModelChangeListener = new AutoSortModelChangeListener();
            this.getViewModelContext().registerDomainChangeListener(this.autoSortModelChangeListener);
            return this.tableViewerComposite;
        }
        catch (DatabindingFailedException ex) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
            Label errorLabel = new Label(parent, 0);
            errorLabel.setText(ex.getMessage());
            return errorLabel;
        }
    }

    protected TableRendererViewerActionContext createViewerActionContext() {
        return new TableRendererViewerActionContext(){

            @Override
            public VTableControl getVElement() {
                return (VTableControl)TableControlSWTRenderer.this.getVElement();
            }

            public EStructuralFeature.Setting getSetting() {
                try {
                    return TableControlSWTRenderer.this.getEMFFormsDatabinding().getSetting(TableControlSWTRenderer.this.getDMRToMultiReference(), TableControlSWTRenderer.this.getViewModelContext().getDomainModel());
                }
                catch (DatabindingFailedException ex) {
                    return null;
                }
            }

            public EditingDomain getEditingDomain() {
                return TableControlSWTRenderer.this.getEditingDomain(TableControlSWTRenderer.this.getViewModelContext().getDomainModel());
            }

            public AbstractTableViewer getViewer() {
                return TableControlSWTRenderer.this.getTableViewer();
            }
        };
    }

    protected ActionConfiguration configureActions(TableRendererViewerActionContext actionContext) {
        ActionConfigurationBuilder actionConfigBuilder = ActionConfigurationBuilder.usingDefaults();
        if (((VTableControl)this.getVElement()).isEffectivelyReadonly()) {
            return actionConfigBuilder.build();
        }
        EStructuralFeature.Setting setting = actionContext.getSetting();
        EClass eClass = ((EReference)setting.getEStructuralFeature()).getEReferenceType();
        if (!((VTableControl)this.getVElement()).isMoveUpDownDisabled()) {
            MoveRowUpAction moveRowUpAction = new MoveRowUpAction(actionContext);
            MoveRowDownAction moveRowDownAction = new MoveRowDownAction(actionContext);
            actionConfigBuilder.addAction((Action)moveRowUpAction).addControlFor((Action)moveRowUpAction, (ActionControlCreator)new TableActionIconButton(this.formatTooltipText(eClass, "TableControl_MoveUp"), this.getImage("icons/move_up.png"))).addKeySequenceFor((Action)moveRowUpAction, this.getKeyBindingsForAction("org.eclipse.emfforms.action.tablecontrol.move_row_up", new String[0])).addAction((Action)moveRowDownAction).addControlFor((Action)moveRowDownAction, (ActionControlCreator)new TableActionIconButton(this.formatTooltipText(eClass, "TableControl_MoveDown"), this.getImage("icons/move_down.png"))).addKeySequenceFor((Action)moveRowDownAction, this.getKeyBindingsForAction("org.eclipse.emfforms.action.tablecontrol.move_row_down", new String[0]));
        }
        if (!((VTableControl)this.getVElement()).isAddRemoveDisabled()) {
            AddRowAction addRowAction = new AddRowAction(actionContext){

                @Override
                public void addRowLegacy(EClass eClass, EStructuralFeature eStructuralFeature, EObject eObject) {
                    TableControlSWTRenderer.this.addRow(eClass, eObject, eStructuralFeature);
                }
            };
            RemoveRowAction removeRowAction = new RemoveRowAction(actionContext){

                @Override
                public void removeRowLegacy(List<EObject> deletionList, EObject eObject, EStructuralFeature eStructuralFeature) {
                    TableControlSWTRenderer.this.deleteRowUserConfirmDialog(deletionList, eObject, eStructuralFeature, TableControlSWTRenderer.this.getAddButton(), TableControlSWTRenderer.this.getRemoveButton());
                }
            };
            actionConfigBuilder.addAction((Action)addRowAction).addControlFor((Action)addRowAction, (ActionControlCreator)new TableActionIconButton(this.formatTooltipText(eClass, "TableControl_AddInstanceOf"), this.getImage("icons/add.png"))).addKeySequenceFor((Action)addRowAction, this.getKeyBindingsForAction("org.eclipse.emfforms.action.tablecontrol.add_row", new String[0]));
            actionConfigBuilder.addAction((Action)removeRowAction).addControlFor((Action)removeRowAction, (ActionControlCreator)new TableActionIconButton(this.formatTooltipText(eClass, "TableControl_RemoveSelected"), this.getImage("icons/delete.png"))).addKeySequenceFor((Action)removeRowAction, this.getKeyBindingsForAction("org.eclipse.emfforms.action.tablecontrol.remove_row", new String[0]));
        }
        if (!((VTableControl)this.getVElement()).isDuplicateDisabled()) {
            DuplicateRowAction duplicateRow = new DuplicateRowAction(actionContext);
            actionConfigBuilder.addAction((Action)duplicateRow).addControlFor((Action)duplicateRow, (ActionControlCreator)new TableActionIconButton(this.formatTooltipText(eClass, "TableControl_Duplicate"), this.getImage("icons/duplicate.png"))).addKeySequenceFor((Action)duplicateRow, this.getKeyBindingsForAction("org.eclipse.emfforms.action.tablecontrol.duplicate_row", new String[0]));
        }
        return actionConfigBuilder.build();
    }

    protected String[] getKeyBindingsForAction(String actionId, String ... defaultKeybindings) {
        VTKeyBindings bindings = this.getStyleProperty(VTKeyBindings.class);
        if (bindings == null) {
            return defaultKeybindings;
        }
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        for (VTKeyBinding binding : bindings.getBindings()) {
            if (!actionId.equals(binding.getId()) || binding.getKeySequence() == null || binding.getKeySequence().isEmpty()) continue;
            ret.add(binding.getKeySequence());
        }
        return ret.toArray(new String[0]);
    }

    protected TableActionBar<? extends AbstractTableViewer> createActionBar(TableRendererViewerActionContext actionContext, ActionConfiguration actionConfiguration) {
        return new TableRendererActionBar(actionContext, actionConfiguration, this.getViewModelContext());
    }

    protected TableViewerCompositeBuilder createTableViewerCompositeBuilder() {
        if (this.getTableStyleProperty().getRenderMode() == RenderMode.COMPACT_VERTICALLY) {
            return new CompactVerticallyTableControlSWTRendererCompositeBuilder(false, false);
        }
        return new TableControlSWTRendererCompositeBuilder();
    }

    protected TableViewerSWTBuilder createTableViewerSWTBuilder(Composite parent, IObservableList list, IObservableValue labelText, IObservableValue labelTooltipText, TableViewerCompositeBuilder compositeBuilder, ObservableListContentProvider cp, ECPTableViewerComparator comparator, TableActionBar<? extends AbstractTableViewer> actionBar) {
        return TableViewerFactory.fillDefaults((Composite)parent, (int)0, (Object)list, (IObservableValue)labelText, (IObservableValue)labelTooltipText).customizeCompositeStructure(compositeBuilder).customizeActionBar(actionBar).customizeTableViewerCreation(this.getTableViewerCreator()).customizeContentProvider((IContentProvider)cp).customizeComparator((ViewerComparator)comparator).customizeDragAndDrop((DNDProvider)new TableControlSWTRendererDragAndDrop());
    }

    protected TableViewerCreator<? extends AbstractTableViewer> getTableViewerCreator() {
        return new TableControlSWTRendererTableViewerCreator();
    }

    protected int addAdditionalColumns(TableViewerSWTBuilder tableViewerSWTBuilder) {
        return 0;
    }

    protected int getSelectionIndex() {
        return ((TableViewer)this.tableViewer).getTable().getSelectionIndex();
    }

    protected Item[] getColumns() {
        return ((TableViewer)this.tableViewer).getTable().getColumns();
    }

    protected ScrollBar getHorizontalBar() {
        return ((TableViewer)this.tableViewer).getTable().getHorizontalBar();
    }

    protected ScrollBar getVerticalBar() {
        return ((TableViewer)this.tableViewer).getTable().getVerticalBar();
    }

    private void addResizeListener(final Control control, final int regularColumnsStartIndex) {
        ControlAdapter controlAdapter = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TableControlSWTRenderer.this.updateTableColumnWidths(control, regularColumnsStartIndex);
            }
        };
        control.addControlListener((ControlListener)controlAdapter);
        this.tableViewerComposite.addColumnListener((ControlListener)controlAdapter);
    }

    private void updateTableColumnWidths(Control table, int regularColumnsStartIndex) {
        if (this.isDisposing) {
            return;
        }
        VTableControl tableControl = (VTableControl)this.getVElement();
        Widget[] allColumns = this.tableViewerComposite.getColumns();
        int i = regularColumnsStartIndex;
        while (i < allColumns.length) {
            Widget tableColumn = allColumns[i];
            VDomainModelReference columnDMR = (VDomainModelReference)this.getColumnDomainModelReferences().get(i - regularColumnsStartIndex);
            TableConfigurationHelper.updateWidthConfiguration(tableControl, columnDMR, tableColumn);
            ++i;
        }
    }

    private void initCompositeHeight() {
        VTTableStyleProperty styleProperty = this.getTableStyleProperty();
        this.minimumHeight = styleProperty.isSetMinimumHeight() ? org.eclipse.emfforms.common.Optional.of((Object)styleProperty.getMinimumHeight()) : org.eclipse.emfforms.common.Optional.empty();
        this.maximumHeight = styleProperty.isSetMaximumHeight() ? org.eclipse.emfforms.common.Optional.of((Object)styleProperty.getMaximumHeight()) : org.eclipse.emfforms.common.Optional.empty();
        this.visibleLines = styleProperty.isSetVisibleLines() ? org.eclipse.emfforms.common.Optional.of((Object)styleProperty.getVisibleLines()) : org.eclipse.emfforms.common.Optional.empty();
    }

    private <T> void addRelayoutListenerIfNeeded(IObservableList<T> list, final Composite composite) {
        if (list == null) {
            return;
        }
        if (!this.minimumHeight.isPresent() && !this.maximumHeight.isPresent()) {
            return;
        }
        if (this.minimumHeight.isPresent() && this.maximumHeight.isPresent() && this.minimumHeight.get() == this.maximumHeight.get()) {
            return;
        }
        final GridData gridData = (GridData)GridData.class.cast(composite.getLayoutData());
        list.addListChangeListener(new IListChangeListener<T>(){

            public void handleListChange(ListChangeEvent<? extends T> event) {
                gridData.heightHint = TableControlSWTRenderer.this.getTableHeightHint();
                EMFFormsSWTLayoutUtil.adjustParentSize((Control)composite);
            }
        });
    }

    private void addColumns(TableViewerSWTBuilder tableViewerSWTBuilder, EClass clazz, ObservableListContentProvider cp) {
        InternalEObject tempInstance = null;
        if (!clazz.isAbstract() && !clazz.isInterface()) {
            tempInstance = this.getInstanceOf(clazz);
        }
        List columns = this.getColumnDomainModelReferences().stream().filter(Objects::nonNull).collect(Collectors.toList());
        this.columnFeatures = new EStructuralFeature[columns.size()];
        int i = 0;
        while (i < columns.size()) {
            try {
                int weight;
                int minWidth;
                EStructuralFeature eStructuralFeature;
                VDomainModelReference dmr = (VDomainModelReference)columns.get(i);
                IObservableValue<?> text = this.getLabelTextForColumn(dmr, clazz);
                IObservableValue<?> tooltip = this.getLabelTooltipTextForColumn(dmr, clazz);
                EditingDomain editingDomain = this.getEditingDomain(this.getViewModelContext().getDomainModel());
                IEMFValueProperty valueProperty = this.getEMFFormsDatabinding().getValueProperty(dmr, clazz, editingDomain);
                this.columnFeatures[i] = eStructuralFeature = (EStructuralFeature)valueProperty.getValueType();
                IObservableMap observableMap = valueProperty.observeDetail(cp.getKnownElements());
                TableControlEditingSupportAndLabelProvider labelProvider = new TableControlEditingSupportAndLabelProvider(tempInstance, eStructuralFeature, dmr, (IValueProperty)valueProperty, observableMap, this.getColumnDomainModelReferences().indexOf((Object)dmr));
                TableControlEditingSupportAndLabelProvider editingSupportCreator = TableConfigurationHelper.isReadOnly((VTableControl)this.getVElement(), dmr) ? null : labelProvider;
                org.eclipse.emfforms.common.Optional<Integer> weightConfig = TableConfigurationHelper.getColumnWeight((VTableControl)this.getVElement(), dmr);
                org.eclipse.emfforms.common.Optional<Integer> widthConfig = TableConfigurationHelper.getColumnWidth((VTableControl)this.getVElement(), dmr);
                if (weightConfig.isPresent()) {
                    minWidth = (Integer)widthConfig.get();
                    weight = (Integer)weightConfig.get();
                } else {
                    Shell tempShell = new Shell();
                    CellEditor tempCellEditor = this.createCellEditor((EObject)tempInstance, eStructuralFeature, (Composite)new Table((Composite)tempShell, 0));
                    weight = ECPCellEditor.class.isInstance(tempCellEditor) ? ((ECPCellEditor)ECPCellEditor.class.cast(tempCellEditor)).getColumnWidthWeight() : 100;
                    minWidth = ECPCellEditor.class.isInstance(tempCellEditor) ? ((ECPCellEditor)ECPCellEditor.class.cast(tempCellEditor)).getMinWidth() : 10;
                    tempShell.dispose();
                }
                tableViewerSWTBuilder.addColumn(ColumnConfigurationBuilder.from((TableViewerSWTBuilder)tableViewerSWTBuilder).weight(weight).minWidth(minWidth).text(text).tooltip(tooltip).labelProviderFactory((CellLabelProviderFactory)labelProvider).editingSupportCreator((EditingSupportCreator)editingSupportCreator).dataMapEntry("domain_model_reference", (Object)dmr).build());
            }
            catch (DatabindingFailedException ex) {
                this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
            }
            ++i;
        }
    }

    private void setupValidation(AbstractTableViewerComposite<? extends AbstractTableViewer> tableViewerComposite) {
        if (tableViewerComposite.getValidationControls().isPresent()) {
            List validationControls = (List)tableViewerComposite.getValidationControls().get();
            if (validationControls.size() == 1 && Label.class.isInstance(validationControls.get(0))) {
                this.validationIcon = (Label)validationControls.get(0);
            }
            VTTableStyleProperty tableStyleProperty = this.getTableStyleProperty();
            this.showValidationSummaryTooltip = tableStyleProperty.isShowValidationSummaryTooltip();
        }
    }

    private void setupSorting(ECPTableViewerComparator comparator, int regularColumnsStartIndex, AbstractTableViewerComposite<? extends AbstractTableViewer> tableViewerComposite) {
        VTTableStyleProperty tableStyleProperty = this.getTableStyleProperty();
        if (!tableStyleProperty.isEnableSorting()) {
            return;
        }
        int length = tableViewerComposite.getColumns().length;
        ArrayList<Integer> sortableColumns = new ArrayList<Integer>();
        int i = 0;
        while (i < length) {
            if (i >= regularColumnsStartIndex) {
                sortableColumns.add(i);
            }
            ++i;
        }
        tableViewerComposite.setComparator((TableViewerComparator)comparator, sortableColumns);
    }

    private IObservableValue<?> getLabelText(VDomainModelReference dmrToCheck) {
        switch (((VTableControl)this.getVElement()).getLabelAlignment()) {
            case NONE: {
                return Observables.constantObservableValue((Object)"", String.class);
            }
        }
        try {
            return this.getEMFFormsLabelProvider().getDisplayName(dmrToCheck, this.getViewModelContext().getDomainModel());
        }
        catch (NoLabelFoundException e) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)e));
            return Observables.constantObservableValue((Object)e.getMessage(), String.class);
        }
    }

    private IObservableValue<?> getLabelTextForColumn(VDomainModelReference dmrToCheck, EClass dmrRootEClass) {
        try {
            return this.getEMFFormsLabelProvider().getDisplayName(dmrToCheck, dmrRootEClass);
        }
        catch (NoLabelFoundException e) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)e));
            return Observables.constantObservableValue((Object)e.getMessage(), String.class);
        }
    }

    private IObservableValue<?> getLabelTooltipText(VDomainModelReference dmrToCheck) {
        switch (((VTableControl)this.getVElement()).getLabelAlignment()) {
            case NONE: {
                return Observables.constantObservableValue((Object)"", String.class);
            }
        }
        try {
            return this.getEMFFormsLabelProvider().getDescription(dmrToCheck, this.getViewModelContext().getDomainModel());
        }
        catch (NoLabelFoundException e) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)e));
            return Observables.constantObservableValue((Object)e.toString(), String.class);
        }
    }

    private IObservableValue<?> getLabelTooltipTextForColumn(VDomainModelReference dmrToCheck, EClass dmrRootEClass) {
        try {
            return this.getEMFFormsLabelProvider().getDescription(dmrToCheck, dmrRootEClass);
        }
        catch (NoLabelFoundException e) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)e));
            return Observables.constantObservableValue((Object)e.toString(), String.class);
        }
    }

    protected VDomainModelReference getDMRToMultiReference() {
        if (((VTableControl)this.getVElement()).getDomainModelReference().eClass() == VViewPackage.Literals.DOMAIN_MODEL_REFERENCE) {
            return ((VTableControl)this.getVElement()).getDomainModelReference();
        }
        VTableDomainModelReference tableDomainModelReference = (VTableDomainModelReference)((VTableControl)this.getVElement()).getDomainModelReference();
        VTableDomainModelReference dmrToCheck = tableDomainModelReference.getDomainModelReference() == null ? tableDomainModelReference : tableDomainModelReference.getDomainModelReference();
        return dmrToCheck;
    }

    protected int addButtonsToButtonBar(Composite buttonComposite) {
        return 0;
    }

    protected Composite createControlComposite(Composite composite) {
        Composite controlComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(1, this.getTableHeightHint()).applyTo((Control)controlComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(controlComposite);
        return controlComposite;
    }

    protected int getTableHeightHint() {
        if (!(this.minimumHeight.isPresent() || this.maximumHeight.isPresent() || this.visibleLines.isPresent())) {
            return 200;
        }
        if (this.visibleLines.isPresent()) {
            return this.computeRequiredHeight((Integer)this.visibleLines.get());
        }
        if (this.minimumHeight.isPresent() && this.maximumHeight.isPresent() && this.minimumHeight.get() == this.maximumHeight.get()) {
            return (Integer)this.minimumHeight.get();
        }
        int requiredHeight = this.computeRequiredHeight(null);
        if (this.minimumHeight.isPresent() && !this.maximumHeight.isPresent()) {
            return requiredHeight < (Integer)this.minimumHeight.get() ? (Integer)this.minimumHeight.get() : requiredHeight;
        }
        if (!this.minimumHeight.isPresent() && this.maximumHeight.isPresent()) {
            return requiredHeight > (Integer)this.maximumHeight.get() ? (Integer)this.maximumHeight.get() : requiredHeight;
        }
        if (requiredHeight < (Integer)this.minimumHeight.get()) {
            return (Integer)this.minimumHeight.get();
        }
        if (requiredHeight > (Integer)this.maximumHeight.get()) {
            return (Integer)this.maximumHeight.get();
        }
        return requiredHeight;
    }

    protected int computeRequiredHeight(Integer visibleLines) {
        if (this.tableViewer == null) {
            return -1;
        }
        TableControl table = this.tableViewerComposite.getTableControl();
        if (table == null) {
            return -1;
        }
        if (table.isDisposed()) {
            return -1;
        }
        int itemHeight = table.getItemHeight();
        int itemCount = visibleLines != null ? Math.max(visibleLines, 1) : Math.max(table.getItemCount(), 1);
        int headerHeight = table.getHeaderVisible() ? table.getHeaderHeight() : 0;
        int tableHeight = itemHeight * itemCount + headerHeight + 4;
        return tableHeight;
    }

    protected AbstractTableViewer getTableViewer() {
        return this.tableViewer;
    }

    protected AbstractTableViewerComposite getTableViewerComposite() {
        return this.tableViewerComposite;
    }

    protected void setTableViewer(AbstractTableViewer tableViewer) {
        this.tableViewer = tableViewer;
    }

    protected void viewerSelectionChanged(SelectionChangedEvent event) {
    }

    private void createFixedValidationStatusColumn(TableViewerSWTBuilder tableViewerSWTBuilder) {
        VTTableValidationStyleProperty tableValidationStyleProperty = this.getTableValidationStyleProperty();
        int columnWidth = tableValidationStyleProperty.getColumnWidth();
        String columnName = tableValidationStyleProperty.getColumnName();
        String imagePath = tableValidationStyleProperty.getImagePath();
        Image image = null;
        if (imagePath != null && !imagePath.isEmpty()) {
            try {
                image = this.getImage(new URL(imagePath));
            }
            catch (MalformedURLException ex) {
                this.getReportService().report(new AbstractReport((Throwable)ex));
            }
        }
        tableViewerSWTBuilder.addColumn(ColumnConfigurationBuilder.usingDefaults().minWidth(columnWidth).text(columnName).tooltip(columnName).labelProvider((CellLabelProvider)new ValidationStatusCellLabelProvider((VTableControl)this.getVElement())).image(image).build());
    }

    protected Image getImage(URL url) {
        return this.imageRegistryService.getImage(url);
    }

    protected Image getImage(String path) {
        Image result = this.imageRegistryService.getImage(FrameworkUtil.getBundle(((Object)((Object)this)).getClass()), path);
        if (result == null && ((Object)((Object)this)).getClass() != TableControlSWTRenderer.class) {
            result = this.imageRegistryService.getImage(FrameworkUtil.getBundle(TableControlSWTRenderer.class), path);
        }
        return result;
    }

    protected VTTableValidationStyleProperty getTableValidationStyleProperty() {
        VTTableValidationStyleProperty tableValidationStyleProperties = this.getStyleProperty(VTTableValidationStyleProperty.class);
        if (tableValidationStyleProperties == null) {
            tableValidationStyleProperties = this.createDefaultTableValidationStyleProperty();
        }
        return tableValidationStyleProperties;
    }

    protected VTTableValidationStyleProperty createDefaultTableValidationStyleProperty() {
        VTTableValidationStyleProperty tableValidationProp = VTTableValidationFactory.eINSTANCE.createTableValidationStyleProperty();
        tableValidationProp.setColumnWidth(80);
        tableValidationProp.setColumnName(LocalizationServiceHelper.getString(TableControlSWTRenderer.class, (String)"TableControl_ValidationStatusColumn"));
        tableValidationProp.setImagePath(null);
        return tableValidationProp;
    }

    protected VTBackgroundStyleProperty getBackgroundStyleProperty() {
        VTBackgroundStyleProperty styleProperty = this.getStyleProperty(VTBackgroundStyleProperty.class);
        if (styleProperty == null) {
            styleProperty = this.createDefaultBackgroundStyleProperty();
        }
        return styleProperty;
    }

    protected VTBackgroundStyleProperty createDefaultBackgroundStyleProperty() {
        return VTBackgroundFactory.eINSTANCE.createBackgroundStyleProperty();
    }

    protected VTTableStyleProperty getTableStyleProperty() {
        VTTableStyleProperty styleProperty = this.getStyleProperty(VTTableStyleProperty.class);
        if (styleProperty == null) {
            styleProperty = this.createDefaultTableStyleProperty();
        }
        return styleProperty;
    }

    protected VTTableStyleProperty createDefaultTableStyleProperty() {
        VTTableStyleProperty tableStyleProperty = VTTableStylePropertyFactory.eINSTANCE.createTableStyleProperty();
        tableStyleProperty.setMaximumHeight(200);
        if (!((VTableControl)this.getVElement()).isEffectivelyReadonly()) {
            tableStyleProperty.setMinimumHeight(200);
        }
        return tableStyleProperty;
    }

    protected VTFontPropertiesStyleProperty getFontPropertiesStyleProperty() {
        VTFontPropertiesStyleProperty styleProperty = this.getStyleProperty(VTFontPropertiesStyleProperty.class);
        if (styleProperty == null) {
            styleProperty = this.createDefaultFontPropertiesStyleProperty();
        }
        return styleProperty;
    }

    protected VTFontPropertiesStyleProperty createDefaultFontPropertiesStyleProperty() {
        VTFontPropertiesStyleProperty property = VTFontPropertiesFactory.eINSTANCE.createFontPropertiesStyleProperty();
        property.setColorHEX("000000");
        return property;
    }

    private <SP extends VTStyleProperty> SP getStyleProperty(Class<SP> stylePropertyClass) {
        return (SP)RendererUtil.getStyleProperty((VTViewTemplateProvider)this.getVTViewTemplateProvider(), (VElement)this.getVElement(), (ViewModelContext)this.getViewModelContext(), stylePropertyClass);
    }

    protected Color getSWTColor(String colorHex) {
        String redString = colorHex.substring(0, 2);
        String greenString = colorHex.substring(2, 4);
        String blueString = colorHex.substring(4, 6);
        int red = Integer.parseInt(redString, 16);
        int green = Integer.parseInt(greenString, 16);
        int blue = Integer.parseInt(blueString, 16);
        return new Color((Device)Display.getDefault(), red, green, blue);
    }

    protected EList<VDomainModelReference> getColumnDomainModelReferences() {
        VDomainModelReference dmr = ((VTableControl)this.getVElement()).getDomainModelReference();
        Optional multiSegment = MultiSegmentUtil.getMultiSegment((VDomainModelReference)dmr);
        if (multiSegment.isPresent()) {
            return ((VMultiDomainModelReferenceSegment)multiSegment.get()).getChildDomainModelReferences();
        }
        return ((VTableDomainModelReference)VTableDomainModelReference.class.cast(dmr)).getColumnDomainModelReferences();
    }

    protected CellEditor createCellEditor(EObject tempInstance, EStructuralFeature feature, Composite table) {
        return CellEditorFactory.INSTANCE.getCellEditor(feature, tempInstance, table, this.getViewModelContext());
    }

    private InternalEObject getInstanceOf(EClass clazz) {
        return (InternalEObject)InternalEObject.class.cast(clazz.getEPackage().getEFactoryInstance().create(clazz));
    }

    @Deprecated
    protected void deleteRowUserConfirmDialog(final List<EObject> deletionList, final EObject eObject, final EStructuralFeature structuralFeature, final Button addButton, final Button removeButton) {
        MessageDialog dialog = new MessageDialog(addButton.getShell(), LocalizationServiceHelper.getString(TableControlSWTRenderer.class, (String)"TableControl_Delete"), null, LocalizationServiceHelper.getString(TableControlSWTRenderer.class, (String)"TableControl_DeleteAreYouSure"), 5, new String[]{JFaceResources.getString((String)"yes"), JFaceResources.getString((String)"no")}, 0);
        new ECPDialogExecutor((Dialog)dialog){

            public void handleResult(int codeResult) {
                if (codeResult == 1 || codeResult == -1) {
                    return;
                }
                TableControlSWTRenderer.this.deleteRows(deletionList, eObject, structuralFeature);
                List containments = (List)eObject.eGet(structuralFeature, true);
                if (containments.size() < structuralFeature.getUpperBound()) {
                    addButton.setEnabled(true);
                }
                if (containments.size() <= structuralFeature.getLowerBound()) {
                    removeButton.setEnabled(false);
                }
            }
        }.execute();
    }

    @Deprecated
    protected void deleteRows(List<EObject> deletionList, EObject eObject, EStructuralFeature structuralFeature) {
        EditingDomain editingDomain = this.getEditingDomain(eObject);
        EReference reference = (EReference)EReference.class.cast(structuralFeature);
        ArrayList<EObject> toDelete = new ArrayList<EObject>(deletionList);
        if (reference.isContainment()) {
            DeleteService deleteService = (DeleteService)this.getViewModelContext().getService(DeleteService.class);
            if (deleteService == null) {
                deleteService = new EMFDeleteServiceImpl();
            }
            deleteService.deleteElements(toDelete);
        } else {
            this.removeElements(editingDomain, eObject, (EStructuralFeature)reference, toDelete);
        }
    }

    private void removeElements(EditingDomain editingDomain, Object source, EStructuralFeature feature, Collection<Object> toRemove) {
        Command removeCommand = RemoveCommand.create((EditingDomain)editingDomain, (Object)source, (Object)feature, toRemove);
        if (removeCommand.canExecute()) {
            if (editingDomain.getCommandStack() == null) {
                removeCommand.execute();
            } else {
                editingDomain.getCommandStack().execute(removeCommand);
            }
        }
    }

    @Deprecated
    protected void addRow(EClass clazz, EObject eObject, EStructuralFeature structuralFeature) {
        org.eclipse.emfforms.common.Optional eObjectToAdd = null;
        if (this.getViewModelContext().hasService(TableControlService.class)) {
            TableControlService tableService = (TableControlService)this.getViewModelContext().getService(TableControlService.class);
            eObjectToAdd = tableService.createNewElement(clazz, eObject, structuralFeature);
        }
        if (eObjectToAdd == null) {
            ReferenceService referenceService = (ReferenceService)this.getViewModelContext().getService(ReferenceService.class);
            eObjectToAdd = referenceService.addNewModelElements(eObject, (EReference)EReference.class.cast(structuralFeature), false);
        }
        if (!eObjectToAdd.isPresent()) {
            return;
        }
        EObject instance = (EObject)eObjectToAdd.get();
        EditingDomain editingDomain = this.getEditingDomain(eObject);
        if (editingDomain == null) {
            return;
        }
        editingDomain.getCommandStack().execute(AddCommand.create((EditingDomain)editingDomain, (Object)eObject, (Object)structuralFeature, (Object)instance));
        this.tableViewer.setSelection((ISelection)new StructuredSelection(eObjectToAdd.get()), true);
    }

    protected void applyValidation(VDiagnostic oldDiagnostic, VDiagnostic newDiagnostic) {
        this.getRunnableManager().executeAsync(new ComputeValidationUpdate(oldDiagnostic, newDiagnostic));
    }

    protected void applyValidation() {
        if (!this.getRunnableManager().isRunning()) {
            this.getRunnableManager().executeAsync(new ApplyValidationRunnable());
        }
    }

    final RunnableManager getRunnableManager() {
        return this.runnableManager;
    }

    @Deprecated
    protected Button getAddButton() {
        org.eclipse.emfforms.common.Optional<Control> control = this.getControlForAction("org.eclipse.emfforms.action.tablecontrol.add_row");
        if (control.isPresent()) {
            return (Button)control.get();
        }
        return null;
    }

    @Deprecated
    protected Button getRemoveButton() {
        org.eclipse.emfforms.common.Optional<Control> control = this.getControlForAction("org.eclipse.emfforms.action.tablecontrol.remove_row");
        if (control.isPresent()) {
            return (Button)control.get();
        }
        return null;
    }

    public org.eclipse.emfforms.common.Optional<Control> getControlForAction(String actionId) {
        if (this.tableViewerComposite.getActionBar().isPresent()) {
            return ((ActionBar)this.tableViewerComposite.getActionBar().get()).getControlById(actionId);
        }
        return org.eclipse.emfforms.common.Optional.empty();
    }

    protected org.eclipse.emfforms.common.Optional<EStructuralFeature.Setting> getSettingFromObservable(VDomainModelReference dmr, EObject eObject) {
        IObservableValue observableValue = null;
        try {
            observableValue = this.getEMFFormsDatabinding().getObservableValue(dmr, eObject);
            EStructuralFeature feature = (EStructuralFeature)observableValue.getValueType();
            EObject observed = (EObject)((IObserving)observableValue).getObserved();
            if (observed == null || observed.eClass().getFeatureID(feature) == -1) {
                org.eclipse.emfforms.common.Optional optional = org.eclipse.emfforms.common.Optional.empty();
                return optional;
            }
            org.eclipse.emfforms.common.Optional optional = org.eclipse.emfforms.common.Optional.of((Object)((InternalEObject)observed).eSetting(feature));
            return optional;
        }
        catch (DatabindingFailedException ex) {
            this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            org.eclipse.emfforms.common.Optional optional = org.eclipse.emfforms.common.Optional.empty();
            return optional;
        }
        finally {
            if (observableValue != null) {
                observableValue.dispose();
            }
        }
    }

    protected void applyEnable() {
        this.updateActionBar();
    }

    protected void applyReadOnly() {
        this.updateActionBar();
    }

    protected void applyUnchangeableFeature() {
        ((VTableControl)this.getVElement()).setAddRemoveDisabled(true);
        ((VTableControl)this.getVElement()).setDuplicateDisabled(true);
        ((VTableControl)this.getVElement()).setMoveUpDownDisabled(true);
        this.updateActionBar();
    }

    protected void updateActionBar() {
        if (this.tableViewerComposite != null && this.tableViewerComposite.getActionBar().isPresent()) {
            ((ActionBar)this.tableViewerComposite.getActionBar().get()).updateActionBar();
        }
    }

    protected void dispose() {
        this.isDisposing = true;
        this.rendererGridDescription = null;
        this.viewModelDBC.dispose();
        if (this.list != null) {
            this.list.dispose();
        }
        if (this.columnIndexToComparatorMap != null) {
            for (ECPCellEditorComparator value : this.columnIndexToComparatorMap.values()) {
                if (!(value instanceof CellEditor)) continue;
                ((CellEditor)value).dispose();
            }
            this.columnIndexToComparatorMap.clear();
        }
        if (this.tableViewerComposite != null) {
            this.tableViewerComposite.dispose();
            this.tableViewerComposite = null;
        }
        if (this.tableViewer != null) {
            this.tableViewer.getControl().dispose();
            this.tableViewer = null;
        }
        if (this.customization != null) {
            for (ColumnConfiguration columnConfig : this.customization.getColumnConfigurations()) {
                columnConfig.visible().dispose();
                columnConfig.dispose();
            }
            this.customization.getTableConfiguration().dispose();
        }
        if (this.autoSortModelChangeListener != null) {
            this.getViewModelContext().unregisterDomainChangeListener(this.autoSortModelChangeListener);
            this.autoSortModelChangeListener = null;
        }
        super.dispose();
    }

    protected int compare(Viewer viewer, Object left, Object right, int direction, int propertyIndex) {
        Object rightValue;
        if (direction == 0) {
            return 0;
        }
        int rc = 0;
        VDomainModelReference dmr = (VDomainModelReference)this.getColumnDomainModelReferences().get(propertyIndex -= this.regularColumnsStartIndex);
        org.eclipse.emfforms.common.Optional<EStructuralFeature.Setting> leftSetting = this.getSettingFromObservable(dmr, (EObject)left);
        org.eclipse.emfforms.common.Optional<EStructuralFeature.Setting> rightSetting = this.getSettingFromObservable(dmr, (EObject)right);
        Object leftValue = leftSetting.isPresent() ? ((EStructuralFeature.Setting)leftSetting.get()).get(true) : null;
        Object object = rightValue = rightSetting.isPresent() ? ((EStructuralFeature.Setting)rightSetting.get()).get(true) : null;
        if (this.columnIndexToComparatorMap.containsKey(propertyIndex)) {
            return this.columnIndexToComparatorMap.get(propertyIndex).compare(leftValue, rightValue, direction);
        }
        rc = leftValue == null ? (rightValue == null ? 0 : 1) : (rightValue == null ? -1 : (!(leftValue instanceof String) && leftValue instanceof Comparable && leftValue.getClass().isInstance(rightValue) ? ((Comparable)Comparable.class.cast(leftValue)).compareTo(rightValue) : NumberAwareStringComparator.getInstance().compare(leftValue.toString(), rightValue.toString())));
        if (direction == 2) {
            rc = -rc;
        }
        return rc;
    }

    protected void rootDomainModelChanged() throws DatabindingFailedException {
        IObservableList oldList = (IObservableList)this.getTableViewer().getInput();
        oldList.dispose();
        EObject domainModel = this.getViewModelContext().getDomainModel();
        IObservableList list = this.getEMFFormsDatabinding().getObservableList(this.getDMRToMultiReference(), domainModel);
        this.getTableViewer().setInput((Object)list);
        if (this.tableViewerComposite.getActionBar().isPresent()) {
            ((ActionBar)this.tableViewerComposite.getActionBar().get()).updateActionBar();
        }
    }

    protected boolean canEditObject(Object element) {
        return true;
    }

    protected boolean shouldCreateCellEditor(Object element) {
        boolean isObjectEditable = this.canEditObject(element);
        if (!isObjectEditable) {
            return false;
        }
        boolean editable = ((VTableControl)this.getVElement()).isEffectivelyEnabled() && !((VTableControl)this.getVElement()).isEffectivelyReadonly();
        return editable;
    }

    private boolean isDisabled(EObject eObject, VDomainModelReference columnDmr) {
        org.eclipse.emfforms.common.Optional<VEnablementConfiguration> enablmentConf = TableConfigurationHelper.findEnablementConfiguration((VTableControl)this.getVElement(), columnDmr);
        if (enablmentConf.isPresent()) {
            return !((VEnablementConfiguration)enablmentConf.get()).isEnabled();
        }
        return false;
    }

    protected CellLabelProvider createCellLabelProvider(EStructuralFeature feature, CellEditor cellEditor, IObservableMap attributeMap, VTableControl vTableControl, VDomainModelReference dmr, Control table) {
        return new ECPCellLabelProvider(feature, cellEditor, attributeMap, (VTableControl)this.getVElement(), dmr, table);
    }

    private String formatTooltipText(EClass eClass, String messageKey) {
        String instanceName = eClass.getInstanceClass() == null ? "" : eClass.getInstanceClass().getSimpleName();
        return String.format(LocalizationServiceHelper.getString(TableControlSWTRenderer.class, (String)messageKey), instanceName);
    }

    private final class ApplyValidationRunnable
    implements Runnable {
        private Collection<?> updates;

        ApplyValidationRunnable() {
        }

        ApplyValidationRunnable(Collection<?> updates) {
            this.updates = updates;
        }

        @Override
        public void run() {
            if (TableControlSWTRenderer.this.isDisposing) {
                return;
            }
            if (TableControlSWTRenderer.this.validationIcon == null || TableControlSWTRenderer.this.validationIcon.isDisposed()) {
                return;
            }
            if (((VTableControl)TableControlSWTRenderer.this.getVElement()).getDiagnostic() == null) {
                return;
            }
            VDomainModelReference dmr = TableControlSWTRenderer.this.getDMRToMultiReference();
            org.eclipse.emfforms.common.Optional<EStructuralFeature.Setting> setting = TableControlSWTRenderer.this.getSettingFromObservable(dmr, TableControlSWTRenderer.this.getViewModelContext().getDomainModel());
            if (!setting.isPresent()) {
                return;
            }
            TableControlSWTRenderer.this.validationIcon.setImage(TableControlSWTRenderer.this.getValidationIcon(((VTableControl)TableControlSWTRenderer.this.getVElement()).getDiagnostic().getHighestSeverity()));
            this.showValidationSummaryTooltip((EStructuralFeature.Setting)setting.get(), TableControlSWTRenderer.this.showValidationSummaryTooltip);
            if (this.updates != null) {
                TableControlSWTRenderer.this.getTableViewer().update(this.updates.toArray(), null);
            } else {
                TableControlSWTRenderer.this.getTableViewer().refresh();
            }
        }

        private void showValidationSummaryTooltip(EStructuralFeature.Setting tableSetting, boolean doShow) {
            if (doShow) {
                TableControlSWTRenderer.this.validationIcon.setToolTipText(ECPTooltipModifierHelper.modifyString((String)((VTableControl)TableControlSWTRenderer.this.getVElement()).getDiagnostic().getMessage(), null));
                return;
            }
            StringBuilder builder = new StringBuilder();
            List tableDiagnostics = ((VTableControl)TableControlSWTRenderer.this.getVElement()).getDiagnostic().getDiagnostic(tableSetting.getEObject(), tableSetting.getEStructuralFeature());
            for (Diagnostic diagnostic : tableDiagnostics) {
                builder.append(diagnostic.getMessage());
                builder.append("\n");
            }
            String toolTipText = ECPTooltipModifierHelper.modifyString((String)builder.toString().trim(), null);
            TableControlSWTRenderer.this.validationIcon.setToolTipText(toolTipText);
        }
    }

    protected class AutoSortModelChangeListener
    implements ModelChangeListener {
        protected AutoSortModelChangeListener() {
        }

        public void notifyChange(ModelChangeNotification notification) {
            int event = notification.getRawNotification().getEventType();
            if (notification.getStructuralFeature() == TableControlSWTRenderer.this.tableEReference && TableControlSWTRenderer.this.sortColumnFeature.isPresent() && (event == 3 || event == 5)) {
                this.sortAndReveal(notification.getNewEObjects());
            } else if (TableControlSWTRenderer.this.sortColumnFeature.isPresent() && notification.getStructuralFeature() == TableControlSWTRenderer.this.sortColumnFeature.get()) {
                this.sortAndReveal(notification.getNotifier());
            }
        }

        private void sortAndReveal(Object toReveal) {
            Display.getDefault().asyncExec(() -> {
                TableControlSWTRenderer.this.getTableViewer().refresh();
                TableControlSWTRenderer.this.getTableViewer().reveal(toReveal);
            });
        }
    }

    protected class CompactVerticallyTableControlSWTRendererCompositeBuilder
    extends CompactVerticallyTableViewerCompositeBuilder {
        public CompactVerticallyTableControlSWTRendererCompositeBuilder(boolean createTitleLabel, boolean createValidationLabel) {
            super(createTitleLabel, createValidationLabel);
        }

        protected Label createValidationLabel(Composite composite) {
            Label validationLabel = TableControlSWTRenderer.this.createValidationIcon(composite);
            GridDataFactory.fillDefaults().hint(16, 17).grab(false, false).applyTo((Control)validationLabel);
            return validationLabel;
        }

        protected Composite createViewerComposite(Composite composite) {
            return TableControlSWTRenderer.this.createControlComposite(composite);
        }
    }

    private final class ComputeValidationUpdate
    implements Runnable,
    RunnableManager.BackgroundStage {
        private final Set<Diagnostic> oldDiagnostics;
        private final Set<Diagnostic> newDiagnostics;
        private Runnable update;

        ComputeValidationUpdate(VDiagnostic oldDiagnostic, VDiagnostic newDiagnostic) {
            this.oldDiagnostics = this.getDiagnostics(oldDiagnostic);
            this.newDiagnostics = this.getDiagnostics(newDiagnostic);
        }

        @Override
        public Runnable getNextStage() {
            return this.update;
        }

        @Override
        public void run() {
            Set<Diagnostic> difference = this.difference(this.oldDiagnostics, this.newDiagnostics);
            Set updates = difference.stream().map(this::getSubject).filter(Objects::nonNull).collect(Collectors.toSet());
            if (!updates.isEmpty()) {
                this.update = new ApplyValidationRunnable(updates);
            }
        }

        private Set<Diagnostic> getDiagnostics(VDiagnostic container) {
            return container == null ? Collections.emptySet() : container.getDiagnostics().stream().filter(Diagnostic.class::isInstance).map(Diagnostic.class::cast).collect(Collectors.toSet());
        }

        private Object getSubject(Diagnostic diagnostic) {
            List data = diagnostic.getData();
            return data.isEmpty() ? null : data.get(0);
        }

        private Set<Diagnostic> difference(Set<Diagnostic> set1, Set<Diagnostic> set2) {
            TreeSet<Diagnostic> sorted1 = new TreeSet<Diagnostic>(this::compare);
            sorted1.addAll(set1);
            TreeSet<Diagnostic> sorted2 = new TreeSet<Diagnostic>(this::compare);
            sorted2.addAll(set2);
            sorted1.removeAll(set2);
            sorted2.removeAll(set1);
            sorted1.addAll(sorted2);
            return sorted1;
        }

        private int compare(Diagnostic d1, Diagnostic d2) {
            int result = d1.getSeverity() - d2.getSeverity();
            if (result != 0) {
                return result;
            }
            result = d1.getCode() - d2.getCode();
            if (result != 0) {
                return result;
            }
            result = this.compare(d1.getSource(), d2.getSource());
            if (result != 0) {
                return result;
            }
            result = this.compare(d1.getMessage(), d2.getMessage());
            if (result != 0) {
                return result;
            }
            result = this.compare(d1.getData(), d2.getData());
            return result;
        }

        private int compare(String s1, String s2) {
            if (s1 == null) {
                return s2 == null ? 0 : -1;
            }
            if (s2 == null) {
                return 1;
            }
            return s1.compareTo(s2);
        }

        private int compare(List<?> s1, List<?> s2) {
            if (s1 == null) {
                return s2 == null ? 0 : -1;
            }
            if (s2 == null) {
                return 1;
            }
            int size = s1.size();
            int result = size - s2.size();
            if (result != 0) {
                return result;
            }
            int i = 0;
            i = 0;
            while (i < size) {
                Object e2;
                Object e1 = s1.get(i);
                if (e1 != (e2 = s2.get(i))) {
                    result = System.identityHashCode(e1) - System.identityHashCode(e2);
                    break;
                }
                ++i;
            }
            return result;
        }
    }

    private final class DoubleClickListener
    implements IDoubleClickListener {
        private DoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            if (!TableControlSWTRenderer.this.getViewModelContext().hasService(TableControlService.class)) {
                return;
            }
            ISelection selection = event.getSelection();
            if (!StructuredSelection.class.isInstance(selection)) {
                return;
            }
            TableControlService tableService = (TableControlService)TableControlSWTRenderer.this.getViewModelContext().getService(TableControlService.class);
            tableService.doubleClick((VTableControl)TableControlSWTRenderer.this.getVElement(), (EObject)((StructuredSelection)StructuredSelection.class.cast(selection)).getFirstElement());
        }
    }

    public class ECPCellLabelProvider
    extends ObservableMapCellLabelProvider
    implements IColorProvider {
        private final EStructuralFeature feature;
        private final CellEditor cellEditor;
        private final VTableControl vTableControl;
        private final VDomainModelReference dmr;
        private final Control table;

        public ECPCellLabelProvider(EStructuralFeature feature, CellEditor cellEditor, IObservableMap attributeMap, VTableControl vTableControl, VDomainModelReference dmr, Control table) {
            super(attributeMap);
            this.vTableControl = vTableControl;
            this.feature = feature;
            this.cellEditor = cellEditor;
            this.dmr = dmr;
            this.table = table;
        }

        public String getToolTipText(Object element) {
            String message;
            EObject domainObject = (EObject)element;
            org.eclipse.emfforms.common.Optional<EStructuralFeature.Setting> setting = TableControlSWTRenderer.this.getSettingFromObservable(this.dmr, domainObject);
            if (!setting.isPresent()) {
                return null;
            }
            VDiagnostic vDiagnostic = this.vTableControl.getDiagnostic();
            if (vDiagnostic != null && (message = DiagnosticMessageExtractor.getMessage((Collection)vDiagnostic.getDiagnostic(domainObject, this.feature))) != null && !message.isEmpty()) {
                return ECPTooltipModifierHelper.modifyString((String)message, (EStructuralFeature.Setting)((EStructuralFeature.Setting)setting.get()));
            }
            Object value = ((EStructuralFeature.Setting)setting.get()).get(true);
            if (value == null) {
                return null;
            }
            String tooltip = ECPTooltipModifierHelper.modifyString((String)String.valueOf(value), (EStructuralFeature.Setting)((EStructuralFeature.Setting)setting.get()));
            if (tooltip == null || tooltip.isEmpty()) {
                return null;
            }
            return tooltip;
        }

        public void update(ViewerCell cell) {
            EObject element = (EObject)cell.getElement();
            Object value = this.attributeMaps[0].get((Object)element);
            if (ECPCustomUpdateCellEditor.class.isInstance(this.cellEditor)) {
                ((ECPCustomUpdateCellEditor)this.cellEditor).updateCell(cell, value);
            } else if (ECPCellEditor.class.isInstance(this.cellEditor)) {
                ECPCellEditor ecpCellEditor = (ECPCellEditor)this.cellEditor;
                String text = ecpCellEditor.getFormatedString(value);
                cell.setText(text == null ? "" : text);
                cell.setImage(ecpCellEditor.getImage(value));
            } else {
                cell.setText(value == null ? "" : value.toString());
                cell.getControl().setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_edit_cellEditor_string");
            }
            cell.setForeground(this.getForeground(element));
            cell.setBackground(this.getBackground(element));
        }

        public Color getForeground(Object element) {
            return this.table.getForeground();
        }

        public Color getBackground(Object element) {
            VDiagnostic vDiagnostic = this.vTableControl.getDiagnostic();
            if (vDiagnostic == null) {
                return TableControlSWTRenderer.this.getValidationBackgroundColor(0);
            }
            List diagnostic = vDiagnostic.getDiagnostic((EObject)element, this.feature);
            return TableControlSWTRenderer.this.getValidationBackgroundColor(diagnostic.size() == 0 ? 0 : ((Diagnostic)diagnostic.get(0)).getSeverity());
        }

        protected CellEditor getCellEditor() {
            return this.cellEditor;
        }

        protected EStructuralFeature getFeature() {
            return this.feature;
        }

        protected VDomainModelReference getDmr() {
            return this.dmr;
        }
    }

    class ECPTableEditingSupport
    extends EditingSupport {
        private final CellEditor cellEditor;
        private final IValueProperty valueProperty;
        private final VDomainModelReference domainModelReference;
        private EditingState editingState;
        private final ColumnViewerEditorActivationListenerHelper activationListener;

        ECPTableEditingSupport(ColumnViewer viewer, CellEditor cellEditor, VDomainModelReference domainModelReference, IValueProperty<?, ?> valueProperty) {
            super(viewer);
            this.activationListener = new ColumnViewerEditorActivationListenerHelper();
            this.cellEditor = cellEditor;
            this.valueProperty = valueProperty;
            this.domainModelReference = domainModelReference;
        }

        protected boolean canEdit(Object element) {
            if (!TableControlSWTRenderer.this.shouldCreateCellEditor(element)) {
                return false;
            }
            IObservableValue observableValue = this.valueProperty.observe(element);
            EObject eObject = (EObject)((IObserving)observableValue).getObserved();
            EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
            if (eObject == null || eObject.eClass().getFeatureID(structuralFeature) == -1) {
                return false;
            }
            EStructuralFeature.Setting setting = ((InternalEObject)eObject).eSetting(structuralFeature);
            if (TableControlSWTRenderer.this.isDisabled(eObject, this.domainModelReference) || CellReadOnlyTesterHelper.getInstance().isReadOnly((VTableControl)TableControlSWTRenderer.this.getVElement(), setting)) {
                return false;
            }
            boolean editable = TableControlSWTRenderer.this.emfFormsEditSupport.canSetProperty(this.domainModelReference, (EObject)element);
            if (ECPCellEditor.class.isInstance(this.cellEditor)) {
                ((ECPCellEditor)ECPCellEditor.class.cast(this.cellEditor)).setEditable(editable);
                return true;
            }
            return editable;
        }

        protected Object getValue(Object element) {
            return null;
        }

        protected void setValue(Object element, Object value) {
        }

        protected void initializeCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
            if (ECPElementAwareCellEditor.class.isInstance(cellEditor)) {
                ((ECPElementAwareCellEditor)ECPElementAwareCellEditor.class.cast(cellEditor)).updateRowElement(cell.getElement());
            }
            IObservableValue target = this.doCreateCellEditorObservable(cellEditor);
            Assert.isNotNull((Object)target, (String)"doCreateCellEditorObservable(...) did not return an observable");
            IObservableValue model = this.valueProperty.observe(cell.getElement());
            Assert.isNotNull((Object)model, (String)"The databinding service did not return an observable");
            Binding binding = this.createBinding(target, model);
            Assert.isNotNull((Object)binding, (String)"createBinding(...) did not return a binding");
            this.editingState = new EditingState(binding, target, model);
            this.getViewer().getColumnViewerEditor().addEditorActivationListener((ColumnViewerEditorActivationListener)this.activationListener);
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected Binding createBinding(IObservableValue target, IObservableValue model) {
            if (ECPCellEditor.class.isInstance(this.cellEditor)) {
                return TableControlSWTRenderer.this.getDataBindingContext().bindValue(target, model, ((ECPCellEditor)this.cellEditor).getTargetToModelStrategy(TableControlSWTRenderer.this.getDataBindingContext()), ((ECPCellEditor)this.cellEditor).getModelToTargetStrategy(TableControlSWTRenderer.this.getDataBindingContext()));
            }
            return TableControlSWTRenderer.this.getDataBindingContext().bindValue(target, model);
        }

        protected IObservableValue doCreateCellEditorObservable(CellEditor cellEditor) {
            if (ECPCellEditor.class.isInstance(cellEditor)) {
                return ((ECPCellEditor)cellEditor).getValueProperty().observe((Object)cellEditor);
            }
            return WidgetProperties.text((int)16).observe((Widget)cellEditor.getControl());
        }

        protected final void saveCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
            if (this.editingState.isUpdateNeeded()) {
                this.editingState.binding.updateTargetToModel();
            }
        }

        private class ColumnViewerEditorActivationListenerHelper
        extends ColumnViewerEditorActivationListener {
            private ColumnViewerEditorActivationListenerHelper() {
            }

            public void afterEditorActivated(ColumnViewerEditorActivationEvent event) {
                Control control = ECPTableEditingSupport.this.cellEditor.getControl();
                if (control == null || control.isDisposed()) {
                    return;
                }
                control.setBackground(ECPTableEditingSupport.this.getViewer().getControl().getBackground());
                control.setForeground(ECPTableEditingSupport.this.getViewer().getControl().getForeground());
            }

            public void afterEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
                ECPTableEditingSupport.this.editingState.dispose();
                ECPTableEditingSupport.this.editingState = null;
                ECPTableEditingSupport.this.getViewer().getColumnViewerEditor().removeEditorActivationListener((ColumnViewerEditorActivationListener)this);
                ViewerCell focusCell = ECPTableEditingSupport.this.getViewer().getColumnViewerEditor().getFocusCell();
                if (focusCell != null) {
                    ECPTableEditingSupport.this.getViewer().update(focusCell.getElement(), null);
                }
            }

            public void beforeEditorActivated(ColumnViewerEditorActivationEvent event) {
            }

            public void beforeEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
            }
        }

        class EditingState {
            private final IObservableValue<?> target;
            private final IObservableValue<?> model;
            private final Binding binding;

            EditingState(Binding binding, IObservableValue<?> target, IObservableValue<?> model) {
                this.binding = binding;
                this.target = target;
                this.model = model;
            }

            void dispose() {
                this.binding.dispose();
                this.target.dispose();
                this.model.dispose();
            }

            boolean isUpdateNeeded() {
                Object targetValue = this.target.getValue();
                Object modelValue = this.model.getValue();
                if (targetValue == null) {
                    return modelValue != null;
                }
                return !targetValue.equals(modelValue);
            }
        }
    }

    protected class ECPTableViewerComparator
    extends ViewerComparator
    implements TableViewerComparator {
        private int propertyIndex = 0;
        private static final int NONE = 0;
        private int direction = 0;

        ECPTableViewerComparator() {
        }

        public int getDirection() {
            switch (this.direction) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1024;
                }
                case 2: {
                    return 128;
                }
            }
            return 0;
        }

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = (this.direction + 1) % 3;
            } else {
                this.propertyIndex = column;
                this.direction = 1;
            }
            if (this.direction == 0) {
                TableControlSWTRenderer.this.sortColumnFeature = Optional.empty();
            } else {
                TableControlSWTRenderer.this.sortColumnFeature = Optional.of(TableControlSWTRenderer.this.columnFeatures[this.propertyIndex - TableControlSWTRenderer.this.regularColumnsStartIndex]);
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return TableControlSWTRenderer.this.compare(viewer, e1, e2, this.direction, this.propertyIndex);
        }
    }

    protected final class TableControlEditingSupportAndLabelProvider
    implements EditingSupportCreator,
    CellLabelProviderFactory {
        private final InternalEObject tempInstance;
        private final EStructuralFeature eStructuralFeature;
        private final VDomainModelReference dmr;
        private final IValueProperty<?, ?> valueProperty;
        private final IObservableMap<?, ?> observableMap;
        private CellEditor cellEditor;
        private ECPTableEditingSupport observableSupport;
        private boolean initialized;
        private final int indexOfColumn;

        private TableControlEditingSupportAndLabelProvider(InternalEObject tempInstance, EStructuralFeature eStructuralFeature, VDomainModelReference dmr, IValueProperty<?, ?> valueProperty, IObservableMap<?, ?> observableMap, int indexOfColumn) {
            this.tempInstance = tempInstance;
            this.eStructuralFeature = eStructuralFeature;
            this.dmr = dmr;
            this.valueProperty = valueProperty;
            this.observableMap = observableMap;
            this.indexOfColumn = indexOfColumn;
        }

        public EditingSupport createEditingSupport(AbstractTableViewer tableViewer) {
            if (!this.initialized) {
                this.init(tableViewer);
            }
            return this.observableSupport;
        }

        private void init(AbstractTableViewer tableViewer) {
            this.cellEditor = TableControlSWTRenderer.this.createCellEditor((EObject)this.tempInstance, this.eStructuralFeature, (Composite)tableViewer.getControl());
            if (this.cellEditor instanceof ECPViewerAwareCellEditor) {
                ((ECPViewerAwareCellEditor)this.cellEditor).setTableViewer(tableViewer);
                ((ECPViewerAwareCellEditor)this.cellEditor).setTableFeature((EReference)TableControlSWTRenderer.this.list.getElementType());
            }
            tableViewer.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent arg0) {
                    TableControlEditingSupportAndLabelProvider.this.cellEditor.dispose();
                }
            });
            if (ECPCellEditorComparator.class.isInstance(this.cellEditor)) {
                TableControlSWTRenderer.this.columnIndexToComparatorMap.put(this.indexOfColumn, (ECPCellEditorComparator)ECPCellEditorComparator.class.cast(this.cellEditor));
            }
            this.observableSupport = new ECPTableEditingSupport((ColumnViewer)tableViewer, this.cellEditor, this.dmr, this.valueProperty);
            this.initialized = true;
        }

        public CellLabelProvider createCellLabelProvider(AbstractTableViewer table) {
            if (!this.initialized) {
                this.init(table);
            }
            return TableControlSWTRenderer.this.createCellLabelProvider(this.eStructuralFeature, this.cellEditor, this.observableMap, (VTableControl)TableControlSWTRenderer.this.getVElement(), this.dmr, table.getControl());
        }
    }

    protected class TableControlSWTRendererCompositeBuilder
    extends DefaultTableViewerCompositeBuilder {
        protected TableControlSWTRendererCompositeBuilder() {
        }

        protected Label createValidationLabel(Composite topComposite) {
            Label validationLabel = TableControlSWTRenderer.this.createValidationIcon(topComposite);
            GridDataFactory.fillDefaults().hint(16, 17).grab(false, false).applyTo((Control)validationLabel);
            return validationLabel;
        }

        protected Composite createViewerComposite(Composite composite) {
            return TableControlSWTRenderer.this.createControlComposite(composite);
        }
    }

    private final class TableControlSWTRendererDragAndDrop
    implements DNDProvider {
        private TableControlSWTRendererDragAndDrop() {
        }

        public int getDragOperations() {
            return this.getDNDOperations();
        }

        public Transfer[] getDragTransferTypes() {
            return this.getDNDTransferTypes();
        }

        public DragSourceListener getDragListener(AbstractTableViewer tableViewer) {
            return new ViewerDragAdapter((Viewer)tableViewer);
        }

        public int getDropOperations() {
            return this.getDNDOperations();
        }

        public Transfer[] getDropTransferTypes() {
            return this.getDNDTransferTypes();
        }

        public DropTargetListener getDropListener(AbstractTableViewer tableViewer) {
            return new TableControlDropAdapter(TableControlSWTRenderer.this.getEditingDomain(TableControlSWTRenderer.this.getViewModelContext().getDomainModel()), (Viewer)tableViewer, tableViewer);
        }

        private int getDNDOperations() {
            return 7;
        }

        private Transfer[] getDNDTransferTypes() {
            return new Transfer[]{LocalTransfer.getInstance()};
        }

        public boolean hasDND() {
            return true;
        }

        private final class TableControlDropAdapter
        extends EditingDomainViewerDropAdapter {
            private final AbstractTableViewer tableViewer;
            private EObject eObject;
            private EStructuralFeature eStructuralFeature;
            private List<Object> list;

            TableControlDropAdapter(EditingDomain domain, Viewer viewer, AbstractTableViewer tableViewer) {
                super(domain, viewer);
                this.tableViewer = tableViewer;
                try {
                    EStructuralFeature.Setting setting = TableControlSWTRenderer.this.getEMFFormsDatabinding().getSetting(TableControlSWTRenderer.this.getDMRToMultiReference(), TableControlSWTRenderer.this.getViewModelContext().getDomainModel());
                    this.eObject = setting.getEObject();
                    this.eStructuralFeature = setting.getEStructuralFeature();
                    this.list = (List)setting.get(true);
                }
                catch (DatabindingFailedException ex) {
                    TableControlSWTRenderer.this.getReportService().report(new AbstractReport((Throwable)ex));
                }
            }

            protected void helper(DropTargetEvent event) {
                Object target = this.extractDropTarget(event.item);
                Collection dragSource = this.getDragSource(event);
                if (dragSource == null) {
                    return;
                }
                if (target == null || dragSource.contains(target)) {
                    event.detail = 0;
                    return;
                }
                event.detail = 2;
            }

            public void drop(DropTargetEvent event) {
                Collection dragSource = this.getDragSource(event);
                Object target = this.extractDropTarget(event.item);
                float location = this.getLocation(event);
                ArrayList<Command> commands = new ArrayList<Command>();
                boolean insertAfter = (double)location >= 0.5;
                for (Object toMove : dragSource) {
                    boolean moveIsLocatedBeforeTarget;
                    int indexTarget = this.list.indexOf(target);
                    int indexToMove = this.list.indexOf(toMove);
                    if (indexTarget == -1 || indexToMove == -1) {
                        return;
                    }
                    boolean bl = moveIsLocatedBeforeTarget = indexToMove < indexTarget;
                    int index = insertAfter ? (moveIsLocatedBeforeTarget ? indexTarget : indexTarget + 1) : (moveIsLocatedBeforeTarget ? indexTarget - 1 : indexTarget);
                    commands.add(MoveCommand.create((EditingDomain)this.domain, (Object)this.eObject, (Object)this.eStructuralFeature, toMove, (int)index));
                }
                CompoundCommand command = new CompoundCommand(commands);
                if (!command.canExecute()) {
                    return;
                }
                this.domain.getCommandStack().execute((Command)command);
                this.tableViewer.refresh();
            }
        }
    }

    protected class TableControlSWTRendererTableViewerCreator
    implements TableViewerCreator<TableViewer> {
        protected TableControlSWTRendererTableViewerCreator() {
        }

        public TableViewer createTableViewer(Composite parent) {
            VTFontPropertiesStyleProperty fontPropertiesStyleProperty;
            TableViewer tableViewer = new TableViewer(parent, 68098);
            tableViewer.getTable().setData("org.eclipse.rap.rwt.customVariant", (Object)TableControlSWTRenderer.TABLE_CUSTOM_VARIANT);
            tableViewer.getTable().setHeaderVisible(true);
            tableViewer.getTable().setLinesVisible(true);
            VTBackgroundStyleProperty backgroundStyleProperty = TableControlSWTRenderer.this.getBackgroundStyleProperty();
            if (backgroundStyleProperty.getColor() != null) {
                tableViewer.getTable().setBackground(TableControlSWTRenderer.this.getSWTColor(backgroundStyleProperty.getColor()));
            }
            if ((fontPropertiesStyleProperty = TableControlSWTRenderer.this.getFontPropertiesStyleProperty()).getColorHEX() != null) {
                tableViewer.getTable().setForeground(TableControlSWTRenderer.this.getSWTColor(fontPropertiesStyleProperty.getColorHEX()));
            }
            tableViewer.getTable().setData(TableControlSWTRenderer.FIXED_COLUMNS, (Object)new Integer(1));
            this.createTableViewerEditor(tableViewer);
            return tableViewer;
        }

        protected void createTableViewerEditor(TableViewer tableViewer) {
            TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(tableViewer, (FocusCellHighlighter)new ECPFocusCellDrawHighlighter((ColumnViewer)tableViewer));
            ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)tableViewer){

                protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                    return event.eventType == 5 || event.eventType == 2 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
                }
            };
            TableViewerEditor.create((TableViewer)tableViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        }
    }

    private class ValidationStatusCellLabelProvider
    extends CellLabelProvider {
        private final VTableControl vTableControl;

        ValidationStatusCellLabelProvider(VTableControl vTableControl) {
            this.vTableControl = vTableControl;
        }

        public void update(ViewerCell cell) {
            Integer mostSevere = 0;
            VDiagnostic vDiagnostic = this.vTableControl.getDiagnostic();
            if (vDiagnostic == null) {
                return;
            }
            List diagnostics = vDiagnostic.getDiagnostics((EObject)cell.getElement());
            if (diagnostics.size() != 0) {
                mostSevere = ((Diagnostic)diagnostics.get(0)).getSeverity();
            }
            cell.setImage(TableControlSWTRenderer.this.getValidationIcon(mostSevere));
        }

        public String getToolTipText(Object element) {
            VDiagnostic vDiagnostic = this.vTableControl.getDiagnostic();
            if (vDiagnostic == null) {
                return null;
            }
            String message = DiagnosticMessageExtractor.getMessage((Collection)vDiagnostic.getDiagnostics((EObject)element));
            return ECPTooltipModifierHelper.modifyString((String)message, null);
        }
    }

    private final class ViewerSelectionChangedListener
    implements ISelectionChangedListener {
        private ViewerSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            TableControlSWTRenderer.this.viewerSelectionChanged(event);
        }
    }
}

