/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.swt.table.util;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emfforms.internal.swt.table.util.DMRCellLabelProvider;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class DMREditingSupport
extends EditingSupport {
    private final CellEditor cellEditor;
    private final IValueProperty valueProperty;
    private EditingState editingState;
    private final ColumnViewerEditorActivationListenerHelper activationListener = new ColumnViewerEditorActivationListenerHelper();

    public DMREditingSupport(ColumnViewer viewer, CellEditor cellEditor, IValueProperty valueProperty) {
        super(viewer);
        this.cellEditor = cellEditor;
        this.valueProperty = valueProperty;
        if (valueProperty == null) {
            throw new IllegalArgumentException("ValueProperty may not be null");
        }
    }

    public DMREditingSupport(ColumnViewer columnViewer, CellEditor cellEditor, VDomainModelReference domainModelReference, EObject parent) {
        this(columnViewer, cellEditor, DMREditingSupport.getValueProperty(domainModelReference, parent));
    }

    private static IValueProperty getValueProperty(VDomainModelReference domainModelReference, EObject parent) {
        try {
            return DMREditingSupport.getService(EMFFormsDatabinding.class).getValueProperty(domainModelReference, parent);
        }
        catch (DatabindingFailedException ex) {
            return null;
        }
    }

    protected Object getValue(Object element) {
        return null;
    }

    protected void setValue(Object element, Object value) {
    }

    protected void initializeCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
        EMFDataBindingContext bindingContext = new EMFDataBindingContext();
        IObservableValue target = this.doCreateCellEditorObservable(cellEditor);
        IObservableValue model = this.valueProperty.observe(cell.getElement());
        Binding binding = bindingContext.bindValue(target, model);
        this.editingState = new EditingState(bindingContext, binding, target, model);
        this.getViewer().getColumnViewerEditor().addEditorActivationListener((ColumnViewerEditorActivationListener)this.activationListener);
    }

    protected CellEditor getCellEditor(Object element) {
        return this.cellEditor;
    }

    private IObservableValue doCreateCellEditorObservable(CellEditor cellEditor) {
        return WidgetProperties.text((int)16).observe((Widget)cellEditor.getControl());
    }

    protected final void saveCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
        this.editingState.binding.updateTargetToModel();
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    private static <T> T getService(Class<T> clazz) {
        Bundle bundle = FrameworkUtil.getBundle(DMRCellLabelProvider.class);
        BundleContext bundleContext = bundle.getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(clazz);
        Object service = bundleContext.getService(serviceReference);
        bundleContext.ungetService(serviceReference);
        return (T)service;
    }

    private class ColumnViewerEditorActivationListenerHelper
    extends ColumnViewerEditorActivationListener {
        private ColumnViewerEditorActivationListenerHelper() {
        }

        public void afterEditorActivated(ColumnViewerEditorActivationEvent event) {
        }

        public void afterEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
            DMREditingSupport.this.editingState.dispose();
            DMREditingSupport.this.editingState = null;
            DMREditingSupport.this.getViewer().getColumnViewerEditor().removeEditorActivationListener((ColumnViewerEditorActivationListener)this);
            ViewerCell focusCell = DMREditingSupport.this.getViewer().getColumnViewerEditor().getFocusCell();
            if (focusCell != null) {
                DMREditingSupport.this.getViewer().update(focusCell.getElement(), null);
            }
        }

        public void beforeEditorActivated(ColumnViewerEditorActivationEvent event) {
        }

        public void beforeEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
        }
    }

    private class EditingState {
        private final EMFDataBindingContext bindingContext;
        private final IObservableValue target;
        private final IObservableValue model;
        private final Binding binding;

        EditingState(EMFDataBindingContext bindingContext, Binding binding, IObservableValue target, IObservableValue model) {
            this.binding = binding;
            this.target = target;
            this.model = model;
            this.bindingContext = bindingContext;
        }

        void dispose() {
            this.binding.dispose();
            this.target.dispose();
            this.model.dispose();
            this.bindingContext.dispose();
        }
    }
}

