/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.composites;

import java.util.Map;
import org.eclipse.emf.ecp.core.util.ECPProperties;
import org.eclipse.emf.ecp.internal.ui.Messages;
import org.eclipse.emf.ecp.internal.ui.dialogs.PropertyDialog;
import org.eclipse.emf.ecp.internal.ui.model.PropertiesContentProvider;
import org.eclipse.emf.ecp.internal.ui.model.PropertiesLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class PropertiesComposite
extends Composite {
    private final TableViewer tableViewer;
    private final boolean editable;

    public PropertiesComposite(Composite parent, boolean editable, final ECPProperties properties) {
        super(parent, 0);
        this.editable = editable;
        this.setLayout((Layout)new GridLayout(1, false));
        int style = 67584;
        if (!editable) {
            style |= 8;
        }
        this.tableViewer = new TableViewer((Composite)this, style);
        final Table table = this.tableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn = tableViewerColumn.getColumn();
        tblclmnNewColumn.setWidth(122);
        tblclmnNewColumn.setText(Messages.PropertiesComposite_TableColumnName_Key);
        TableViewerColumn tableViewerColumn1 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tableColumn1 = tableViewerColumn1.getColumn();
        tableColumn1.setWidth(314);
        tableColumn1.setText(Messages.PropertiesComposite_TableColumnName_Value);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PropertiesLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new PropertiesContentProvider());
        this.tableViewer.setSorter(new ViewerSorter());
        this.tableViewer.setInput((Object)properties);
        if (editable) {
            Composite buttonBar = new Composite((Composite)this, 0);
            GridLayout gridLayoutButtonBar = new GridLayout(3, false);
            gridLayoutButtonBar.marginWidth = 0;
            gridLayoutButtonBar.marginHeight = 0;
            buttonBar.setLayout((Layout)gridLayoutButtonBar);
            Button addButton = new Button(buttonBar, 0);
            addButton.setText(Messages.PropertiesComposite_AddProperty);
            addButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    PropertyDialog dialog = new PropertyDialog(table.getShell());
                    if (dialog.open() == 0) {
                        String key = dialog.getKey();
                        String value = dialog.getValue();
                        properties.addProperty(key, value);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            Button editButton = new Button(buttonBar, 0);
            editButton.setText(Messages.PropertiesComposite_EditProperty);
            editButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)PropertiesComposite.this.tableViewer.getSelection();
                    Map.Entry property = (Map.Entry)selection.getFirstElement();
                    PropertyDialog dialog = new PropertyDialog(table.getShell(), false, (String)property.getKey(), (String)property.getValue());
                    if (dialog.open() == 0) {
                        properties.addProperty(dialog.getKey(), dialog.getValue());
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Button removeButton = new Button(buttonBar, 0);
            removeButton.setText(Messages.PropertiesComposite_RemoveProperty);
            removeButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)PropertiesComposite.this.tableViewer.getSelection();
                    Map.Entry property = (Map.Entry)selection.getFirstElement();
                    properties.removeProperty((String)property.getKey());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    public final TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public final boolean isEditable() {
        return this.editable;
    }

    protected void checkSubclass() {
    }
}

