/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.nebula.grid;

import java.util.List;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecp.view.spi.table.nebula.grid.GridControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.table.nebula.grid.GridViewerColumnBuilder;
import org.eclipse.emf.ecp.view.spi.table.nebula.grid.menu.GridColumnAction;
import org.eclipse.emf.ecp.view.spi.table.nebula.grid.messages.Messages;
import org.eclipse.emfforms.common.Property;
import org.eclipse.emfforms.internal.common.PropertyHelper;
import org.eclipse.emfforms.spi.swt.table.AbstractTableViewerComposite;
import org.eclipse.emfforms.spi.swt.table.ColumnConfiguration;
import org.eclipse.emfforms.spi.swt.table.TableConfiguration;
import org.eclipse.emfforms.spi.swt.table.TableControl;
import org.eclipse.emfforms.spi.swt.table.TableViewerComparator;
import org.eclipse.emfforms.spi.swt.table.TableViewerSWTCustomization;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.AbstractColumnLayout;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.nebula.jface.gridviewer.GridColumnLayout;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.jface.gridviewer.GridViewerColumn;
import org.eclipse.nebula.jface.gridviewer.GridViewerRow;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public class GridTableViewerComposite
extends AbstractTableViewerComposite<GridTableViewer> {
    private GridTableViewer gridTableViewer;

    public GridTableViewerComposite(Composite parent, int style, Object inputObject, TableViewerSWTCustomization customization, IObservableValue title, IObservableValue tooltip) {
        super(parent, style, inputObject, customization, title, tooltip);
    }

    public GridTableViewer getTableViewer() {
        return this.gridTableViewer;
    }

    protected GridTableViewer createTableViewer(TableViewerSWTCustomization<GridTableViewer> customization, Composite viewerComposite) {
        this.gridTableViewer = (GridTableViewer)customization.createTableViewer(viewerComposite);
        return this.gridTableViewer;
    }

    protected void configureContextMenu(GridTableViewer tableViewer) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        if (this.getEnabledFeatures().contains(TableConfiguration.FEATURE_COLUMN_HIDE_SHOW)) {
            menuMgr.addMenuListener((IMenuListener)new ColumnHideShowMenuListener());
        }
        if (this.getEnabledFeatures().contains(TableConfiguration.FEATURE_COLUMN_FILTER)) {
            menuMgr.addMenuListener((IMenuListener)new ColumnFilterMenuListener());
        }
        Menu menu = menuMgr.createContextMenu(tableViewer.getControl());
        tableViewer.getControl().setMenu(menu);
    }

    protected void configureViewerFilters(GridTableViewer tableViewer) {
        if (this.getEnabledFeatures().contains(TableConfiguration.FEATURE_COLUMN_FILTER)) {
            tableViewer.addFilter((ViewerFilter)new GridColumnFilterViewerFilter(this, tableViewer));
        }
    }

    protected AbstractColumnLayout createLayout(Composite viewerComposite) {
        GridColumnLayout layout = new GridColumnLayout();
        viewerComposite.setLayout((Layout)layout);
        return layout;
    }

    public Widget[] getColumns() {
        return this.gridTableViewer.getGrid().getColumns();
    }

    public void addColumnListener(ControlListener columnlistener) {
        int i = 0;
        while (i < this.gridTableViewer.getGrid().getColumns().length) {
            GridColumn gridColumn = this.gridTableViewer.getGrid().getColumns()[i];
            gridColumn.addControlListener(columnlistener);
            ++i;
        }
    }

    public TableControl getTableControl() {
        return new TableControl(){

            public boolean isDisposed() {
                return GridTableViewerComposite.this.getTableViewer().getGrid().isDisposed();
            }

            public int getItemHeight() {
                return GridTableViewerComposite.this.getTableViewer().getGrid().getItemHeight();
            }

            public boolean getHeaderVisible() {
                return GridTableViewerComposite.this.getTableViewer().getGrid().getHeaderVisible();
            }

            public int getHeaderHeight() {
                return GridTableViewerComposite.this.getTableViewer().getGrid().getHeaderHeight();
            }

            public int getItemCount() {
                return GridTableViewerComposite.this.getTableViewer().getGrid().getItemCount();
            }
        };
    }

    protected ViewerColumn createColumn(ColumnConfiguration config, EMFDataBindingContext emfDataBindingContext, GridTableViewer tableViewer) {
        GridViewerColumn column = (GridViewerColumn)new GridViewerColumnBuilder(config).withDatabinding(emfDataBindingContext).build((AbstractTableViewer)tableViewer);
        return column;
    }

    public void setComparator(final TableViewerComparator comparator, List<Integer> sortableColumns) {
        int i = 0;
        while (i < this.getTableViewer().getGrid().getColumns().length) {
            if (sortableColumns.contains(i)) {
                final int j = i;
                final GridColumn tableColumn = this.getTableViewer().getGrid().getColumns()[i];
                SelectionAdapter selectionAdapter = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        comparator.setColumn(j);
                        tableColumn.setSort(comparator.getDirection());
                        GridTableViewerComposite.this.gridTableViewer.refresh();
                    }
                };
                tableColumn.addSelectionListener((SelectionListener)selectionAdapter);
            }
            ++i;
        }
    }

    private ColumnConfiguration getCurrentColumnConfig() {
        Point cursorLocation;
        Grid grid = this.getTableViewer().getGrid();
        GridColumn column = grid.getColumn(grid.toControl(cursorLocation = grid.getDisplay().getCursorLocation()));
        if (column == null) {
            return null;
        }
        return this.getColumnConfiguration((Widget)column);
    }

    private class ColumnFilterMenuListener
    implements IMenuListener {
        private ColumnFilterMenuListener() {
        }

        public void menuAboutToShow(IMenuManager manager) {
            final ColumnConfiguration columnConfiguration = GridTableViewerComposite.this.getCurrentColumnConfig();
            if (columnConfiguration == null) {
                return;
            }
            manager.add((IAction)new GridColumnAction(GridTableViewerComposite.this, Messages.GridTableViewerComposite_toggleFilterControlsAction){

                public void run() {
                    Widget[] widgetArray = GridTableViewerComposite.this.getColumns();
                    int n = widgetArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Widget widget = widgetArray[n2];
                        PropertyHelper.toggle((Property)this.getGridTableViewer().getColumnConfiguration(widget).showFilterControl());
                        ++n2;
                    }
                    this.getGrid().recalculateHeader();
                }

                @Override
                public boolean isEnabled() {
                    if (!super.isEnabled()) {
                        return false;
                    }
                    return columnConfiguration.getEnabledFeatures().contains(ColumnConfiguration.FEATURE_COLUMN_FILTER);
                }
            });
        }
    }

    private class ColumnHideShowMenuListener
    implements IMenuListener {
        private ColumnHideShowMenuListener() {
        }

        public void menuAboutToShow(IMenuManager manager) {
            final ColumnConfiguration columnConfiguration = GridTableViewerComposite.this.getCurrentColumnConfig();
            if (columnConfiguration == null) {
                return;
            }
            manager.add((IAction)new GridColumnAction(GridTableViewerComposite.this, Messages.GridTableViewerComposite_hideColumnAction){

                public void run() {
                    columnConfiguration.visible().setValue((Object)Boolean.FALSE);
                }

                @Override
                public boolean isEnabled() {
                    if (!super.isEnabled()) {
                        return false;
                    }
                    return columnConfiguration.getEnabledFeatures().contains(ColumnConfiguration.FEATURE_COLUMN_HIDE_SHOW);
                }
            });
            manager.add((IAction)new GridColumnAction(GridTableViewerComposite.this, Messages.GridTableViewerComposite_showAllColumnsAction){

                public void run() {
                    Widget[] widgetArray = GridTableViewerComposite.this.getColumns();
                    int n = widgetArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Widget widget = widgetArray[n2];
                        this.getGridTableViewer().getColumnConfiguration(widget).visible().setValue((Object)Boolean.TRUE);
                        ++n2;
                    }
                }

                @Override
                public boolean isEnabled() {
                    return GridTableViewerComposite.this.getEnabledFeatures().contains(TableConfiguration.FEATURE_COLUMN_HIDE_SHOW) && this.hasHiddenColumns();
                }

                boolean hasHiddenColumns() {
                    Widget[] widgetArray = GridTableViewerComposite.this.getColumns();
                    int n = widgetArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Widget widget = widgetArray[n2];
                        if (!((Boolean)this.getGridTableViewer().getColumnConfiguration(widget).visible().getValue()).booleanValue()) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }
            });
        }
    }

    private class GridColumnFilterViewerFilter
    extends ViewerFilter {
        private final GridTableViewerComposite tableViewerComposite;
        private final GridTableViewer tableViewer;
        private final Grid grid;

        GridColumnFilterViewerFilter(GridTableViewerComposite tableViewerComposite, GridTableViewer tableViewer) {
            this.tableViewerComposite = tableViewerComposite;
            this.tableViewer = tableViewer;
            this.grid = tableViewer.getGrid();
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            this.grid.setRedraw(false);
            GridItem dummyItem = new GridItem(this.grid, 0);
            try {
                dummyItem.setData(element);
                GridViewerRow viewerRow = (GridViewerRow)((GridControlSWTRenderer.CustomGridTableViewer)this.tableViewer).getViewerRowFromItem((Widget)dummyItem);
                Widget[] widgetArray = GridTableViewerComposite.this.getColumns();
                int n = widgetArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Widget widget = widgetArray[n2];
                    ColumnConfiguration config = this.tableViewerComposite.getColumnConfiguration(widget);
                    Object filter = config.matchFilter().getValue();
                    if (filter != null && !String.valueOf(filter).isEmpty()) {
                        GridColumn column = (GridColumn)widget;
                        int columnIndex = this.tableViewer.getGrid().indexOf(column);
                        ViewerCell cell = viewerRow.getCell(columnIndex);
                        CellLabelProvider labelProvider = this.tableViewer.getLabelProvider(columnIndex);
                        labelProvider.update(cell);
                        if (!this.matchesColumnFilter(cell.getText(), filter)) {
                            return false;
                        }
                    }
                    ++n2;
                }
            }
            finally {
                dummyItem.dispose();
                this.grid.setRedraw(true);
            }
            return true;
        }

        protected boolean matchesColumnFilter(Object value, Object filterValue) {
            if (filterValue == null) {
                return false;
            }
            return String.valueOf(value).toLowerCase().contains(String.valueOf(filterValue).toLowerCase());
        }
    }
}

