/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.table.nebula.grid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.internal.table.swt.TableConfigurationHelper;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emfforms.spi.common.converter.EStructuralFeatureValueConverterService;
import org.eclipse.emfforms.spi.common.validation.PreSetValidationService;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class GridPasteKeyListener
implements KeyListener {
    private static final String TAB = "\t";
    private static final String NT = "\n\t";
    private static final String IS_INPUTTABLE = "isInputtable";
    private final Clipboard clipboard;
    private final EMFFormsDatabindingEMF dataBinding;
    private final EStructuralFeatureValueConverterService converterService;
    private final VControl vControl;
    private boolean selectPastedCells = true;
    private boolean alreadyPasted;
    private final PreSetValidationService preSetValidationService;
    private final Display display;
    private final EMFFormsLocalizationService localizationService;

    public GridPasteKeyListener(Display display, VControl vControl, EMFFormsDatabindingEMF dataBinding, EStructuralFeatureValueConverterService converterService, EMFFormsLocalizationService localizationService, boolean selectPastedCells) {
        this.display = display;
        this.localizationService = localizationService;
        this.clipboard = new Clipboard(display);
        this.vControl = vControl;
        this.dataBinding = dataBinding;
        this.converterService = converterService;
        this.selectPastedCells = selectPastedCells;
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(PreSetValidationService.class);
        this.preSetValidationService = serviceReference != null ? (PreSetValidationService)bundleContext.getService(serviceReference) : null;
    }

    public void keyPressed(KeyEvent e) {
        if ((e.stateMask & 0x40000) != 0 && e.keyCode == 118) {
            if (!this.alreadyPasted) {
                Grid grid = (Grid)e.widget;
                Object contents = this.clipboard.getContents((Transfer)TextTransfer.getInstance());
                if (contents instanceof String) {
                    this.pasteSelection(grid, (String)contents);
                }
                this.alreadyPasted = true;
            }
        } else {
            this.alreadyPasted = false;
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void pasteSelection(Grid grid, String contents) {
        if (grid.getCellSelection().length == 0 || !this.getControl().isEnabled() || this.getControl().isReadonly()) {
            return;
        }
        ArrayList<Point> pastedCells = new ArrayList<Point>();
        if (grid.getCellSelection().length > 1 && new StringTokenizer(contents, NT, false).countTokens() == 1 && GridPasteKeyListener.fillSelectionWithMultipleCopies(grid.getCellSelection(), contents)) {
            Point[] pointArray = GridPasteKeyListener.getFillStartPoints(grid.getCellSelection());
            int n = pointArray.length;
            int n2 = 0;
            while (n2 < n) {
                Point startItem = pointArray[n2];
                pastedCells.addAll(this.pasteContents(startItem, grid, contents));
                ++n2;
            }
        } else {
            Point startItem = grid.getCellSelection()[0];
            pastedCells.addAll(this.pasteContents(startItem, grid, contents));
        }
        if (this.selectPastedCells && !pastedCells.isEmpty() && grid.isCellSelectionEnabled()) {
            grid.setCellSelection(pastedCells.toArray(new Point[0]));
        }
    }

    static Point[] getFillStartPoints(Point[] cellSelection) {
        Map<Integer, Set<Integer>> rowToSelectedColumns = GridPasteKeyListener.createSelectionMap(cellSelection);
        Point[] result = new Point[rowToSelectedColumns.size()];
        Set<Integer> columns = rowToSelectedColumns.values().iterator().next();
        int startColumn = Collections.min(columns);
        int i = 0;
        for (Integer startRow : rowToSelectedColumns.keySet()) {
            result[i++] = new Point(startColumn, startRow.intValue());
        }
        return result;
    }

    static boolean fillSelectionWithMultipleCopies(Point[] cellSelection, String contents) {
        Map<Integer, Set<Integer>> rowToSelectedColumns = GridPasteKeyListener.createSelectionMap(cellSelection);
        if (rowToSelectedColumns.size() < 2) {
            return false;
        }
        Iterator<Set<Integer>> columnSetInterator = rowToSelectedColumns.values().iterator();
        Set<Integer> referenceSet = columnSetInterator.next();
        while (columnSetInterator.hasNext()) {
            Set<Integer> next = columnSetInterator.next();
            if (referenceSet.equals(next)) continue;
            return false;
        }
        if (referenceSet.size() == 1) {
            return true;
        }
        if (contents.split(TAB).length != referenceSet.size()) {
            return false;
        }
        ArrayList<Integer> selectedColumnIndices = new ArrayList<Integer>(referenceSet);
        Collections.sort(selectedColumnIndices);
        Iterator<Integer> selectedColumnIndicesIterator = selectedColumnIndices.iterator();
        Integer ref = selectedColumnIndicesIterator.next();
        while (selectedColumnIndicesIterator.hasNext()) {
            if ((ref = Integer.valueOf(ref + 1)) == selectedColumnIndicesIterator.next()) continue;
            return false;
        }
        return true;
    }

    private static Map<Integer, Set<Integer>> createSelectionMap(Point[] cellSelection) {
        LinkedHashMap<Integer, Set<Integer>> rowToSelectedColumns = new LinkedHashMap<Integer, Set<Integer>>();
        Point[] pointArray = cellSelection;
        int n = cellSelection.length;
        int n2 = 0;
        while (n2 < n) {
            Point point = pointArray[n2];
            if (!rowToSelectedColumns.containsKey(point.y)) {
                rowToSelectedColumns.put(point.y, new LinkedHashSet());
            }
            ((Set)rowToSelectedColumns.get(point.y)).add(point.x);
            ++n2;
        }
        return rowToSelectedColumns;
    }

    /*
     * Unable to fully structure code
     */
    public List<Point> pasteContents(Point startItem, Grid grid, String contents) {
        startColumn = startItem.x;
        startRow = startItem.y;
        pastedCells = new ArrayList<Point>();
        invalidValues = new ArrayList<String>();
        relativeRow = 0;
        rows = contents.split("\r\n|\n", -1);
        this.prePasteContents();
        try {
            var13_10 = rows;
            var12_11 = rows.length;
            var11_12 = 0;
            while (var11_12 < var12_11) {
                row = var13_10[var11_12];
                relativeColumn = 0;
                var18_18 = row.split("\t", -1);
                var17_17 = var18_18.length;
                var16_16 = 0;
                while (var16_16 < var17_17) {
                    block17: {
                        block22: {
                            block18: {
                                block16: {
                                    block21: {
                                        block20: {
                                            cellValueSplit = var18_18[var16_16];
                                            cellValue = this.modifyCellValue(cellValueSplit);
                                            insertionColumnIndex = startColumn + relativeColumn;
                                            insertionRowIndex = startRow + relativeRow;
                                            if (insertionColumnIndex < grid.getColumnCount()) break block20;
                                            ++relativeColumn;
                                            break block17;
                                        }
                                        dmr = (VDomainModelReference)grid.getColumn(insertionColumnIndex).getData("domain_model_reference");
                                        if (dmr != null && (!(this.getControl() instanceof VTableControl) || !TableConfigurationHelper.isReadOnly((VTableControl)((VTableControl)this.getControl()), (VDomainModelReference)dmr))) break block21;
                                        ++relativeColumn;
                                        break block17;
                                    }
                                    if (insertionRowIndex >= grid.getItemCount()) break block22;
                                    eObject = (EObject)grid.getItem(insertionRowIndex).getData();
                                    if (this.isEObjectReadOnly(eObject)) break block17;
                                    value = null;
                                    value = this.dataBinding.getObservableValue(dmr, eObject);
                                    feature = (EStructuralFeature)value.getValueType();
                                    convertedValue = this.getConverterService().convertToModelValue(eObject, feature, cellValue);
                                    if (!this.isSettingReadOnly(eObject, feature, convertedValue)) break block16;
                                    ** if (value == null) goto lbl-1000
lbl-1000:
                                    // 1 sources

                                    {
                                        value.dispose();
                                    }
lbl-1000:
                                    // 2 sources

                                    {
                                        break block17;
                                    }
                                }
                                try {
                                    try {
                                        v0 = valid = convertedValue != null;
                                        if (this.preSetValidationService != null) {
                                            context = new LinkedHashMap<String, Object>();
                                            context.put("rootEObject", ((IObserving)IObserving.class.cast(value)).getObserved());
                                            diag = this.preSetValidationService.validate(feature, valid != false ? convertedValue : cellValue, context);
                                            v1 = valid = diag.getSeverity() == 0;
                                            if (!valid) {
                                                invalidValues.add(this.extractDiagnosticMessage(diag, feature, cellValue));
                                            }
                                        }
                                        if (!this.canBePasted(feature, cellValue, eObject, setting = ((InternalEObject)(observedEobject = (EObject)((IObserving)value).getObserved())).eSetting(feature))) {
                                            invalidValues.add(cellValue);
                                            break block18;
                                        }
                                        if (!valid) break block18;
                                        this.setValue(value, convertedValue);
                                        pastedCells.add(new Point(insertionColumnIndex, insertionRowIndex));
                                    }
                                    catch (Exception var25_26) {
                                        if (value == null) ** GOTO lbl77
                                        value.dispose();
                                    }
                                }
                                catch (Throwable var30_31) {
                                    if (value != null) {
                                        value.dispose();
                                    }
                                    throw var30_31;
                                }
                            }
                            if (value != null) {
                                value.dispose();
                            }
                        }
                        ++relativeColumn;
                    }
                    ++var16_16;
                }
                ++relativeRow;
                ++var11_12;
            }
        }
        finally {
            this.postPasteContents();
        }
        this.showErrors(invalidValues);
        return pastedCells;
    }

    protected void prePasteContents() {
    }

    protected void postPasteContents() {
    }

    protected String modifyCellValue(String cellValueSplit) {
        return cellValueSplit;
    }

    protected boolean isEObjectReadOnly(EObject eObject) {
        return false;
    }

    protected boolean isSettingReadOnly(EObject eObject, EStructuralFeature feature, Object convertedValue) {
        return false;
    }

    protected void showErrors(List<String> msgs) {
        if (!msgs.isEmpty()) {
            GridPasteKeyListener.showDialog(this.display.getActiveShell(), this.localizationService.getString(FrameworkUtil.getBundle(this.getClass()), "InvalidPaste.Title"), this.localizationService.getString(FrameworkUtil.getBundle(this.getClass()), "InvalidPaste.Message"), msgs);
        }
    }

    protected boolean canBePasted(EStructuralFeature feature, String cellValue, EObject eObject, EStructuralFeature.Setting setting) {
        if (!EEnum.class.isInstance(feature.getEType())) {
            return true;
        }
        EEnum eEnum = (EEnum)feature.getEType();
        for (EEnumLiteral literal : eEnum.getELiterals()) {
            String isInputtable = EcoreUtil.getAnnotation((EModelElement)literal, (String)"http://org/eclipse/emf/ecp/view/model/170", (String)IS_INPUTTABLE);
            if (!literal.getLiteral().equals(cellValue) || isInputtable == null) continue;
            return Boolean.getBoolean(isInputtable);
        }
        return true;
    }

    protected void setValue(IObservableValue value, Object convertedValue) {
        value.setValue(convertedValue);
    }

    protected String extractDiagnosticMessage(Diagnostic diag, EStructuralFeature feature, String value) {
        return ((Diagnostic)diag.getChildren().get(0)).getMessage();
    }

    private static void showDialog(Shell shell, String title, String msg, List<String> warnings) {
        StringBuilder builder = new StringBuilder();
        builder.append(msg);
        for (String warning : warnings) {
            builder.append("- " + warning).append("\n");
        }
        MessageDialog.openWarning((Shell)shell, (String)title, (String)builder.toString());
    }

    protected EStructuralFeatureValueConverterService getConverterService() {
        return this.converterService;
    }

    protected VControl getControl() {
        return this.vControl;
    }
}

