/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.datatemplate;

import java.util.Enumeration;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emfforms.internal.core.services.label.BundleResolver;
import org.eclipse.emfforms.internal.core.services.label.BundleResolverImpl;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

final class EClassLabelProvider
implements ILabelProvider {
    private final EMFFormsLocalizationService l10nService;
    private final BundleResolver bundleResolver;

    EClassLabelProvider(EMFFormsLocalizationService l10nService) {
        this.l10nService = l10nService;
        this.bundleResolver = new BundleResolverImpl();
    }

    public void dispose() {
    }

    public String getText(Object element) {
        Bundle editBundle;
        if (!(element instanceof EClass)) {
            return String.valueOf(element);
        }
        EClass eClass = (EClass)element;
        try {
            editBundle = this.bundleResolver.getEditBundle((EClassifier)eClass);
        }
        catch (BundleResolver.NoBundleFoundException e) {
            editBundle = null;
        }
        return editBundle != null ? this.l10nService.getString(editBundle, String.format("_UI_%s_type", eClass.getName())) : eClass.getName();
    }

    public Image getImage(Object element) {
        if (!(element instanceof EClass)) {
            return null;
        }
        EClass eClass = (EClass)element;
        Enumeration imageURLs = null;
        try {
            Bundle editBundle = this.bundleResolver.getEditBundle((EClassifier)eClass);
            imageURLs = editBundle.findEntries("icons/full/obj16", String.format("%s.*", eClass.getName()), false);
        }
        catch (BundleResolver.NoBundleFoundException noBundleFoundException) {
            // empty catch block
        }
        return imageURLs != null && imageURLs.hasMoreElements() ? ExtendedImageRegistry.getInstance().getImage(imageURLs.nextElement()) : null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

