/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.core.swt;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.core.swt.Activator;
import org.eclipse.emf.ecp.view.model.common.AbstractGridCell;
import org.eclipse.emf.ecp.view.model.common.AbstractRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.AbstractControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.provider.ECPTooltipModifierHelper;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.SWTDataElementIdHelper;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public abstract class SimpleControlSWTRenderer
extends AbstractControlSWTRenderer<VControl> {
    private static final String UNSET = "unset";
    private static final String ICONS_UNSET_FEATURE = "icons/unset_feature.png";
    private static final String ICONS_SET_FEATURE = "icons/set_feature.png";
    private static final Point VALIDATION_PREFERRED_SIZE = new Point(16, 17);
    private SWTGridDescription rendererGridDescription;
    private UnsetModelChangeListener unsetModelChangeListener;
    private Label validationIcon;
    private Control editControl;

    public SimpleControlSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            int columns = this.showLabel() ? 3 : 2;
            this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createEmptyGridDescription();
            this.rendererGridDescription.setRows(1);
            this.rendererGridDescription.setColumns(columns);
            ArrayList<SWTGridCell> grid = new ArrayList<SWTGridCell>();
            if (columns == 3) {
                SWTGridCell labelCell = this.createLabelCell(grid.size());
                grid.add(labelCell);
            }
            SWTGridCell validationCell = this.createValidationCell(grid.size());
            grid.add(validationCell);
            SWTGridCell controlCel = this.createControlCell(grid.size());
            grid.add(controlCel);
            this.rendererGridDescription.setGrid(grid);
        }
        return this.rendererGridDescription;
    }

    private boolean showLabel() {
        switch (((VControl)this.getVElement()).getLabelAlignment()) {
            case DEFAULT: 
            case LEFT: {
                return true;
            }
            case NONE: {
                return false;
            }
        }
        this.getReportService().report(new AbstractReport(MessageFormat.format("Label alignment {0} is not supported by renderer {1}. Label alignment set to default.", ((VControl)this.getVElement()).getLabelAlignment().getLiteral(), ((Object)((Object)this)).getClass().getName()), 1));
        ((VControl)this.getVElement()).setLabelAlignment(LabelAlignment.DEFAULT);
        return true;
    }

    protected SWTGridCell createLabelCell(int column) {
        SWTGridCell labelCell = new SWTGridCell(0, column, (AbstractSWTRenderer)this);
        labelCell.setHorizontalGrab(false);
        labelCell.setVerticalGrab(false);
        labelCell.setHorizontalFill(false);
        labelCell.setHorizontalAlignment(AbstractGridCell.Alignment.BEGINNING);
        labelCell.setVerticalFill(false);
        labelCell.setVerticalAlignment(AbstractGridCell.Alignment.CENTER);
        labelCell.setRenderer((AbstractRenderer)this);
        return labelCell;
    }

    protected SWTGridCell createValidationCell(int column) {
        SWTGridCell validationCell = new SWTGridCell(0, column, (AbstractSWTRenderer)this);
        validationCell.setHorizontalGrab(false);
        validationCell.setVerticalGrab(false);
        validationCell.setHorizontalFill(false);
        validationCell.setHorizontalAlignment(AbstractGridCell.Alignment.CENTER);
        validationCell.setVerticalFill(false);
        validationCell.setVerticalAlignment(AbstractGridCell.Alignment.CENTER);
        validationCell.setRenderer((AbstractRenderer)this);
        validationCell.setPreferredSize(VALIDATION_PREFERRED_SIZE);
        return validationCell;
    }

    protected SWTGridCell createControlCell(int column) {
        SWTGridCell controlCell = new SWTGridCell(0, column, (AbstractSWTRenderer)this);
        controlCell.setHorizontalGrab(true);
        controlCell.setVerticalGrab(false);
        controlCell.setHorizontalFill(true);
        controlCell.setVerticalFill(false);
        controlCell.setVerticalAlignment(AbstractGridCell.Alignment.CENTER);
        controlCell.setRenderer((AbstractRenderer)this);
        return controlCell;
    }

    protected final Control renderControl(SWTGridCell gridCell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        int controlIndex = gridCell.getColumn();
        if (((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.NONE) {
            ++controlIndex;
        }
        switch (controlIndex) {
            case 0: {
                return this.createLabel(parent);
            }
            case 1: {
                this.validationIcon = this.createValidationIcon(parent);
                return this.validationIcon;
            }
            case 2: {
                this.editControl = this.createEditControl(parent);
                return this.editControl;
            }
        }
        throw new IllegalArgumentException(String.format("The provided SWTGridCell (%1$s) cannot be used by this (%2$s) renderer.", gridCell.toString(), ((Object)((Object)this)).toString()));
    }

    private Control createEditControl(Composite parent) {
        try {
            if (this.isUnsettable()) {
                return this.createUnsettableControl(parent);
            }
            Control control = this.createControl(parent);
            this.setControlIdData(control);
            return control;
        }
        catch (DatabindingFailedException ex) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
            Label errorLabel = new Label(parent, 0);
            errorLabel.setText(ex.getMessage());
            return errorLabel;
        }
    }

    protected boolean isUnsettable() throws DatabindingFailedException {
        IValueProperty valueProperty = this.getEMFFormsDatabinding().getValueProperty(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
        EStructuralFeature feature = (EStructuralFeature)valueProperty.getValueType();
        return feature.isUnsettable();
    }

    private Control createUnsettableControl(Composite parent) throws DatabindingFailedException {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(composite);
        Composite controlComposite = new Composite(composite, 0);
        controlComposite.setBackground(parent.getBackground());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)controlComposite);
        StackLayout sl = new StackLayout();
        controlComposite.setLayout((Layout)sl);
        Control baseControl = this.createControl(controlComposite);
        this.setControlIdData(baseControl);
        Control createUnsetLabel = this.createUnsetLabel(controlComposite);
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)createUnsetLabel, (VElement)this.getVElement(), (String)UNSET, (ViewModelContext)this.getViewModelContext());
        Button unsetButton = new Button(composite, 8);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, false).applyTo((Control)unsetButton);
        unsetButton.addSelectionListener((SelectionListener)new UnsetSelectionAdapter(sl, unsetButton, createUnsetLabel, baseControl, controlComposite));
        this.unsetModelChangeListener = this.registerUnsetStateListener(controlComposite, sl, baseControl, createUnsetLabel, unsetButton);
        return composite;
    }

    private UnsetModelChangeListener registerUnsetStateListener(Composite controlComposite, StackLayout sl, Control baseControl, Control createUnsetLabel, Button unsetButton) throws DatabindingFailedException {
        EStructuralFeature structuralFeature = (EStructuralFeature)this.getModelValue().getValueType();
        EObject eObject = (EObject)((IObserving)this.getModelValue()).getObserved();
        if (eObject.eIsSet(structuralFeature)) {
            sl.topControl = baseControl;
            unsetButton.setImage(Activator.getImage(ICONS_UNSET_FEATURE));
        } else {
            sl.topControl = createUnsetLabel;
            unsetButton.setImage(Activator.getImage(ICONS_SET_FEATURE));
        }
        UnsetModelChangeListener unsetModelChangeListener = new UnsetModelChangeListener(eObject, unsetButton, structuralFeature, createUnsetLabel, controlComposite, sl, baseControl);
        this.getViewModelContext().registerDomainChangeListener((ModelChangeListener)unsetModelChangeListener);
        return unsetModelChangeListener;
    }

    private Control createUnsetLabel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(true).applyTo(composite);
        Label unsetLabel = new Label(composite, 0);
        unsetLabel.setBackground(parent.getBackground());
        unsetLabel.setText(this.getUnsetText());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).applyTo((Control)unsetLabel);
        return composite;
    }

    protected abstract String getUnsetText();

    protected void setValidationColor(Control control, Color validationColor) {
        control.setBackground(validationColor);
    }

    protected void setValidationForegroundColor(Control control, Color validationColor) {
        control.setForeground(validationColor);
    }

    protected void setControlEnabled(SWTGridCell gridCell, Control control, boolean enabled) {
        int controlIndex = gridCell.getColumn();
        if (((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.NONE) {
            ++controlIndex;
        }
        switch (controlIndex) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                control.setEnabled(enabled);
            }
        }
    }

    protected final void applyValidation() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SimpleControlSWTRenderer.this.getControls().size() == 0 || ((Control)SimpleControlSWTRenderer.this.getControls().values().iterator().next()).isDisposed()) {
                    return;
                }
                SimpleControlSWTRenderer.this.applyInnerValidation();
            }
        });
    }

    private void applyInnerValidation() {
        if (this.validationIcon == null || this.editControl == null) {
            return;
        }
        if (this.validationIcon.isDisposed()) {
            return;
        }
        int highestSeverity = 0;
        if (((VControl)this.getVElement()).getDiagnostic() != null) {
            highestSeverity = ((VControl)this.getVElement()).getDiagnostic().getHighestSeverity();
        }
        this.validationIcon.setImage(this.getValidationIcon(highestSeverity));
        this.setValidationColor(this.editControl, this.getValidationBackgroundColor(highestSeverity));
        this.setValidationForegroundColor(this.editControl, this.getValidationForegroundColor(highestSeverity));
        if (((VControl)this.getVElement()).getDiagnostic() == null) {
            this.validationIcon.setToolTipText(null);
        } else {
            this.validationIcon.setToolTipText(ECPTooltipModifierHelper.modifyString((String)((VControl)this.getVElement()).getDiagnostic().getMessage(), null));
        }
    }

    protected abstract Control createControl(Composite var1) throws DatabindingFailedException;

    protected void setControlIdData(Control control) {
        if (control != null) {
            SWTDataElementIdHelper.setElementIdDataForVControl((Widget)control, (VControl)((VControl)this.getVElement()), (ViewModelContext)this.getViewModelContext());
        }
    }

    @Override
    protected void dispose() {
        this.rendererGridDescription = null;
        if (this.unsetModelChangeListener != null) {
            this.getViewModelContext().unregisterDomainChangeListener((ModelChangeListener)this.unsetModelChangeListener);
            this.unsetModelChangeListener = null;
        }
        this.validationIcon = null;
        this.editControl = null;
        super.dispose();
    }

    @Override
    protected void rootDomainModelChanged() throws DatabindingFailedException {
        if (this.unsetModelChangeListener == null) {
            super.rootDomainModelChanged();
            return;
        }
        this.getViewModelContext().unregisterDomainChangeListener((ModelChangeListener)this.unsetModelChangeListener);
        this.unsetModelChangeListener = this.registerUnsetStateListener(this.unsetModelChangeListener.getControlComposite(), this.unsetModelChangeListener.getStack(), this.unsetModelChangeListener.getBaseControl(), this.unsetModelChangeListener.getUnsetLabel(), this.unsetModelChangeListener.getUnsetButton());
        super.rootDomainModelChanged();
    }

    private static final class UnsetModelChangeListener
    implements ModelChangeListener {
        private final EObject eObject;
        private final Button unsetButton;
        private final EStructuralFeature structuralFeature;
        private final Control createUnsetLabel;
        private final Composite controlComposite;
        private final StackLayout sl;
        private final Control baseControl;

        private UnsetModelChangeListener(EObject eObject, Button unsetButton, EStructuralFeature structuralFeature, Control createUnsetLabel, Composite controlComposite, StackLayout sl, Control baseControl) {
            this.eObject = eObject;
            this.unsetButton = unsetButton;
            this.structuralFeature = structuralFeature;
            this.createUnsetLabel = createUnsetLabel;
            this.controlComposite = controlComposite;
            this.sl = sl;
            this.baseControl = baseControl;
        }

        public void notifyChange(ModelChangeNotification notification) {
            this.updateTopControl();
        }

        void updateTopControl() {
            if (this.eObject.eIsSet(this.structuralFeature)) {
                if (this.getStack().topControl == this.getBaseControl()) {
                    return;
                }
                this.getStack().topControl = this.getBaseControl();
                this.getUnsetButton().setImage(Activator.getImage(SimpleControlSWTRenderer.ICONS_UNSET_FEATURE));
                this.getControlComposite().layout(true);
            } else {
                if (this.getStack().topControl == this.getUnsetLabel()) {
                    return;
                }
                this.getStack().topControl = this.getUnsetLabel();
                this.getUnsetButton().setImage(Activator.getImage(SimpleControlSWTRenderer.ICONS_SET_FEATURE));
                this.getControlComposite().layout(true);
            }
        }

        Composite getControlComposite() {
            return this.controlComposite;
        }

        StackLayout getStack() {
            return this.sl;
        }

        Control getBaseControl() {
            return this.baseControl;
        }

        Control getUnsetLabel() {
            return this.createUnsetLabel;
        }

        Button getUnsetButton() {
            return this.unsetButton;
        }
    }

    private final class UnsetSelectionAdapter
    extends SelectionAdapter {
        private final StackLayout sl;
        private final Button unsetButton;
        private final Control createUnsetLabel;
        private final Control baseControl;
        private final Composite controlComposite;

        private UnsetSelectionAdapter(StackLayout sl, Button unsetButton, Control createUnsetLabel, Control baseControl, Composite controlComposite) {
            this.sl = sl;
            this.unsetButton = unsetButton;
            this.createUnsetLabel = createUnsetLabel;
            this.baseControl = baseControl;
            this.controlComposite = controlComposite;
        }

        public void widgetSelected(SelectionEvent e) {
            IObservableValue observableValue;
            super.widgetSelected(e);
            try {
                observableValue = SimpleControlSWTRenderer.this.getEMFFormsDatabinding().getObservableValue(((VControl)SimpleControlSWTRenderer.this.getVElement()).getDomainModelReference(), SimpleControlSWTRenderer.this.getViewModelContext().getDomainModel());
            }
            catch (DatabindingFailedException ex) {
                SimpleControlSWTRenderer.this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                return;
            }
            EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
            EObject eObject = (EObject)((IObserving)observableValue).getObserved();
            observableValue.dispose();
            Object value = null;
            if (!eObject.eIsSet(structuralFeature)) {
                this.sl.topControl = this.baseControl;
                this.unsetButton.setImage(Activator.getImage(SimpleControlSWTRenderer.ICONS_UNSET_FEATURE));
                value = structuralFeature.getDefaultValue();
            } else {
                this.sl.topControl = this.createUnsetLabel;
                this.unsetButton.setImage(Activator.getImage(SimpleControlSWTRenderer.ICONS_SET_FEATURE));
                value = SetCommand.UNSET_VALUE;
            }
            EditingDomain editingDomain = SimpleControlSWTRenderer.this.getEditingDomain(eObject);
            editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)eObject, (Object)structuralFeature, (Object)value));
            this.controlComposite.layout();
        }
    }
}

