/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.nebula.grid;

import java.util.LinkedHashSet;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTView;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.swt.masterdetail.DetailViewCache;
import org.eclipse.emf.ecp.view.spi.swt.masterdetail.DetailViewManager;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.nebula.grid.GridControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.util.swt.ImageRegistryService;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.converter.EStructuralFeatureValueConverterService;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class GridControlDetailPanelRenderer
extends GridControlSWTRenderer {
    private Composite detailPanel;
    private Composite border;
    private ScrolledComposite scrolledComposite;
    private DetailViewManager detailManager;

    @Inject
    public GridControlDetailPanelRenderer(VTableControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabindingEMF emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, ImageRegistryService imageRegistryService, EMFFormsEditSupport emfFormsEditSupport, EStructuralFeatureValueConverterService converterService, EMFFormsLocalizationService localizationService) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, imageRegistryService, emfFormsEditSupport, converterService, localizationService);
    }

    protected void dispose() {
        if (this.detailManager != null) {
            this.detailManager.dispose();
        }
        super.dispose();
    }

    protected Composite createControlComposite(Composite composite) {
        this.border = this.createBorderComposite(composite);
        SashForm sashForm = this.createSash(this.border);
        Composite tableCompositeWrapper = new Composite((Composite)sashForm, 0);
        GridLayoutFactory.fillDefaults().applyTo(tableCompositeWrapper);
        Composite tableComposite = this.createTableComposite(tableCompositeWrapper);
        this.scrolledComposite = this.createScrolledDetail((Composite)sashForm);
        this.scrolledComposite.addListener(11, event -> this.scrolledComposite.setMinSize(this.detailPanel.computeSize(-1, -1)));
        sashForm.setWeights(new int[]{1, 2});
        return tableComposite;
    }

    protected Composite createBorderComposite(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        GridLayout gridLayout = GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).create();
        composite.setLayout((Layout)gridLayout);
        int totalHeight = this.getTableHeightHint() + this.getDetailPanelHeightHint() + gridLayout.verticalSpacing;
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(1, totalHeight).applyTo((Control)composite);
        return composite;
    }

    protected SashForm createSash(Composite parent) {
        SashForm sash = new SashForm(parent, 512);
        sash.setBackground(parent.getBackground());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)sash);
        sash.setSashWidth(5);
        return sash;
    }

    protected Composite createTableComposite(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(1, this.getTableHeightHint()).applyTo((Control)tableComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(tableComposite);
        return tableComposite;
    }

    protected ScrolledComposite createScrolledDetail(Composite parent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 2816);
        scrolledComposite.setBackground(parent.getBackground());
        scrolledComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)scrolledComposite);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        this.detailPanel = this.createDetailPanel(scrolledComposite);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.detailPanel);
        scrolledComposite.setContent((Control)this.detailPanel);
        this.createDetailManager(this.detailPanel);
        this.detailManager.cacheCurrentDetail();
        return scrolledComposite;
    }

    void createDetailManager(Composite parent) {
        this.detailManager = new DetailViewManager(parent, __ -> ((VTableControl)this.getVElement()).getDetailView());
        this.detailManager.setCache(DetailViewCache.createCache((ViewModelContext)this.getViewModelContext()));
        this.detailManager.layoutDetailParent(parent);
    }

    protected int getDetailPanelHeightHint() {
        return 400;
    }

    protected Composite createDetailPanel(ScrolledComposite composite) {
        Composite detail = new Composite((Composite)composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).margins(5, 5).applyTo(detail);
        return detail;
    }

    protected VView getView(EObject selectedEObject) {
        return this.detailManager.getDetailView(selectedEObject);
    }

    protected void applyEnable() {
        super.applyEnable();
        if (this.detailManager != null) {
            this.detailManager.setDetailReadOnly(!((VTableControl)this.getVElement()).isEffectivelyEnabled() || ((VTableControl)this.getVElement()).isEffectivelyReadonly());
        }
    }

    protected void applyReadOnly() {
        super.applyReadOnly();
        if (this.detailManager != null) {
            this.detailManager.setDetailReadOnly(!((VTableControl)this.getVElement()).isEffectivelyEnabled() || ((VTableControl)this.getVElement()).isEffectivelyReadonly());
        }
    }

    protected void viewerSelectionChanged(SelectionChangedEvent event) {
        if (event.getSelection().isEmpty()) {
            this.handleEmptySelection();
        } else if (((IStructuredSelection)IStructuredSelection.class.cast(event.getSelection())).size() != 1) {
            this.handleMultiSelection((IStructuredSelection)event.getSelection());
        } else {
            this.handleSingleSelection((IStructuredSelection)event.getSelection());
        }
        super.viewerSelectionChanged(event);
    }

    protected void handleSingleSelection(IStructuredSelection selection) {
        EObject object = (EObject)selection.getFirstElement();
        ECPSWTView currentDetail = this.detailManager.getCurrentDetail();
        if (currentDetail != null && currentDetail.getViewModelContext().getDomainModel() == object) {
            return;
        }
        this.disposeDetail();
        this.renderSelectedObject((Composite)this.detailManager.getDetailContainer(), object);
        this.border.layout(true, true);
        this.scrolledComposite.setMinSize(this.detailPanel.computeSize(-1, -1));
    }

    protected void renderSelectedObject(Composite composite, EObject eObject) {
        if (this.detailManager == null) {
            this.createDetailManager(composite);
        }
        this.detailManager.render(this.getViewModelContext(), this.getVElement(), eObject);
    }

    protected void handleMultiSelection(IStructuredSelection selection) {
        this.disposeDetail();
    }

    protected void handleEmptySelection() {
        this.disposeDetail();
    }

    private void disposeDetail() {
        this.detailManager.cacheCurrentDetail();
    }

    @Deprecated
    protected void deleteRows(List<EObject> deletionList, EObject eObject, EStructuralFeature structuralFeature) {
        super.deleteRows(deletionList, eObject, structuralFeature);
        LinkedHashSet toDelete = new LinkedHashSet();
        VDiagnostic diagnostic = ((VTableControl)this.getVElement()).getDiagnostic();
        if (diagnostic == null) {
            return;
        }
        for (EObject deleteObject : deletionList) {
            toDelete.addAll(diagnostic.getDiagnostics(deleteObject));
            TreeIterator eAllContents = deleteObject.eAllContents();
            while (eAllContents.hasNext()) {
                toDelete.addAll(diagnostic.getDiagnostics((EObject)eAllContents.next()));
            }
        }
        diagnostic.getDiagnostics().removeAll(toDelete);
    }
}

