/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.spreadsheet.core.renderer.categorization;

import org.apache.poi.ss.usermodel.Workbook;
import org.eclipse.emf.ecp.view.spi.categorization.model.VAbstractCategorization;
import org.eclipse.emf.ecp.view.spi.categorization.model.VCategorization;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsAbstractSpreadsheetRenderer;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsNoRendererException;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsSpreadsheetRenderTarget;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsSpreadsheetRendererFactory;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsSpreadsheetReport;

public class EMFFormsCategorizationRenderer
extends EMFFormsAbstractSpreadsheetRenderer<VCategorization> {
    private final EMFFormsSpreadsheetRendererFactory rendererFactory;
    private final ReportService reportService;

    public EMFFormsCategorizationRenderer(EMFFormsSpreadsheetRendererFactory rendererFactory, ReportService reportService) {
        this.rendererFactory = rendererFactory;
        this.reportService = reportService;
    }

    public int render(Workbook workbook, VCategorization vElement, ViewModelContext viewModelContext, EMFFormsSpreadsheetRenderTarget renderTarget) {
        int numberRenderedColumns = 0;
        for (VAbstractCategorization abstractCategorization : vElement.getCategorizations()) {
            try {
                EMFFormsAbstractSpreadsheetRenderer renderer = this.rendererFactory.getRendererInstance((VElement)abstractCategorization, viewModelContext);
                numberRenderedColumns += renderer.render(workbook, (VElement)abstractCategorization, viewModelContext, renderTarget);
            }
            catch (EMFFormsNoRendererException ex) {
                this.reportService.report((AbstractReport)new EMFFormsSpreadsheetReport((Throwable)ex, 4));
            }
        }
        return numberRenderedColumns;
    }
}

