/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.segments.index;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsSegmentResolver;
import org.eclipse.emfforms.spi.core.services.structuralchange.StructuralChangeSegmentTester;
import org.eclipse.emfforms.spi.view.indexsegment.model.VIndexDomainModelReferenceSegment;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(name="IndexSegmentStructuralChangeTester")
public class IndexSegmentStructuralChangeTester
implements StructuralChangeSegmentTester {
    private EMFFormsSegmentResolver segmentResolver;
    private ReportService reportService;

    @Reference(unbind="-")
    protected void setEMFFormsSegmentResolver(EMFFormsSegmentResolver segmentResolver) {
        this.segmentResolver = segmentResolver;
    }

    @Reference(unbind="-")
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public boolean isStructureChanged(VDomainModelReferenceSegment segment, EObject domainObject, ModelChangeNotification notification) {
        EReference eReference;
        EStructuralFeature.Setting setting;
        Assert.create((Object)segment).notNull();
        Assert.create((Object)domainObject).notNull();
        Assert.create((Object)segment).notNull().ofClass(VIndexDomainModelReferenceSegment.class);
        if (notification.getRawNotification().isTouch()) {
            return false;
        }
        VIndexDomainModelReferenceSegment indexSegment = (VIndexDomainModelReferenceSegment)segment;
        try {
            setting = this.segmentResolver.resolveSegment((VDomainModelReferenceSegment)indexSegment, domainObject);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return false;
        }
        if (EReference.class.isInstance(setting.getEStructuralFeature()) && (eReference = (EReference)setting.getEStructuralFeature()).equals(notification.getStructuralFeature()) && notification.getNotifier() == setting.getEObject()) {
            int event = notification.getRawNotification().getEventType();
            int position = notification.getRawNotification().getPosition();
            int index = indexSegment.getIndex();
            EList list = (EList)setting.getEObject().eGet(setting.getEStructuralFeature());
            if (event == 3 && position <= index && index < list.size()) {
                return true;
            }
            if (event == 4 && position <= index && index <= list.size()) {
                return true;
            }
            if (event == 5 || event == 6 || event == 7) {
                return true;
            }
        }
        return false;
    }

    public double isApplicable(VDomainModelReferenceSegment segment) {
        if (segment == null) {
            this.reportService.report(new AbstractReport("The given domain model reference segment was null.", 2));
            return Double.NEGATIVE_INFINITY;
        }
        if (VIndexDomainModelReferenceSegment.class.isInstance(segment)) {
            return 5.0;
        }
        return Double.NEGATIVE_INFINITY;
    }
}

