/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.util;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayImageDescriptor
extends CompositeImageDescriptor {
    public static final int UPPER_LEFT = 0;
    public static final int UPPER_RIGHT = 1;
    public static final int LOWER_RIGHT = 2;
    public static final int LOWER_LEFT = 3;
    private static final int DEFAULT_IMAGE_WIDTH = 19;
    private static final int DEFAULT_IMAGE_HEIGHT = 19;
    private final ImageDescriptor overlayDesc;
    private final int overlayPos = 2;
    private final int offset = 3;
    private final ImageData backgroundData;

    public OverlayImageDescriptor(Image srcImage, ImageDescriptor overlayDesc, int overlayPos) {
        assert (srcImage != null);
        assert (overlayDesc != null);
        this.backgroundData = srcImage.getImageData();
        this.overlayDesc = overlayDesc;
    }

    public OverlayImageDescriptor(ImageData backgroundData, ImageDescriptor overlayDesc, int overlayPos) {
        assert (backgroundData != null);
        assert (overlayDesc != null);
        this.backgroundData = backgroundData;
        this.overlayDesc = overlayDesc;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData overlayData;
        if (this.backgroundData != null) {
            this.drawImage(this.backgroundData, 0, 0);
        }
        if ((overlayData = this.overlayDesc.getImageData()) != null) {
            Point pos = null;
            switch (2) {
                case 0: {
                    pos = new Point(-overlayData.width / 2, -overlayData.height / 2);
                    break;
                }
                case 1: {
                    pos = new Point(this.backgroundData.width - overlayData.width / 2, 0);
                    break;
                }
                case 2: {
                    pos = new Point(this.backgroundData.width - overlayData.width / 2, this.backgroundData.height - overlayData.height / 2);
                    break;
                }
                default: {
                    pos = new Point(0, this.backgroundData.height - overlayData.height / 2);
                }
            }
            this.drawImage(overlayData, pos.x - 3, pos.y - 3);
        }
    }

    protected Point getSize() {
        return new Point(19, 19);
    }
}

