/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.datatemplate;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emfforms.bazaar.Bazaar;
import org.eclipse.emfforms.bazaar.BazaarContext;
import org.eclipse.emfforms.bazaar.Vendor;
import org.eclipse.emfforms.core.services.datatemplate.TemplateLoaderService;
import org.eclipse.emfforms.core.services.datatemplate.TemplateProvider;
import org.eclipse.emfforms.datatemplate.Template;
import org.eclipse.emfforms.datatemplate.TemplateCollection;
import org.eclipse.emfforms.spi.bazaar.BazaarUtil;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(name="XmiTemplateProvider")
public class XmiTemplateProvider
implements TemplateProvider {
    private static final String FILE_ATTRIBUTE = "file";
    private static final String EXTENSION_POINT = "org.eclipse.emfforms.core.services.datatemplate.xmi";
    private final Bazaar<TemplateLoaderService> templateLoaderBazaar = BazaarUtil.createBazaar((Object)TemplateLoaderService.DEFAULT);
    private final Map<EClass, LinkedHashSet<Template>> templates = new LinkedHashMap<EClass, LinkedHashSet<Template>>();
    private ReportService reportService;
    private IExtensionRegistry extensionRegistry;

    @Reference
    void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Reference
    void setExtensionRegistry(IExtensionRegistry extensionRegistry) {
        this.extensionRegistry = extensionRegistry;
    }

    @Activate
    void activate() {
        this.readExtensionPoint();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addLoaderServiceProvider(TemplateLoaderService.Provider provider) {
        this.templateLoaderBazaar.addVendor((Vendor)provider);
    }

    void removeLoaderServiceProvider(TemplateLoaderService.Provider provider) {
        this.templateLoaderBazaar.removeVendor((Vendor)provider);
    }

    void readExtensionPoint() {
        IConfigurationElement[] configurationElements;
        IConfigurationElement[] iConfigurationElementArray = configurationElements = this.extensionRegistry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                String contributor = configurationElement.getContributor().getName();
                String path = configurationElement.getAttribute(FILE_ATTRIBUTE).replaceFirst("^/*", "");
                URI resourceURI = URI.createPlatformPluginURI((String)String.format("%s/%s", contributor, path), (boolean)true);
                TemplateLoaderService loader = this.getLoader(resourceURI, contributor);
                Collection<? extends TemplateCollection> collections = loader.loadTemplates(resourceURI);
                collections.forEach(templateCollection -> this.registerTemplateCollection((TemplateCollection)templateCollection));
            }
            catch (IOException ex) {
                this.reportService.report(new AbstractReport((Throwable)ex, "An Exception occured while reading in a data template."));
            }
            ++n2;
        }
    }

    @Override
    public boolean canProvideTemplates(EObject owner, EReference reference) {
        EClass referenceType = reference.getEReferenceType();
        if (this.templates.containsKey(referenceType)) {
            return true;
        }
        for (EClass type : this.templates.keySet()) {
            if (!referenceType.isSuperTypeOf(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Template> provideTemplates(EObject owner, EReference reference) {
        LinkedHashSet<Template> matchingTemplates = new LinkedHashSet<Template>();
        EClass referenceType = reference.getEReferenceType();
        for (EClass type : this.templates.keySet()) {
            if (!referenceType.isSuperTypeOf(type)) continue;
            matchingTemplates.addAll((Collection<Template>)this.templates.get(type));
        }
        return matchingTemplates;
    }

    private TemplateLoaderService getLoader(URI uri, String contributorID) {
        BazaarContext context = BazaarContext.Builder.empty().put(URI.class, (Object)uri).put("contributorID", (Object)contributorID).build();
        return (TemplateLoaderService)this.templateLoaderBazaar.createProduct(context);
    }

    private void addToTemplateMap(EClass type, Template template) {
        if (!this.templates.containsKey(type)) {
            this.templates.put(type, new LinkedHashSet());
        }
        this.templates.get(type).add(template);
    }

    private void registerTemplateCollection(TemplateCollection collection) {
        for (Template template : collection.getTemplates()) {
            this.registerTemplate(template);
        }
    }

    void registerTemplate(Template template) {
        if (template.getInstance() == null) {
            this.reportService.report(new AbstractReport("Ignoring template '{0}', as it does not contain a valid EObject instance", new Object[]{template.getName()}));
            return;
        }
        EClass type = template.getInstance().eClass();
        this.addToTemplateMap(type, template);
    }
}

