/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.segments.mapping;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.mappingdmr.model.VMappingDomainModelReference;
import org.eclipse.emf.ecp.view.spi.mappingdmr.model.VMappingdmrPackage;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emf.ecp.view.spi.model.VFeatureDomainModelReferenceSegment;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.segments.DmrSegmentGenerator;
import org.eclipse.emfforms.spi.core.services.segments.EMFFormsSegmentGenerator;
import org.eclipse.emfforms.spi.view.mappingsegment.model.VMappingDomainModelReferenceSegment;
import org.eclipse.emfforms.spi.view.mappingsegment.model.VMappingsegmentFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(name="MappingDmrSegmentGenerator")
public class MappingDmrSegmentGenerator
implements DmrSegmentGenerator {
    private EMFFormsSegmentGenerator emfFormsSegmentGenerator;
    private ReportService reportService;

    @Reference(unbind="-")
    void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public double isApplicable(VDomainModelReference reference) {
        Assert.create((Object)reference).notNull();
        if (reference.eClass() == VMappingdmrPackage.Literals.MAPPING_DOMAIN_MODEL_REFERENCE) {
            return 5.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public List<VDomainModelReferenceSegment> generateSegments(VDomainModelReference reference) {
        Assert.create((Object)reference).notNull();
        if (reference.eClass() != VMappingdmrPackage.Literals.MAPPING_DOMAIN_MODEL_REFERENCE) {
            throw new IllegalArgumentException(String.format("The given DMR was no mapping domain model reference. The DMR was: %s", reference));
        }
        VMappingDomainModelReference mappingDmr = (VMappingDomainModelReference)reference;
        LinkedList<VDomainModelReferenceSegment> result = new LinkedList<VDomainModelReferenceSegment>();
        for (EReference eReference : mappingDmr.getDomainModelEReferencePath()) {
            VFeatureDomainModelReferenceSegment segment = VViewFactory.eINSTANCE.createFeatureDomainModelReferenceSegment();
            segment.setDomainModelFeature(eReference.getName());
            result.add((VDomainModelReferenceSegment)segment);
        }
        if (mappingDmr.getDomainModelEFeature() == null) {
            this.reportFailure("its domain model e feature is null", (VDomainModelReference)mappingDmr);
            return Collections.emptyList();
        }
        VMappingDomainModelReferenceSegment mappingSegment = VMappingsegmentFactory.eINSTANCE.createMappingDomainModelReferenceSegment();
        mappingSegment.setDomainModelFeature(mappingDmr.getDomainModelEFeature().getName());
        mappingSegment.setMappedClass(mappingDmr.getMappedClass());
        result.add((VDomainModelReferenceSegment)mappingSegment);
        List targetSegments = this.getEMFFormsSegmentGenerator().generateSegments(mappingDmr.getDomainModelReference());
        if (targetSegments.isEmpty()) {
            this.reportFailure("no target segments could be generated", (VDomainModelReference)mappingDmr);
            return Collections.emptyList();
        }
        result.addAll(targetSegments);
        return result;
    }

    private void reportFailure(String reason, VDomainModelReference mappingDmr) {
        StringBuilder sb = new StringBuilder();
        sb.append("Could not generate segments for the mapping dmr because ");
        sb.append(reason);
        sb.append(". The mapping DMR was: %s");
        this.reportService.report(new AbstractReport(String.format(sb.toString(), mappingDmr), 2));
    }

    private EMFFormsSegmentGenerator getEMFFormsSegmentGenerator() {
        if (this.emfFormsSegmentGenerator == null) {
            BundleContext bundleContext = FrameworkUtil.getBundle(MappingDmrSegmentGenerator.class).getBundleContext();
            ServiceReference serviceReference = bundleContext.getServiceReference(EMFFormsSegmentGenerator.class);
            this.emfFormsSegmentGenerator = (EMFFormsSegmentGenerator)bundleContext.getService(serviceReference);
        }
        return this.emfFormsSegmentGenerator;
    }

    void setEMFFormsSegmentGenerator(EMFFormsSegmentGenerator generator) {
        this.emfFormsSegmentGenerator = generator;
    }
}

