/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.util;

import java.text.MessageFormat;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.InvalidDatatypeValueException;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emfforms.spi.common.validation.PreSetValidationService;
import org.eclipse.emfforms.spi.common.validation.PreSetValidationServiceRunnable;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public final class PreSetValidationListeners {
    private static PreSetValidationListeners validationListeners = new PreSetValidationListeners();
    private static PreSetValidationService preSetValidationService;

    private PreSetValidationListeners() {
        this.init();
    }

    public static PreSetValidationListeners create() {
        return validationListeners;
    }

    private void init() {
        if (preSetValidationService == null) {
            BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            ServiceReference serviceReference = bundleContext.getServiceReference(PreSetValidationService.class);
            preSetValidationService = serviceReference != null ? (PreSetValidationService)bundleContext.getService(serviceReference) : null;
        }
    }

    public void verify(Text text, EStructuralFeature feature) {
        this.verify(text, feature, null);
    }

    public void verify(Combo combo, EStructuralFeature feature) {
        this.verify(combo, feature, null);
    }

    public void verify(Text text, EStructuralFeature feature, VElement vElement) {
        if (!EAttribute.class.isInstance(feature)) {
            return;
        }
        EAttribute attribute = (EAttribute)feature;
        if (preSetValidationService != null) {
            PreSetVerifyListener verifyListener = new PreSetVerifyListener(vElement, attribute);
            text.addVerifyListener((VerifyListener)verifyListener);
        }
    }

    public void verify(Combo combo, EStructuralFeature feature, VElement vElement) {
        if (!EAttribute.class.isInstance(feature)) {
            return;
        }
        EAttribute attribute = (EAttribute)feature;
        if (preSetValidationService != null) {
            PreSetVerifyListener verifyListener = new PreSetVerifyListener(vElement, attribute);
            combo.addVerifyListener((VerifyListener)verifyListener);
        }
    }

    protected VDiagnostic validateStrict(EStructuralFeature feature, Object value) {
        Diagnostic strictDiag = preSetValidationService.validate(feature, value);
        VDiagnostic vDiagnostic = VViewFactory.eINSTANCE.createDiagnostic();
        if (strictDiag.getSeverity() != 0) {
            vDiagnostic.getDiagnostics().add((Object)strictDiag);
            return vDiagnostic;
        }
        if (feature.isRequired() && (value == null || this.isString(feature.getEType()) && "".equals(value))) {
            BasicDiagnostic multiplicityDiagnostic = new BasicDiagnostic(4, "", 1, MessageFormat.format("The required feature ''{0}'' must be set", feature.getName()), new Object[0]);
            vDiagnostic.getDiagnostics().add((Object)multiplicityDiagnostic);
            return vDiagnostic;
        }
        return null;
    }

    private boolean isString(EClassifier classifier) {
        return classifier.getInstanceTypeName().equals(String.class.getCanonicalName());
    }

    public void focus(Text text, EStructuralFeature feature, final PreSetValidationServiceRunnable focusLost, final Runnable focusGained) {
        if (preSetValidationService != null) {
            text.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    focusLost.run(preSetValidationService);
                }

                public void focusGained(FocusEvent e) {
                    focusGained.run();
                }
            });
        }
    }

    public static class PreSetVerifyListener
    implements VerifyListener {
        private final EAttribute attribute;
        private final VElement vElement;

        public PreSetVerifyListener(VElement vElement, EAttribute attribute) {
            this.vElement = vElement;
            this.attribute = attribute;
        }

        public void verifyText(VerifyEvent e) {
            Diagnostic looseDiag;
            VDiagnostic prevDiagnostic;
            Object changedValue;
            String changedText = this.obtainText(e);
            try {
                changedValue = EcoreUtil.createFromString((EDataType)this.attribute.getEAttributeType(), (String)changedText);
            }
            catch (IllegalArgumentException | InvalidDatatypeValueException formatException) {
                if (this.isInteger(this.attribute.getEType()) && changedText.isEmpty() || XMLGregorianCalendar.class.isAssignableFrom(this.attribute.getEType().getInstanceClass()) || Double.TYPE.isAssignableFrom(this.attribute.getEType().getInstanceClass()) || Double.class.isAssignableFrom(this.attribute.getEType().getInstanceClass())) {
                    return;
                }
                e.doit = false;
                return;
            }
            VDiagnostic vDiagnostic = prevDiagnostic = this.vElement == null ? null : this.vElement.getDiagnostic();
            if (this.vElement != null) {
                this.vElement.setDiagnostic(validationListeners.validateStrict((EStructuralFeature)this.attribute, changedValue));
            }
            if ((looseDiag = preSetValidationService.validateLoose((EStructuralFeature)this.attribute, changedValue)).getSeverity() == 0) {
                return;
            }
            if (validationListeners.isString(this.attribute.getEType())) {
                e.doit = false;
                if (this.vElement != null) {
                    this.vElement.setDiagnostic(prevDiagnostic);
                }
            }
        }

        protected String obtainText(VerifyEvent event) {
            String currentText = "";
            if (event.widget instanceof Text) {
                currentText = ((Text)Text.class.cast(event.widget)).getText();
            } else if (event.widget instanceof Combo) {
                currentText = ((Combo)Combo.class.cast(event.widget)).getText();
            }
            String changedText = String.valueOf(currentText.substring(0, event.start)) + event.text + currentText.substring(event.end);
            return changedText;
        }

        private boolean isInteger(EClassifier classifier) {
            return classifier.getInstanceTypeName().equals(Integer.class.getCanonicalName());
        }
    }
}

