/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.treemasterdetail;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.internal.swt.treemasterdetail.BaseLabelProviderWrapper;
import org.eclipse.emfforms.internal.swt.treemasterdetail.DefaultTreeViewerCustomization;
import org.eclipse.emfforms.spi.swt.treemasterdetail.ContentProviderProvider;
import org.eclipse.emfforms.spi.swt.treemasterdetail.DNDProvider;
import org.eclipse.emfforms.spi.swt.treemasterdetail.DeleteActionBuilder;
import org.eclipse.emfforms.spi.swt.treemasterdetail.InitialSelectionProvider;
import org.eclipse.emfforms.spi.swt.treemasterdetail.LabelDecoratorProvider;
import org.eclipse.emfforms.spi.swt.treemasterdetail.LabelProviderProvider;
import org.eclipse.emfforms.spi.swt.treemasterdetail.MenuProvider;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeViewerBuilder;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeViewerCustomization;
import org.eclipse.emfforms.spi.swt.treemasterdetail.ViewerFilterProvider;
import org.eclipse.emfforms.spi.swt.treemasterdetail.actions.MasterDetailAction;
import org.eclipse.emfforms.spi.swt.treemasterdetail.util.CreateElementCallback;
import org.eclipse.emfforms.spi.swt.treemasterdetail.util.RootObject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;

public class TreeViewerSWTBuilder {
    private final EditingDomain editingDomain;
    private final Composite composite;
    private final Object input;
    private final DefaultTreeViewerCustomization behaviour;

    TreeViewerSWTBuilder(Composite composite, Object input) {
        this.composite = composite;
        this.input = input;
        this.editingDomain = TreeViewerSWTBuilder.getEditingDomain(input);
        this.behaviour = new DefaultTreeViewerCustomization();
    }

    public TreeViewerSWTBuilder customizeContentProvider(ContentProviderProvider contentProvider) {
        this.behaviour.setContentProvider(contentProvider);
        return this;
    }

    public TreeViewerSWTBuilder customizeContentProvider(final IContentProvider contentProvider) {
        this.behaviour.setContentProvider(new ContentProviderProvider(){

            @Override
            public void dispose() {
                contentProvider.dispose();
            }

            @Override
            public IContentProvider getContentProvider() {
                return contentProvider;
            }
        });
        return this;
    }

    public TreeViewerSWTBuilder customizeDragAndDrop(DNDProvider dnd) {
        this.behaviour.setDragAndDrop(dnd);
        return this;
    }

    public TreeViewerSWTBuilder customizeLabelProvider(LabelProviderProvider provider) {
        this.behaviour.setLabelProvider(provider);
        return this;
    }

    public TreeViewerSWTBuilder customizeLabelProvider(final IBaseLabelProvider provider) {
        this.behaviour.setLabelProvider(new LabelProviderProvider(){

            @Override
            public void dispose() {
                provider.dispose();
            }

            @Override
            public IBaseLabelProvider getLabelProvider() {
                return provider;
            }
        });
        return this;
    }

    public TreeViewerSWTBuilder customizeLabelDecorator(LabelDecoratorProvider provider) {
        this.behaviour.setLabelDecorator(provider);
        return this;
    }

    public TreeViewerSWTBuilder customizeLabelDecorator(final ILabelDecorator decorator) {
        this.behaviour.setLabelDecorator(new LabelDecoratorProvider(){

            @Override
            public Optional<ILabelDecorator> getLabelDecorator(TreeViewer viewer) {
                return Optional.of((Object)decorator);
            }

            @Override
            public void dispose() {
            }
        });
        return this;
    }

    public TreeViewerSWTBuilder customizeMenu(MenuProvider menu) {
        this.behaviour.setMenu(menu);
        return this;
    }

    public TreeViewerSWTBuilder customizeMenuItems(Collection<MasterDetailAction> rightClickActions) {
        this.behaviour.customizeMenu(rightClickActions);
        return this;
    }

    public TreeViewerSWTBuilder customizeCildCreation(CreateElementCallback createElementCallback) {
        this.behaviour.customizeMenu(createElementCallback);
        return this;
    }

    public TreeViewerSWTBuilder customizeDelete(DeleteActionBuilder deleteActionBuilder) {
        this.behaviour.customizeMenu(deleteActionBuilder);
        return this;
    }

    public TreeViewerSWTBuilder customizeInitialSelection(InitialSelectionProvider selection) {
        this.behaviour.setInitialSelection(selection);
        return this;
    }

    public TreeViewerSWTBuilder customizeTree(TreeViewerBuilder tree) {
        this.behaviour.setTree(tree);
        return this;
    }

    public TreeViewerSWTBuilder customizeViewerFilters(final ViewerFilter[] filters) {
        this.behaviour.setViewerFilters(new ViewerFilterProvider(){

            @Override
            public ViewerFilter[] getViewerFilters() {
                return filters;
            }
        });
        return this;
    }

    public TreeViewer create() {
        return TreeViewerSWTBuilder.create(this.behaviour, this.composite, this.editingDomain, this.input);
    }

    static EditingDomain getEditingDomain(Object input) {
        if (input instanceof Resource) {
            return AdapterFactoryEditingDomain.getEditingDomainFor((EObject)((EObject)((Resource)input).getContents().get(0)));
        }
        if (input instanceof RootObject) {
            return AdapterFactoryEditingDomain.getEditingDomainFor((EObject)((RootObject)RootObject.class.cast(input)).getRoot());
        }
        return AdapterFactoryEditingDomain.getEditingDomainFor((Object)input);
    }

    static TreeViewer create(TreeViewerCustomization behaviour, Composite composite, EditingDomain editingDomain, Object input) {
        TreeViewer treeViewer = behaviour.createTree(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(treeViewer.getControl());
        if (behaviour.hasDND()) {
            treeViewer.addDragSupport(behaviour.getDragOperations(), behaviour.getDragTransferTypes(), behaviour.getDragListener(treeViewer));
            treeViewer.addDropSupport(behaviour.getDropOperations(), behaviour.getDropTransferTypes(), behaviour.getDropListener(editingDomain, treeViewer));
        }
        treeViewer.setContentProvider(behaviour.getContentProvider());
        IBaseLabelProvider labelProvider = behaviour.getLabelProvider();
        Optional<ILabelDecorator> labelDecorator = behaviour.getLabelDecorator(treeViewer);
        if (labelDecorator.isPresent()) {
            Object labelProviderForDecorator = ILabelProvider.class.isInstance(labelProvider) ? (ILabelProvider)ILabelProvider.class.cast(labelProvider) : new BaseLabelProviderWrapper(labelProvider);
            labelProvider = new DecoratingLabelProvider(labelProviderForDecorator, (ILabelDecorator)labelDecorator.get());
        }
        treeViewer.setLabelProvider(labelProvider);
        treeViewer.setFilters(behaviour.getViewerFilters());
        treeViewer.getControl().setMenu(behaviour.getMenu(treeViewer, editingDomain));
        treeViewer.setInput(input);
        EObject initialSelection = behaviour.getInitialSelection(input);
        if (initialSelection != null) {
            treeViewer.setSelection((ISelection)new StructuredSelection((Object)initialSelection), true);
        }
        return treeViewer;
    }
}

