/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ide.internal.migration;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecp.ide.internal.migration.ViewMigrationException;
import org.eclipse.emf.ecp.ide.spi.util.EcoreHelper;
import org.eclipse.emf.ecp.ide.spi.util.ViewModelHelper;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.util.ViewModelPropertiesHelper;
import org.eclipse.emfforms.common.Optional;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ViewMigrationHandler {
    private static ExecutorService executorService = Executors.newFixedThreadPool(1);
    private final String oldNamespaceFragment;
    private final String newNamespaceFragment;

    public ViewMigrationHandler(String oldNamespaceFragment, String newNamespaceFragment) {
        this.oldNamespaceFragment = oldNamespaceFragment;
        this.newNamespaceFragment = newNamespaceFragment;
    }

    public Map<String, Optional<Diagnostic>> execute(Set<IFile> files, SubMonitor monitor) throws ViewMigrationException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)files.size());
        LinkedHashMap<String, Optional<Diagnostic>> diagnostics = new LinkedHashMap<String, Optional<Diagnostic>>();
        for (IFile file : files) {
            Optional<Diagnostic> diagnostic = this.execute(file);
            diagnostics.put(file.getName(), diagnostic);
            subMonitor.worked(1);
        }
        return diagnostics;
    }

    public Optional<Diagnostic> execute(final IFile file) throws ViewMigrationException {
        try {
            file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(file.getContents());
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile("//*[@href]");
            NodeList elements = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            int i = 0;
            while (i < elements.getLength()) {
                Node item = elements.item(i);
                Node href = item.getAttributes().getNamedItem("href");
                href.setNodeValue(href.getNodeValue().replace(this.oldNamespaceFragment, this.newNamespaceFragment));
                ++i;
            }
            DOMSource source = new DOMSource(doc);
            final PipedInputStream pis = new PipedInputStream();
            PipedOutputStream pos = new PipedOutputStream();
            pos.connect(pis);
            StreamResult result = new StreamResult(pos);
            Future<Void> future = executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        file.setContents((InputStream)pis, true, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    finally {
                        pis.close();
                    }
                    return null;
                }
            });
            try {
                transformer.transform(source, result);
            }
            finally {
                pos.close();
            }
            future.get();
            return this.checkView(file);
        }
        catch (SAXException ex) {
            throw new ViewMigrationException(ex);
        }
        catch (TransformerConfigurationException ex) {
            throw new ViewMigrationException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new ViewMigrationException(ex);
        }
        catch (IOException ex) {
            throw new ViewMigrationException(ex);
        }
        catch (XPathExpressionException ex) {
            throw new ViewMigrationException(ex);
        }
        catch (TransformerException ex) {
            throw new ViewMigrationException(ex);
        }
        catch (CoreException ex) {
            throw new ViewMigrationException((Exception)((Object)ex));
        }
        catch (InterruptedException ex) {
            throw new ViewMigrationException(ex);
        }
        catch (ExecutionException ex) {
            throw new ViewMigrationException(ex);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<Diagnostic> checkView(IFile file) throws IOException {
        ecores = new LinkedHashSet<E>();
        view = ViewModelHelper.loadView((IFile)file, ecores);
        try {
            if (view != null) {
                properties = ViewModelPropertiesHelper.getInhertitedPropertiesOrEmpty((VElement)view);
                view.setLoadingProperties(properties);
                var6_5 = Optional.of((Object)Diagnostician.INSTANCE.validate((EObject)view));
                return var6_5;
            }
            var6_6 = Optional.empty();
            return var6_6;
        }
        finally {
            ** for (registeredEcore : ecores)
        }
lbl-1000:
        // 1 sources

        {
            EcoreHelper.unregisterEcore((String)registeredEcore);
            continue;
        }
lbl15:
        // 1 sources

        return var6_5;
    }
}

