/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.nebula.grid;

import java.util.List;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecp.view.spi.table.nebula.grid.GridViewerColumnBuilder;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.spi.swt.table.AbstractTableViewerComposite;
import org.eclipse.emfforms.spi.swt.table.TableControl;
import org.eclipse.emfforms.spi.swt.table.TableViewerComparator;
import org.eclipse.emfforms.spi.swt.table.TableViewerSWTCustomization;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.AbstractColumnLayout;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.nebula.jface.gridviewer.GridColumnLayout;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.jface.gridviewer.GridViewerColumn;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class GridTableViewerComposite
extends AbstractTableViewerComposite {
    private GridTableViewer gridTableViewer;

    public GridTableViewerComposite(Composite parent, int style, Object inputObject, TableViewerSWTCustomization customization, IObservableValue title, IObservableValue tooltip) {
        super(parent, style, inputObject, customization, title, tooltip);
    }

    public GridTableViewer getTableViewer() {
        return this.gridTableViewer;
    }

    protected AbstractTableViewer createTableViewer(TableViewerSWTCustomization customization, Composite viewerComposite) {
        this.gridTableViewer = (GridTableViewer)customization.createTableViewer(viewerComposite);
        return this.gridTableViewer;
    }

    protected AbstractColumnLayout createLayout(Composite viewerComposite) {
        GridColumnLayout layout = new GridColumnLayout();
        viewerComposite.setLayout((Layout)layout);
        return layout;
    }

    public Widget[] getColumns() {
        return this.gridTableViewer.getGrid().getColumns();
    }

    public void addColumnListener(ControlListener columnlistener) {
        int i = 0;
        while (i < this.gridTableViewer.getGrid().getColumns().length) {
            GridColumn gridColumn = this.gridTableViewer.getGrid().getColumns()[i];
            gridColumn.addControlListener(columnlistener);
            ++i;
        }
    }

    public TableControl getTableControl() {
        return new TableControl(){

            public boolean isDisposed() {
                return GridTableViewerComposite.this.getTableViewer().getGrid().isDisposed();
            }

            public int getItemHeight() {
                return GridTableViewerComposite.this.getTableViewer().getGrid().getItemHeight();
            }

            public boolean getHeaderVisible() {
                return GridTableViewerComposite.this.getTableViewer().getGrid().getHeaderVisible();
            }

            public int getHeaderHeight() {
                return GridTableViewerComposite.this.getTableViewer().getGrid().getHeaderHeight();
            }

            public int getItemCount() {
                return GridTableViewerComposite.this.getTableViewer().getGrid().getItemCount();
            }
        };
    }

    protected ViewerColumn createColumn(TableViewerSWTCustomization.ColumnDescription columnDescription, EMFDataBindingContext emfDataBindingContext, AbstractTableViewer tableViewer) {
        GridViewerColumnBuilder builder = GridViewerColumnBuilder.create();
        GridViewerColumn column = builder.setData(columnDescription.getData()).setData("resizable", columnDescription.isResizeable()).setMoveable(columnDescription.isMoveable()).setStyle(columnDescription.getStyleBits()).setData("weight", columnDescription.getWeight()).setData("min_width", columnDescription.getMinWidth()).build(this.getTableViewer());
        IObservableValue text = columnDescription.getColumnText();
        emfDataBindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)column.getColumn()), text);
        column.setLabelProvider(columnDescription.createLabelProvider(tableViewer));
        Optional editingSupport = columnDescription.createEditingSupport(tableViewer);
        if (editingSupport.isPresent()) {
            column.setEditingSupport((EditingSupport)editingSupport.get());
        }
        if (columnDescription.getColumnImage().isPresent()) {
            column.getColumn().setImage((Image)columnDescription.getColumnImage().get());
        }
        return column;
    }

    public void setComparator(final TableViewerComparator comparator, List<Integer> sortableColumns) {
        int i = 0;
        while (i < this.getTableViewer().getGrid().getColumns().length) {
            if (sortableColumns.contains(i)) {
                final int j = i;
                final GridColumn tableColumn = this.getTableViewer().getGrid().getColumns()[i];
                SelectionAdapter selectionAdapter = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        comparator.setColumn(j);
                        tableColumn.setSort(comparator.getDirection());
                        GridTableViewerComposite.this.gridTableViewer.refresh();
                    }
                };
                tableColumn.addSelectionListener((SelectionListener)selectionAdapter);
            }
            ++i;
        }
    }
}

