/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.control.multireference;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.controls.TableViewerColumnBuilder;
import org.eclipse.emf.ecp.edit.spi.DeleteService;
import org.eclipse.emf.ecp.edit.spi.EMFDeleteServiceImpl;
import org.eclipse.emf.ecp.edit.spi.ReferenceService;
import org.eclipse.emf.ecp.view.model.common.edit.provider.CustomReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.ecp.view.model.common.util.RendererUtil;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.AbstractControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.provider.ECPTooltipModifierHelper;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.ecp.view.spi.util.swt.ImageRegistryService;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.ecp.view.template.style.reference.model.VTReferenceFactory;
import org.eclipse.emf.ecp.view.template.style.reference.model.VTReferenceStyleProperty;
import org.eclipse.emf.ecp.view.template.style.tableStyleProperty.model.RenderMode;
import org.eclipse.emf.ecp.view.template.style.tableStyleProperty.model.VTTableStyleProperty;
import org.eclipse.emf.ecp.view.template.style.tableStyleProperty.model.VTTableStylePropertyFactory;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emfforms.spi.common.BundleResolver;
import org.eclipse.emfforms.spi.common.BundleResolverFactory;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.common.sort.NumberAwareStringComparator;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.core.services.label.NoLabelFoundException;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.SWTDataElementIdHelper;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.emfforms.spi.swt.core.ui.ObjectViewerComparator;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class MultiReferenceSWTRenderer
extends AbstractControlSWTRenderer<VControl> {
    private static final String ICON_ADD_EXISTING = "icons/link.png";
    private static final String ICON_ADD_NEW = "icons/link_add.png";
    private static final String ICON_DELETE = "icons/unset_reference.png";
    private static final String ICON_MOVE_DOWN = "icons/move_down.png";
    private static final String ICON_MOVE_UP = "icons/move_up.png";
    private final BundleResolver bundleResolver = BundleResolverFactory.createBundleResolver();
    private final ImageRegistryService imageRegistryService;
    private EMFFormsLocalizationService l10n;
    private Optional<EObject> cachedContainer;
    private String referenceDisplayName;
    private Label validationIcon;
    private ILabelProvider labelProvider;
    private AdapterFactory adapterFactory;
    private TableViewer tableViewer;
    private final EMFDataBindingContext viewModelDBC;
    private IObservableList<?> tableViewerInputList;
    private Button btnAddExisting;
    private Button btnAddNew;
    private Button btnDelete;
    private Button btnMoveUp;
    private Button btnMoveDown;
    private SWTGridDescription rendererGridDescription;

    public MultiReferenceSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, ImageRegistryService imageRegistryService) {
        this(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, imageRegistryService, null);
    }

    @Inject
    public MultiReferenceSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, ImageRegistryService imageRegistryService, EMFFormsLocalizationService localizationService) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
        this.imageRegistryService = imageRegistryService;
        this.l10n = localizationService;
        this.viewModelDBC = new EMFDataBindingContext();
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            this.rendererGridDescription = this.getTableStyleProperty().getRenderMode() == RenderMode.COMPACT_VERTICALLY ? GridDescriptionFactory.INSTANCE.createCompactGrid(false, true, (AbstractSWTRenderer)this) : GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
        }
        return this.rendererGridDescription;
    }

    protected final IObservableList<?> updateTableViewerInputList() throws DatabindingFailedException {
        if (this.tableViewerInputList != null) {
            this.tableViewerInputList.dispose();
        }
        this.tableViewerInputList = this.getReferencedElementsList();
        this.tableViewer.setInput(this.tableViewerInputList);
        return this.tableViewerInputList;
    }

    protected boolean showAddExistingButton() {
        EReference eReference = null;
        try {
            eReference = (EReference)this.getEStructuralFeature();
        }
        catch (DatabindingFailedException ex) {
            this.getReportService().report(new AbstractReport((Throwable)ex));
        }
        if (eReference != null) {
            if (!eReference.isContainment()) {
                return true;
            }
            VTReferenceStyleProperty referenceStyle = (VTReferenceStyleProperty)RendererUtil.getStyleProperty((VTViewTemplateProvider)this.getVTViewTemplateProvider(), (VElement)this.getVElement(), (ViewModelContext)this.getViewModelContext(), VTReferenceStyleProperty.class);
            if (referenceStyle == null) {
                referenceStyle = this.getDefaultReferenceStyle();
            }
            return referenceStyle.isShowLinkButtonForContainmentReferences();
        }
        return false;
    }

    protected boolean showAddNewButton() {
        EReference eReference = null;
        try {
            eReference = (EReference)this.getModelValue().getValueType();
        }
        catch (DatabindingFailedException ex) {
            this.getReportService().report(new AbstractReport((Throwable)ex));
        }
        if (eReference != null) {
            if (eReference.isContainment()) {
                return true;
            }
            VTReferenceStyleProperty referenceStyle = (VTReferenceStyleProperty)RendererUtil.getStyleProperty((VTViewTemplateProvider)this.getVTViewTemplateProvider(), (VElement)this.getVElement(), (ViewModelContext)this.getViewModelContext(), VTReferenceStyleProperty.class);
            if (referenceStyle == null) {
                referenceStyle = this.getDefaultReferenceStyle();
            }
            return referenceStyle.isShowCreateAndLinkButtonForCrossReferences();
        }
        return false;
    }

    protected VTReferenceStyleProperty getDefaultReferenceStyle() {
        return VTReferenceFactory.eINSTANCE.createReferenceStyleProperty();
    }

    protected boolean showDeleteButton() {
        return true;
    }

    protected boolean showMoveUpButton() {
        return false;
    }

    protected boolean showMoveDownButton() {
        return false;
    }

    protected EStructuralFeature getEStructuralFeature() throws DatabindingFailedException {
        return (EStructuralFeature)this.getModelValue().getValueType();
    }

    protected Optional<EObject> getContainer() {
        if (this.cachedContainer == null || !this.cachedContainer.isPresent()) {
            EObject eObject = null;
            try {
                eObject = (EObject)((IObserving)IObserving.class.cast(this.getModelValue())).getObserved();
            }
            catch (DatabindingFailedException ex) {
                this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            }
            this.cachedContainer = Optional.ofNullable(eObject);
        }
        return this.cachedContainer;
    }

    protected VTTableStyleProperty createDefaultTableStyleProperty() {
        return VTTableStylePropertyFactory.eINSTANCE.createTableStyleProperty();
    }

    protected VTTableStyleProperty getTableStyleProperty() {
        VTTableStyleProperty styleProperty = (VTTableStyleProperty)RendererUtil.getStyleProperty((VTViewTemplateProvider)this.getVTViewTemplateProvider(), (VElement)this.getVElement(), (ViewModelContext)this.getViewModelContext(), VTTableStyleProperty.class);
        if (styleProperty == null) {
            styleProperty = this.createDefaultTableStyleProperty();
        }
        return styleProperty;
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        if (this.rendererGridDescription.getColumns() == 1) {
            return this.renderMultiReferenceControl(cell, parent);
        }
        if (cell.getColumn() == 0 && this.rendererGridDescription.getColumns() > 1) {
            this.validationIcon = this.createValidationIcon(parent);
            return this.validationIcon;
        }
        Composite composite = new Composite(parent, 0);
        composite.setBackgroundMode(2);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Control multiRefComposite = this.renderMultiReferenceControl(cell, composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(multiRefComposite);
        try {
            Composite buttonComposite = this.createButtonComposite(composite);
            GridDataFactory.fillDefaults().align(0x1000008, 1).applyTo((Control)buttonComposite);
        }
        catch (DatabindingFailedException ex) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
            return this.createErrorLabel(composite, (Exception)((Object)ex));
        }
        this.updateButtons();
        return composite;
    }

    protected Control renderMultiReferenceControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        if (cell.getRow() != 0 || cell.getRenderer() != this) {
            throw new IllegalArgumentException("Wrong parameter passed!");
        }
        Composite composite = new Composite(parent, 0);
        composite.setBackgroundMode(2);
        if (this.getTableStyleProperty().getRenderMode() == RenderMode.COMPACT_VERTICALLY) {
            GridLayoutFactory.fillDefaults().applyTo(composite);
        } else {
            composite.setLayout((Layout)new GridLayout(1, false));
            try {
                this.createTitleComposite(composite);
            }
            catch (DatabindingFailedException ex) {
                this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
                return this.createErrorLabel(parent, (Exception)((Object)ex));
            }
        }
        this.adapterFactory = this.createAdapterFactory();
        this.labelProvider = this.createLabelProvider();
        Composite controlComposite = this.createControlComposite(composite);
        try {
            this.createContent(controlComposite);
        }
        catch (DatabindingFailedException ex) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
            return this.createErrorLabel(parent, (Exception)((Object)ex));
        }
        if (this.getTableStyleProperty().getRenderMode() == RenderMode.DEFAULT) {
            this.initButtons();
            this.updateButtons();
        }
        SWTDataElementIdHelper.setElementIdDataForVControl((Widget)composite, (VControl)((VControl)this.getVElement()), (ViewModelContext)this.getViewModelContext());
        return composite;
    }

    private void initButtons() {
        this.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MultiReferenceSWTRenderer.this.updateButtonEnabling();
            }
        });
    }

    protected Composite createControlComposite(Composite composite) {
        Composite controlComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(1, this.getTableHeightHint()).applyTo((Control)controlComposite);
        GridLayoutFactory.fillDefaults().applyTo(controlComposite);
        return controlComposite;
    }

    protected int getTableHeightHint() {
        return 300;
    }

    protected TableViewer getTableViewer() {
        return this.tableViewer;
    }

    protected Control createErrorLabel(Composite parent, Exception ex) {
        Label errorLabel = new Label(parent, 0);
        errorLabel.setText(ex.getMessage());
        return errorLabel;
    }

    protected AdapterFactory createAdapterFactory() {
        return new ComposedAdapterFactory(new AdapterFactory[]{new CustomReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
    }

    protected final AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    protected ILabelProvider createLabelProvider() {
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider(this.adapterFactory);
        labelProvider.setFireLabelUpdateNotifications(true);
        return labelProvider;
    }

    protected void dispose() {
        if (IDisposable.class.isInstance(this.adapterFactory)) {
            ((IDisposable)IDisposable.class.cast(this.adapterFactory)).dispose();
        }
        this.labelProvider.dispose();
        this.viewModelDBC.dispose();
        super.dispose();
    }

    protected Button createMoveUpButton(Composite parent, final EStructuralFeature structuralFeature) {
        Button btnMoveUp = new Button(parent, 8);
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)btnMoveUp, (VElement)this.getVElement(), (String)"up", (ViewModelContext)this.getViewModelContext());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)btnMoveUp);
        btnMoveUp.setImage(this.getImage(ICON_MOVE_UP));
        btnMoveUp.setToolTipText(LocalizationServiceHelper.getString(MultiReferenceSWTRenderer.class, (String)"MultiReferenceSWTRenderer_moveUpTooltip"));
        btnMoveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Optional<EObject> container = MultiReferenceSWTRenderer.this.getContainer();
                if (container.isPresent()) {
                    MultiReferenceSWTRenderer.this.handleMoveUp(MultiReferenceSWTRenderer.this.tableViewer, container.get(), structuralFeature);
                    MultiReferenceSWTRenderer.this.updateButtons();
                }
            }
        });
        return btnMoveUp;
    }

    protected Button createMoveDownButton(Composite parent, final EStructuralFeature structuralFeature) {
        Button btnMoveDown = new Button(parent, 8);
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)btnMoveDown, (VElement)this.getVElement(), (String)"down", (ViewModelContext)this.getViewModelContext());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)btnMoveDown);
        btnMoveDown.setImage(this.getImage(ICON_MOVE_DOWN));
        btnMoveDown.setToolTipText(LocalizationServiceHelper.getString(MultiReferenceSWTRenderer.class, (String)"MultiReferenceSWTRenderer_moveDownTooltip"));
        btnMoveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Optional<EObject> container = MultiReferenceSWTRenderer.this.getContainer();
                if (container.isPresent()) {
                    MultiReferenceSWTRenderer.this.handleMoveDown(MultiReferenceSWTRenderer.this.tableViewer, container.get(), structuralFeature);
                    MultiReferenceSWTRenderer.this.updateButtons();
                }
            }
        });
        return btnMoveDown;
    }

    protected Button createAddExistingButton(Composite parent, final EStructuralFeature structuralFeature) {
        Button btnAddExisting = new Button(parent, 8);
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)btnAddExisting, (VElement)this.getVElement(), (String)"link", (ViewModelContext)this.getViewModelContext());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)btnAddExisting);
        btnAddExisting.setImage(this.getImage(ICON_ADD_EXISTING));
        btnAddExisting.setToolTipText(NLS.bind((String)LocalizationServiceHelper.getString(MultiReferenceSWTRenderer.class, (String)"MultiReferenceSWTRenderer_addExistingTooltip"), (Object)this.getReferenceDisplayName()));
        btnAddExisting.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Optional<EObject> container = MultiReferenceSWTRenderer.this.getContainer();
                if (container.isPresent()) {
                    MultiReferenceSWTRenderer.this.handleAddExisting(MultiReferenceSWTRenderer.this.tableViewer, container.get(), structuralFeature);
                    MultiReferenceSWTRenderer.this.updateButtons();
                }
            }
        });
        return btnAddExisting;
    }

    protected Button createAddNewButton(Composite parent, final EStructuralFeature structuralFeature) {
        Button btnAddNew = new Button(parent, 8);
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)btnAddNew, (VElement)this.getVElement(), (String)"add", (ViewModelContext)this.getViewModelContext());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)btnAddNew);
        btnAddNew.setImage(this.getImage(ICON_ADD_NEW));
        btnAddNew.setToolTipText(NLS.bind((String)LocalizationServiceHelper.getString(MultiReferenceSWTRenderer.class, (String)"MultiReferenceSWTRenderer_addNewTooltip"), (Object)this.getReferenceDisplayName()));
        btnAddNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Optional<EObject> container = MultiReferenceSWTRenderer.this.getContainer();
                if (container.isPresent()) {
                    MultiReferenceSWTRenderer.this.handleAddNew(MultiReferenceSWTRenderer.this.tableViewer, container.get(), structuralFeature);
                    MultiReferenceSWTRenderer.this.updateButtons();
                }
            }
        });
        return btnAddNew;
    }

    protected Button createDeleteButton(Composite parent, final EStructuralFeature structuralFeature) {
        Button btnDelete = new Button(parent, 8);
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)btnDelete, (VElement)this.getVElement(), (String)"delete", (ViewModelContext)this.getViewModelContext());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)btnDelete);
        btnDelete.setImage(this.getImage(ICON_DELETE));
        btnDelete.setToolTipText(LocalizationServiceHelper.getString(MultiReferenceSWTRenderer.class, (String)"MultiReferenceSWTRenderer_deleteTooltip"));
        btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Optional<EObject> container = MultiReferenceSWTRenderer.this.getContainer();
                if (container.isPresent()) {
                    MultiReferenceSWTRenderer.this.handleDelete(MultiReferenceSWTRenderer.this.tableViewer, container.get(), structuralFeature);
                    MultiReferenceSWTRenderer.this.updateButtons();
                }
            }
        });
        return btnDelete;
    }

    protected void updateButtons() {
        this.updateButtonVisibility();
        this.updateButtonEnabling();
    }

    protected void updateButtonEnabling() {
        boolean isEnable = this.getContainer().isPresent() && ((VControl)this.getVElement()).isEffectivelyEnabled();
        int listSize = this.tableViewerInputList != null ? this.tableViewerInputList.size() : 0;
        int selectionIndex = this.tableViewer != null ? this.tableViewer.getTable().getSelectionIndex() : -1;
        this.enableUpButton(isEnable, listSize, selectionIndex);
        this.enableDownButton(isEnable, listSize, selectionIndex);
        this.enableAddExistingButton(isEnable, listSize, selectionIndex);
        this.enableAddNewButton(isEnable, listSize, selectionIndex);
        this.enableDeleteButton(isEnable, listSize, selectionIndex);
    }

    private void enableUpButton(boolean baseEnable, int listSize, int selectionIndex) {
        if (this.btnMoveUp != null && this.showMoveUpButton()) {
            boolean enabled = baseEnable && listSize > 1 && selectionIndex > 0;
            this.btnMoveUp.setEnabled(enabled);
        }
    }

    private void enableDownButton(boolean baseEnable, int listSize, int selectionIndex) {
        if (this.btnMoveDown != null && this.showMoveDownButton()) {
            boolean enabled = baseEnable && listSize > 1 && selectionIndex != -1 && selectionIndex < listSize - 1;
            this.btnMoveDown.setEnabled(enabled);
        }
    }

    private void enableAddExistingButton(boolean baseEnable, int listSize, int selectionIndex) {
        if (this.btnAddExisting != null && this.showAddExistingButton()) {
            this.btnAddExisting.setEnabled(baseEnable);
        }
    }

    private void enableAddNewButton(boolean baseEnable, int listSize, int selectionIndex) {
        if (this.btnAddNew != null && this.showAddNewButton()) {
            this.btnAddNew.setEnabled(baseEnable);
        }
    }

    private void enableDeleteButton(boolean baseEnable, int listSize, int selectionIndex) {
        if (this.btnDelete != null && this.showDeleteButton()) {
            this.btnDelete.setEnabled(baseEnable && listSize > 0 && selectionIndex != -1);
        }
    }

    protected void updateButtonVisibility() {
        boolean isVisible;
        boolean bl = isVisible = !((VControl)this.getVElement()).isEffectivelyReadonly();
        if (this.btnMoveUp != null) {
            this.btnMoveUp.setVisible(this.showMoveUpButton() && isVisible);
        }
        if (this.btnMoveDown != null) {
            this.btnMoveDown.setVisible(this.showMoveDownButton() && isVisible);
        }
        if (this.btnAddExisting != null) {
            this.btnAddExisting.setVisible(this.showAddExistingButton() && isVisible);
        }
        if (this.btnAddNew != null) {
            this.btnAddNew.setVisible(this.showAddNewButton() && isVisible);
        }
        if (this.btnDelete != null) {
            this.btnDelete.setVisible(this.showDeleteButton() && isVisible);
        }
    }

    protected Composite createButtonComposite(Composite parent) throws DatabindingFailedException {
        Composite buttonComposite = new Composite(parent, 0);
        EStructuralFeature structuralFeature = this.getEStructuralFeature();
        int nrButtons = 0;
        if (this.showMoveUpButton()) {
            this.btnMoveUp = this.createMoveUpButton(buttonComposite, structuralFeature);
            ++nrButtons;
        }
        if (this.showMoveDownButton()) {
            this.btnMoveDown = this.createMoveDownButton(buttonComposite, structuralFeature);
            ++nrButtons;
        }
        if (this.showAddExistingButton()) {
            this.btnAddExisting = this.createAddExistingButton(buttonComposite, structuralFeature);
            ++nrButtons;
        }
        if (this.showAddNewButton()) {
            this.btnAddNew = this.createAddNewButton(buttonComposite, structuralFeature);
            ++nrButtons;
        }
        if (this.showDeleteButton()) {
            this.btnDelete = this.createDeleteButton(buttonComposite, structuralFeature);
            ++nrButtons;
        }
        GridLayoutFactory.fillDefaults().numColumns(nrButtons).equalWidth(true).applyTo(buttonComposite);
        return buttonComposite;
    }

    protected void createTitleComposite(Composite parent) throws DatabindingFailedException {
        Composite titleComposite = new Composite(parent, 0);
        titleComposite.setBackgroundMode(2);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)titleComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(titleComposite);
        Label filler = new Label(titleComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)filler);
        this.validationIcon = this.createValidationIcon(titleComposite);
        GridDataFactory.fillDefaults().hint(16, 17).grab(false, false).applyTo((Control)this.validationIcon);
        Composite buttonComposite = this.createButtonComposite(titleComposite);
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000008, 4).applyTo((Control)buttonComposite);
    }

    protected Image getImage(String path) {
        return this.imageRegistryService.getImage(FrameworkUtil.getBundle(MultiReferenceSWTRenderer.class), path);
    }

    protected String getReferenceDisplayName() {
        if (this.referenceDisplayName == null) {
            try {
                EStructuralFeature feature;
                if (this.l10n == null) {
                    this.l10n = (EMFFormsLocalizationService)this.getViewModelContext().getService(EMFFormsLocalizationService.class);
                }
                if ((feature = this.getEStructuralFeature()) != null && this.l10n != null) {
                    EClassifier type = feature.getEType();
                    try {
                        Bundle editBundle = this.bundleResolver.getEditBundle(type);
                        this.referenceDisplayName = this.l10n.getString(editBundle, String.format("_UI_%s_type", type.getName()));
                    }
                    catch (BundleResolver.NoBundleFoundException ex) {
                        this.referenceDisplayName = type.getName();
                    }
                }
            }
            catch (DatabindingFailedException databindingFailedException) {
                // empty catch block
            }
            if (this.referenceDisplayName == null) {
                this.referenceDisplayName = LocalizationServiceHelper.getString(MultiReferenceSWTRenderer.class, (String)"MultiReferenceSWTRenderer_defaultReferenceDisplayName");
            }
        }
        return this.referenceDisplayName;
    }

    private void createContent(Composite composite) throws DatabindingFailedException {
        this.tableViewer = new TableViewer(composite, 68098);
        this.tableViewer.getTable().setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_multireference");
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.tableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                if (((VControl)MultiReferenceSWTRenderer.this.getVElement()).isEffectivelyReadonly()) {
                    return false;
                }
                return event.eventType == 5 || event.eventType == 2 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)this.tableViewer, null, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        ObjectViewerComparator comparator = new ObjectViewerComparator(this::compare);
        boolean isMoveDisabled = this.isMoveDisabled();
        if (isMoveDisabled) {
            this.tableViewer.setComparator((ViewerComparator)comparator);
        }
        ObservableListContentProvider cp = new ObservableListContentProvider();
        EMFFormsLabelProvider labelService = this.getEMFFormsLabelProvider();
        TableViewerColumn column = TableViewerColumnBuilder.create().setResizable(false).setMoveable(false).setStyle(0).build(this.tableViewer);
        ISWTObservableValue textObservableValue = WidgetProperties.text().observe((Widget)column.getColumn());
        ISWTObservableValue tooltipObservableValue = WidgetProperties.tooltipText().observe((Widget)column.getColumn());
        try {
            this.viewModelDBC.bindValue((IObservableValue)textObservableValue, labelService.getDisplayName(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel()));
            this.viewModelDBC.bindValue((IObservableValue)tooltipObservableValue, labelService.getDescription(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel()));
        }
        catch (NoLabelFoundException e) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)e));
        }
        if (isMoveDisabled) {
            column.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(this.tableViewer, (ObjectViewerComparator)(isMoveDisabled ? comparator : null), column.getColumn()));
        }
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.tableViewer.setContentProvider((IContentProvider)cp);
        this.updateTableViewerInputList();
        TableColumnLayout layout = new TableColumnLayout();
        composite.setLayout((Layout)layout);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, false));
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!((VControl)MultiReferenceSWTRenderer.this.getVElement()).isEffectivelyReadonly()) {
                    EObject selectedObject = (EObject)((IStructuredSelection)IStructuredSelection.class.cast(event.getSelection())).getFirstElement();
                    MultiReferenceSWTRenderer.this.handleDoubleClick(selectedObject);
                }
            }
        });
    }

    private boolean isMoveDisabled() {
        return !this.showMoveUpButton() && !this.showMoveDownButton();
    }

    private SelectionAdapter getSelectionAdapter(final TableViewer tableViewer, final ObjectViewerComparator comparator, final TableColumn column) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                comparator.toggleDirection();
                int dir = comparator.getDirection();
                tableViewer.getTable().setSortDirection(dir);
                tableViewer.getTable().setSortColumn(column);
                tableViewer.refresh();
            }
        };
        return selectionAdapter;
    }

    protected void handleDoubleClick(EObject selectedObject) {
        ReferenceService referenceService = this.getReferenceService();
        referenceService.openInNewContext(selectedObject);
    }

    protected void handleAddExisting(TableViewer tableViewer, EObject eObject, EStructuralFeature structuralFeature) {
        ReferenceService referenceService = this.getReferenceService();
        referenceService.addExistingModelElements(eObject, (EReference)structuralFeature);
    }

    protected void handleAddNew(TableViewer tableViewer, EObject eObject, EStructuralFeature structuralFeature) {
        ReferenceService referenceService = this.getReferenceService();
        referenceService.addNewModelElements(eObject, (EReference)structuralFeature, true);
    }

    protected ReferenceService getReferenceService() {
        return (ReferenceService)this.getViewModelContext().getService(ReferenceService.class);
    }

    protected void handleDelete(TableViewer tableViewer, EObject eObject, EStructuralFeature structuralFeature) {
        List deletionList = ((IStructuredSelection)IStructuredSelection.class.cast(tableViewer.getSelection())).toList();
        EditingDomain editingDomain = this.getEditingDomain(eObject);
        EReference reference = (EReference)EReference.class.cast(structuralFeature);
        if (reference.isContainment()) {
            DeleteService deleteService = (DeleteService)this.getViewModelContext().getService(DeleteService.class);
            if (deleteService == null) {
                deleteService = new EMFDeleteServiceImpl();
            }
            deleteService.deleteElements((Collection)deletionList);
        } else {
            this.removeElements(editingDomain, eObject, (EStructuralFeature)reference, deletionList);
        }
    }

    private void removeElements(EditingDomain editingDomain, Object source, EStructuralFeature feature, Collection<Object> toRemove) {
        Command removeCommand = RemoveCommand.create((EditingDomain)editingDomain, (Object)source, (Object)feature, toRemove);
        if (removeCommand.canExecute()) {
            if (editingDomain.getCommandStack() == null) {
                removeCommand.execute();
            } else {
                editingDomain.getCommandStack().execute(removeCommand);
            }
        }
    }

    protected void handleMoveUp(TableViewer tableViewer, EObject eObject, EStructuralFeature structuralFeature) {
        List moveUpList = ((IStructuredSelection)IStructuredSelection.class.cast(tableViewer.getSelection())).toList();
        EditingDomain editingDomain = this.getEditingDomain(eObject);
        for (Object moveUpObject : moveUpList) {
            int currentIndex = ((EList)EList.class.cast(eObject.eGet(structuralFeature))).indexOf(moveUpObject);
            if (currentIndex <= 0) {
                return;
            }
            editingDomain.getCommandStack().execute((Command)new MoveCommand(editingDomain, eObject, structuralFeature, currentIndex, currentIndex - 1));
        }
    }

    protected void handleMoveDown(TableViewer tableViewer, EObject eObject, EStructuralFeature structuralFeature) {
        List moveDownList = ((IStructuredSelection)IStructuredSelection.class.cast(tableViewer.getSelection())).toList();
        EditingDomain editingDomain = this.getEditingDomain(eObject);
        Collections.reverse(moveDownList);
        for (Object moveDownObject : moveDownList) {
            int maxIndex = ((EList)EList.class.cast(eObject.eGet(structuralFeature))).size() - 1;
            int currentIndex = ((EList)EList.class.cast(eObject.eGet(structuralFeature))).indexOf(moveDownObject);
            if (currentIndex < 0 || currentIndex == maxIndex) {
                return;
            }
            editingDomain.getCommandStack().execute((Command)new MoveCommand(editingDomain, eObject, structuralFeature, currentIndex, currentIndex + 1));
        }
    }

    protected void rootDomainModelChanged() throws DatabindingFailedException {
        this.updateTableViewerInputList();
        this.cachedContainer = Optional.ofNullable((EObject)((IObserving)IObserving.class.cast(this.getModelValue())).getObserved());
        this.applyEnable();
        this.applyReadOnly();
    }

    protected IObservableList<?> getReferencedElementsList() throws DatabindingFailedException {
        return this.getEMFFormsDatabinding().getObservableList(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
    }

    protected boolean ignoreEnableOnReadOnly() {
        return false;
    }

    protected void applyEnable() {
        super.applyEnable();
        this.updateButtonEnabling();
    }

    protected void applyReadOnly() {
        this.updateButtonVisibility();
    }

    protected void applyValidation() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (MultiReferenceSWTRenderer.this.validationIcon == null) {
                    return;
                }
                if (MultiReferenceSWTRenderer.this.validationIcon.isDisposed()) {
                    return;
                }
                if (((VControl)MultiReferenceSWTRenderer.this.getVElement()).getDiagnostic() == null) {
                    return;
                }
                MultiReferenceSWTRenderer.this.validationIcon.setImage(MultiReferenceSWTRenderer.this.getValidationIcon(((VControl)MultiReferenceSWTRenderer.this.getVElement()).getDiagnostic().getHighestSeverity()));
                MultiReferenceSWTRenderer.this.validationIcon.setToolTipText(ECPTooltipModifierHelper.modifyString((String)((VControl)MultiReferenceSWTRenderer.this.getVElement()).getDiagnostic().getMessage(), null));
            }
        });
    }

    protected int compare(int direction, Object object1, Object object2) {
        if (direction == 0) {
            return 0;
        }
        int rc = 0;
        String label1 = this.labelProvider.getText(object1);
        String label2 = this.labelProvider.getText(object2);
        rc = label1 == null ? (label2 == null ? 0 : 1) : (label2 == null ? -1 : NumberAwareStringComparator.getInstance().compare(label1, label2));
        if (direction == 2) {
            rc = -rc;
        }
        return rc;
    }

    protected ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    void reveal(Object object) {
        this.checkRenderer();
        if (this.tableViewer != null) {
            StructuredSelection newSelection = new StructuredSelection(object);
            if (!newSelection.equals(this.tableViewer.getSelection())) {
                this.tableViewer.setSelection((ISelection)newSelection, true);
            } else {
                this.tableViewer.reveal(object);
            }
        }
    }
}

