/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.segments.multi;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emf.ecp.view.spi.model.VFeatureDomainModelReferenceSegment;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emf.ecp.view.spi.table.model.VTablePackage;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.segments.DmrSegmentGenerator;
import org.eclipse.emfforms.spi.core.services.segments.EMFFormsSegmentGenerator;
import org.eclipse.emfforms.view.spi.multisegment.model.VMultiDomainModelReferenceSegment;
import org.eclipse.emfforms.view.spi.multisegment.model.VMultisegmentFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(name="TableDmrSegmentGenerator")
public class TableDmrSegmentGenerator
implements DmrSegmentGenerator {
    private EMFFormsSegmentGenerator emfFormsSegmentGenerator;
    private ReportService reportService;

    public double isApplicable(VDomainModelReference reference) {
        Assert.create((Object)reference).notNull();
        if (reference instanceof VTableDomainModelReference) {
            return 5.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    private EMFFormsSegmentGenerator getEMFFormsSegmentGenerator() {
        if (this.emfFormsSegmentGenerator == null) {
            BundleContext bundleContext = FrameworkUtil.getBundle(TableDmrSegmentGenerator.class).getBundleContext();
            ServiceReference serviceReference = bundleContext.getServiceReference(EMFFormsSegmentGenerator.class);
            this.emfFormsSegmentGenerator = (EMFFormsSegmentGenerator)bundleContext.getService(serviceReference);
        }
        return this.emfFormsSegmentGenerator;
    }

    @Reference(unbind="-")
    void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    void setEMFFormsSegmentGenerator(EMFFormsSegmentGenerator generator) {
        this.emfFormsSegmentGenerator = generator;
    }

    public List<VDomainModelReferenceSegment> generateSegments(VDomainModelReference reference) {
        List subDmrSegments;
        Assert.create((Object)reference).notNull();
        if (reference.eClass() != VTablePackage.Literals.TABLE_DOMAIN_MODEL_REFERENCE) {
            throw new IllegalArgumentException(String.format("The given DMR was no table domain model reference. The DMR was: %s", reference));
        }
        LinkedList<VDomainModelReferenceSegment> result = new LinkedList<VDomainModelReferenceSegment>();
        VTableDomainModelReference tableDmr = (VTableDomainModelReference)reference;
        if (tableDmr.getDomainModelReference() != null) {
            subDmrSegments = this.getEMFFormsSegmentGenerator().generateSegments(tableDmr.getDomainModelReference());
        } else {
            VFeaturePathDomainModelReference featureDmr = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
            featureDmr.setDomainModelEFeature(tableDmr.getDomainModelEFeature());
            featureDmr.getDomainModelEReferencePath().addAll((Collection)tableDmr.getDomainModelEReferencePath());
            subDmrSegments = this.getEMFFormsSegmentGenerator().generateSegments((VDomainModelReference)featureDmr);
        }
        if (subDmrSegments.isEmpty()) {
            return result;
        }
        VDomainModelReferenceSegment lastSegment = (VDomainModelReferenceSegment)subDmrSegments.get(subDmrSegments.size() - 1);
        if (!(lastSegment instanceof VFeatureDomainModelReferenceSegment)) {
            this.reportService.report(new AbstractReport(MessageFormat.format("The last path segment of the Table DMR {0} was no feature segment. Consequently, it cannot be transformed to a multi segment and the segment generation for the DMR failed.", tableDmr), 2));
            return result;
        }
        VMultiDomainModelReferenceSegment multiSegment = VMultisegmentFactory.eINSTANCE.createMultiDomainModelReferenceSegment();
        multiSegment.setDomainModelFeature(((VFeatureDomainModelReferenceSegment)VFeatureDomainModelReferenceSegment.class.cast(lastSegment)).getDomainModelFeature());
        multiSegment.getChildDomainModelReferences().addAll((Collection)tableDmr.getColumnDomainModelReferences());
        int i = 0;
        while (i < subDmrSegments.size() - 1) {
            result.add((VDomainModelReferenceSegment)subDmrSegments.get(i));
            ++i;
        }
        result.add((VDomainModelReferenceSegment)multiSegment);
        return result;
    }
}

