/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.common;

import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.spi.common.report.ReportService;

public abstract class AbstractRenderer<VELEMENT extends VElement> {
    private final VELEMENT vElement;
    private final ViewModelContext viewModelContext;
    private boolean disposed;
    private final ReportService reportService;

    public AbstractRenderer(VELEMENT vElement, ViewModelContext viewContext, ReportService reportService) {
        if (vElement == null) {
            throw new IllegalArgumentException("vElement must not be null");
        }
        if (viewContext == null) {
            throw new IllegalArgumentException("vContext must not be null");
        }
        if (reportService == null) {
            throw new IllegalArgumentException("reportService must not be null");
        }
        this.vElement = vElement;
        this.viewModelContext = viewContext;
        this.reportService = reportService;
    }

    public final ViewModelContext getViewModelContext() {
        this.checkRenderer();
        return this.viewModelContext;
    }

    public final VELEMENT getVElement() {
        this.checkRenderer();
        return this.vElement;
    }

    protected void dispose() {
        this.disposed = true;
    }

    protected void checkRenderer() {
        if (this.disposed) {
            throw new IllegalStateException("Renderer is disposed");
        }
    }

    protected final ReportService getReportService() {
        this.checkRenderer();
        return this.reportService;
    }
}

