/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.graphiti;

import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.editor.DefaultUpdateBehavior;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.editor.ElementDeleteListener;
import org.eclipse.graphiti.ui.editor.IDiagramEditorInput;
import org.eclipse.graphiti.ui.internal.Messages;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

public class UpdateBehavior
extends DefaultUpdateBehavior {
    private TransactionalEditingDomain editingDomain;
    private ElementDeleteListener elementDeleteListener = null;
    private boolean resourceDeleted = false;
    private boolean resourceChanged = false;
    private boolean adapterActive = true;
    private Adapter updateAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (!UpdateBehavior.this.isAdapterActive()) {
                return;
            }
            if (msg.getFeatureID(Resource.class) == 4 && msg.getNewBooleanValue() == Boolean.FALSE.booleanValue()) {
                Resource resource = (Resource)msg.getNotifier();
                URI uri = resource.getURI();
                if (UpdateBehavior.this.editingDomain.getResourceSet().getURIConverter().exists(uri, null)) {
                    UpdateBehavior.this.setResourceChanged(true);
                    IEditorPart activeEditor = UpdateBehavior.this.diagramEditor.getSite().getPage().getActiveEditor();
                    if (activeEditor == UpdateBehavior.this.diagramEditor) {
                        UpdateBehavior.this.getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                UpdateBehavior.this.handleActivate();
                            }
                        });
                    }
                } else if (!UpdateBehavior.this.diagramEditor.isDirty()) {
                    IEditorInput editorInput = UpdateBehavior.this.diagramEditor.getEditorInput();
                    if (editorInput instanceof IDiagramEditorInput) {
                        IDiagramEditorInput input = (IDiagramEditorInput)editorInput;
                        URI inputUri = input.getUri();
                        URI diagUri = GraphitiUiInternal.getEmfService().mapDiagramFileUriToDiagramUri(uri);
                        if (diagUri.equals((Object)inputUri)) {
                            this.startCloseEditorJob();
                        }
                    }
                } else {
                    UpdateBehavior.this.setResourceDeleted(true);
                    IEditorPart activeEditor = UpdateBehavior.this.diagramEditor.getSite().getPage().getActiveEditor();
                    if (activeEditor == UpdateBehavior.this.diagramEditor) {
                        UpdateBehavior.this.getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                UpdateBehavior.this.handleActivate();
                            }
                        });
                    }
                }
            }
            super.notifyChanged(msg);
        }

        private void startCloseEditorJob() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    UpdateBehavior.this.closeEditor();
                }
            });
        }
    };
    private Diagram diagram;

    public UpdateBehavior(DiagramEditor diagramEditor) {
        super(diagramEditor);
    }

    public void setDiagram(Diagram diagram) {
        this.diagram = diagram;
    }

    protected boolean isResourceDeleted() {
        return this.resourceDeleted;
    }

    public void setResourceDeleted(boolean resourceDeleted) {
        this.resourceDeleted = resourceDeleted;
    }

    protected boolean isResourceChanged() {
        return this.resourceChanged;
    }

    public void setResourceChanged(boolean resourceChanged) {
        this.resourceChanged = resourceChanged;
    }

    public void handleActivate() {
        if (this.isResourceDeleted()) {
            if (this.handleDirtyConflict()) {
                this.closeEditor();
            } else {
                this.setResourceDeleted(false);
                this.setResourceChanged(false);
            }
        } else if (this.isResourceChanged()) {
            this.handleChangedResources();
            this.setResourceChanged(false);
        }
    }

    protected boolean isAdapterActive() {
        return this.adapterActive;
    }

    public void setAdapterActive(boolean active) {
        this.adapterActive = active;
    }

    protected void handleChangedResources() {
        if (!this.diagramEditor.isDirty() || this.handleDirtyConflict()) {
            this.diagramEditor.disableAdapters();
            try {
                EList resources = this.getEditingDomain().getResourceSet().getResources();
                for (Resource resource : resources) {
                    resource.unload();
                }
                this.diagramEditor.refreshContent();
            }
            finally {
                this.diagramEditor.enableAdapters();
            }
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.DiscardChangesDialog_0_xmsg, (String)Messages.DiscardChangesDialog_1_xmsg);
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void init() {
        for (Resource r : this.getEditingDomain().getResourceSet().getResources()) {
            r.eAdapters().add((Object)this.updateAdapter);
        }
        EObject object = (EObject)this.diagramEditor.getAdapter(Diagram.class);
        if (object != null) {
            this.elementDeleteListener = new ElementDeleteListener(this.diagramEditor);
            object.eAdapters().add((Object)this.elementDeleteListener);
        }
    }

    protected void createEditingDomain() {
        TransactionalEditingDomain editingDomain = (TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.diagram);
        this.initializeEditingDomain(editingDomain);
    }

    protected void initializeEditingDomain(TransactionalEditingDomain domain) {
        this.editingDomain = domain;
        this.diagramEditor.editingDomainInitialized();
    }

    public void dispose() {
        for (Resource r : this.editingDomain.getResourceSet().getResources()) {
            r.eAdapters().remove((Object)this.updateAdapter);
        }
        EObject object = (EObject)this.diagramEditor.getAdapter(Diagram.class);
        if (object != null) {
            object.eAdapters().remove((Object)this.elementDeleteListener);
        }
        this.disposeEditingDomain();
        this.editingDomain = null;
    }

    protected void disposeEditingDomain() {
    }

    public void historyNotification(OperationHistoryEvent event) {
        switch (event.getEventType()) {
            case 9: 
            case 10: {
                this.diagramEditor.updateDirtyState();
            }
        }
    }

    private Shell getShell() {
        return this.diagramEditor.getSite().getShell();
    }

    private void closeEditor() {
        if (this.diagramEditor == null) {
            return;
        }
        IWorkbenchPartSite site = this.diagramEditor.getSite();
        if (site == null) {
            return;
        }
        IWorkbenchPage page = site.getPage();
        if (page == null) {
            return;
        }
        page.closeEditor((IEditorPart)this.diagramEditor, false);
    }
}

