/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.ease.lang.unittest.ui.wizards.TestSuiteCreationPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class TestSuiteWizard
extends BasicNewResourceWizard {
    public static final String WIZARD_ID = "org.eclipse.ease.lang.unittest.ui.wizard.newTestSuiteWizard";
    private WizardNewFileCreationPage mainPage;

    public void addPages() {
        super.addPages();
        this.mainPage = new TestSuiteCreationPage("newFilePage1", this.getSelection());
        this.mainPage.setTitle("Script Testsuite");
        this.mainPage.setDescription("This wizard creates a new script testsuite.");
        this.mainPage.setFileName("Testsuite.suite");
        this.mainPage.setAllowExistingResources(false);
        this.mainPage.setFileExtension("suite");
        this.addPage((IWizardPage)this.mainPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle(ResourceMessages.FileResource_shellTitle);
        this.setNeedsProgressMonitor(true);
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = IDEWorkbenchPlugin.getIDEImageDescriptor((String)"wizban/newfile_wiz.png");
        this.setDefaultPageImageDescriptor(desc);
    }

    public boolean performFinish() {
        IFile file = this.mainPage.createNewFile();
        if (file == null) {
            return false;
        }
        this.selectAndReveal((IResource)file);
        IWorkbenchWindow dw = this.getWorkbench().getActiveWorkbenchWindow();
        try {
            IWorkbenchPage page;
            if (dw != null && (page = dw.getActivePage()) != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            }
        }
        catch (PartInitException e) {
            DialogUtil.openError((Shell)dw.getShell(), (String)ResourceMessages.FileResource_errorMessage, (String)e.getMessage(), (PartInitException)e);
        }
        return true;
    }
}

