/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.adapters;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.ease.IScriptable;

public class ScriptableAdapter
implements IAdapterFactory {
    public final Object getAdapter(final Object adaptableObject, Class adapterType) {
        if (adapterType.equals(IScriptable.class)) {
            if (adaptableObject instanceof IFile) {
                return new IScriptable(){

                    @Override
                    public InputStream getSourceCode() throws Exception {
                        return ((IFile)adaptableObject).getContents();
                    }
                };
            }
            if (adaptableObject instanceof File) {
                return new IScriptable(){

                    @Override
                    public InputStream getSourceCode() throws Exception {
                        return new FileInputStream((File)adaptableObject);
                    }
                };
            }
            if (adaptableObject instanceof URL) {
                return new IScriptable(){

                    @Override
                    public InputStream getSourceCode() throws Exception {
                        return ((URL)adaptableObject).openStream();
                    }
                };
            }
            if (adaptableObject instanceof URI) {
                return new IScriptable(){

                    @Override
                    public InputStream getSourceCode() throws Exception {
                        return ((URI)adaptableObject).toURL().openStream();
                    }
                };
            }
        }
        return null;
    }

    public final Class[] getAdapterList() {
        return new Class[]{IScriptable.class};
    }
}

