/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples.remote;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.semantic.examples.remote.Messages;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFile;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFolder;
import org.eclipse.core.resources.semantic.examples.remote.RemoteItem;
import org.eclipse.core.resources.semantic.examples.remote.RemoteStore;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;

public class RemoteStoreEditor
extends EditorPart {
    public static Image FOLDERIMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    public static Image FILEIMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    IFile myFile;
    TreeViewer tv;
    boolean dirty = false;

    public void doSave(IProgressMonitor monitor) {
        if (this.dirty) {
            try {
                ((RemoteStore)((RemoteFolder)this.tv.getInput()).getStore()).serialize(monitor);
                this.markDirty(false);
            }
            catch (CoreException coreException) {
                monitor.setCanceled(true);
            }
        }
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof IFileEditorInput) {
            this.myFile = ((IFileEditorInput)input).getFile();
            if (!this.myFile.getName().equals("simulatedRemoteContent.xml")) {
                throw new PartInitException(NLS.bind((String)Messages.RemoteStoreEditor_WrongFile_XMSG, (Object)"simulatedRemoteContent.xml"));
            }
        } else {
            throw new PartInitException(Messages.RemoteStoreEditor_WrongInput_XMSG);
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        ToolBar bar = new ToolBar(main, 256);
        ToolItem newFolder = new ToolItem(bar, 8);
        newFolder.setText(Messages.RemoteStoreEditor_NewRootFolder_XBUT);
        newFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RemoteStoreEditor.this.createChild(true, (RemoteFolder)RemoteStoreEditor.this.tv.getInput());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ToolItem newFile = new ToolItem(bar, 8);
        newFile.setText(Messages.RemoteStoreEditor_NewRootFile_XBUT);
        newFile.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RemoteStoreEditor.this.createChild(false, (RemoteFolder)RemoteStoreEditor.this.tv.getInput());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final SashForm sash = new SashForm(main, 512);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)sash);
        this.tv = new TreeViewer((Composite)sash, 65540);
        this.tv.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((RemoteFolder)inputElement).getChildren().toArray();
            }

            public boolean hasChildren(Object element) {
                RemoteItem item = (RemoteItem)element;
                if (item.getType() == RemoteItem.Type.FOLDER) {
                    return !((RemoteFolder)item).getChildren().isEmpty();
                }
                return false;
            }

            public Object getParent(Object element) {
                RemoteFolder folder = ((RemoteItem)element).getParent();
                return folder;
            }

            public Object[] getChildren(Object parentElement) {
                RemoteItem item = (RemoteItem)parentElement;
                if (item.getType() == RemoteItem.Type.FOLDER) {
                    RemoteFolder folder = (RemoteFolder)item;
                    return folder.getChildren().toArray(new RemoteItem[0]);
                }
                return new Object[0];
            }
        });
        this.tv.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                RemoteItem item = (RemoteItem)element;
                switch (columnIndex) {
                    case 0: {
                        return item.getName();
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        if (((RemoteItem)element).getType() == RemoteItem.Type.FOLDER) {
                            return FOLDERIMAGE;
                        }
                        return FILEIMAGE;
                    }
                }
                return null;
            }
        });
        final Tree tree = this.tv.getTree();
        TreeColumn column = new TreeColumn(tree, 0);
        column.setText(Messages.RemoteStoreEditor_Name_XCOL);
        column.setWidth(300);
        this.tv.getTree().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                RemoteStoreEditor.this.fillContextMenu(tree, e);
            }
        });
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        final IResourceDeltaVisitor dv = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) {
                if (delta.getKind() == 2 && delta.getFullPath().equals((Object)RemoteStoreEditor.this.myFile.getFullPath())) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            RemoteStoreEditor.this.getSite().getPage().closeEditor((IEditorPart)RemoteStoreEditor.this, false);
                        }
                    });
                    return false;
                }
                if (delta.getKind() == 4 && (delta.getFlags() & 0x100) > 0 && delta.getFullPath().equals((Object)RemoteStoreEditor.this.myFile.getFullPath())) {
                    RemoteStoreEditor.this.refresh();
                    return false;
                }
                return true;
            }
        };
        this.myFile.getProject().getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                try {
                    if (event.getDelta() != null) {
                        event.getDelta().accept(dv);
                    }
                }
                catch (CoreException coreException) {}
            }
        });
        Composite fileParent = new Composite((Composite)sash, 0);
        fileParent.setLayout((Layout)new GridLayout(3, false));
        Label timestampLabel = new Label(fileParent, 0);
        timestampLabel.setText(Messages.RemoteStoreEditor_Timestamp_XFLD);
        final Text timestamp = new Text(fileParent, 4);
        timestamp.setEnabled(false);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)timestamp);
        Button newStamp = new Button(fileParent, 8);
        newStamp.setText(Messages.RemoteStoreEditor_UpdateTime_XBUT);
        newStamp.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object selected = ((IStructuredSelection)RemoteStoreEditor.this.tv.getSelection()).getFirstElement();
                if (selected instanceof RemoteFile) {
                    ((RemoteFile)selected).setTimestamp(System.currentTimeMillis());
                    RemoteStoreEditor.this.markDirty(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Label label = new Label(fileParent, 0);
        GridDataFactory.fillDefaults().align(16384, 128).applyTo((Control)label);
        final Text content = new Text(fileParent, 2);
        content.setEditable(false);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)content);
        sash.setMaximizedControl(this.tv.getControl());
        this.tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = event.getSelection();
                Object first = ((IStructuredSelection)sel).getFirstElement();
                if (first instanceof RemoteFile) {
                    sash.setMaximizedControl(null);
                    RemoteFile file = (RemoteFile)first;
                    timestamp.setText(file.format.format(new Date(file.getTimestamp())));
                    try {
                        try {
                            String encoding = file.getStore().getDefaultCharset();
                            label.setText(NLS.bind((String)Messages.RemoteStoreEditor_Content_XFLD, (Object)encoding));
                            content.setText(new String(file.getContent(), encoding));
                            label.getParent().layout(true);
                        }
                        catch (CoreException coreException) {
                            content.setText(new String(file.getContent()));
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        content.setText(new String(file.getContent()));
                    }
                } else {
                    sash.setMaximizedControl(RemoteStoreEditor.this.tv.getControl());
                }
            }
        });
        this.refresh();
    }

    void markDirty(boolean actDirty) {
        if (this.dirty != actDirty) {
            this.dirty = actDirty;
            this.firePropertyChange(257);
        }
        this.refresh();
    }

    void refresh() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (RemoteStoreEditor.this.tv.getTree().isDisposed()) {
                    return;
                }
                if (!RemoteStoreEditor.this.dirty) {
                    RemoteStore store = (RemoteStore)RemoteStoreEditor.this.myFile.getProject().getAdapter(RemoteStore.class);
                    RemoteStoreEditor.this.tv.setInput((Object)store.getRootFolder());
                } else {
                    RemoteStoreEditor.this.tv.setInput(RemoteStoreEditor.this.tv.getInput());
                }
                RemoteStoreEditor.this.tv.setSelection(RemoteStoreEditor.this.tv.getSelection());
            }
        });
    }

    void createChild(boolean asFolder, final RemoteFolder parentFolder) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (parentFolder.hasChild(newText)) {
                    return NLS.bind((String)Messages.RemoteStoreEditor_NameInUse_XMSG, (Object)newText);
                }
                return null;
            }
        };
        InputDialog dialog = new InputDialog(this.getSite().getShell(), Messages.RemoteStoreEditor_CreateChild_XGRP, Messages.RemoteStoreEditor_ChildName_XFLD, "", validator);
        if (dialog.open() == 0) {
            String name = dialog.getValue();
            if (asFolder) {
                parentFolder.addFolder(name);
            } else {
                parentFolder.addFile(name, new byte[0], System.currentTimeMillis());
            }
            this.markDirty(true);
        }
    }

    public void setFocus() {
    }

    void fillContextMenu(Tree tree, MenuDetectEvent mouseEvent) {
        Menu treeMenu = new Menu((Control)tree);
        tree.setMenu(treeMenu);
        if (mouseEvent.getSource() instanceof Tree) {
            TreeItem[] selected = tree.getSelection();
            if (selected.length != 1) {
                return;
            }
            Object data = selected[0].getData();
            if (!(data instanceof RemoteItem)) {
                return;
            }
            final RemoteItem item = (RemoteItem)data;
            MenuItem delete = new MenuItem(treeMenu, 8);
            delete.setText(Messages.RemoteStoreEditor_Delete_XMEN);
            delete.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    RemoteFolder parent = item.getParent();
                    parent.deleteChild(item.getName());
                    RemoteStoreEditor.this.markDirty(true);
                    RemoteStoreEditor.this.tv.setSelection((ISelection)new StructuredSelection((Object)parent));
                    RemoteStoreEditor.this.tv.expandToLevel((Object)parent, 1);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            if (item instanceof RemoteFolder) {
                final RemoteFolder folder = (RemoteFolder)item;
                MenuItem createFolder = new MenuItem(treeMenu, 8);
                createFolder.setText(Messages.RemoteStoreEditor_CreateFolder_XMEN);
                createFolder.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        RemoteStoreEditor.this.createChild(true, folder);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                MenuItem createFile = new MenuItem(treeMenu, 8);
                createFile.setText(Messages.RemoteStoreEditor_CreateFile_XMEN);
                createFile.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        RemoteStoreEditor.this.createChild(false, folder);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
            if (item instanceof RemoteFile) {
                final RemoteFile file = (RemoteFile)item;
                MenuItem uploadContent = new MenuItem(treeMenu, 8);
                uploadContent.setText(Messages.RemoteStoreEditor_Upload_XMEN);
                uploadContent.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        FileDialog dialog = new FileDialog(RemoteStoreEditor.this.getSite().getShell(), 4096);
                        String result = dialog.open();
                        if (result == null) {
                            return;
                        }
                        try {
                            FileInputStream is = new FileInputStream(new File(result));
                            Util.transferStreams((InputStream)is, (OutputStream)file.getOutputStream(false), null);
                            RemoteStoreEditor.this.markDirty(true);
                        }
                        catch (FileNotFoundException e1) {
                            ErrorDialog.openError((Shell)RemoteStoreEditor.this.getSite().getShell(), (String)Messages.RemoteStoreEditor_Error_XGRP, (String)e1.getMessage(), null);
                        }
                        catch (CoreException e1) {
                            ErrorDialog.openError((Shell)RemoteStoreEditor.this.getSite().getShell(), (String)Messages.RemoteStoreEditor_Error_XGRP, null, (IStatus)e1.getStatus());
                        }
                        RemoteStoreEditor.this.tv.setSelection((ISelection)new StructuredSelection((Object)file), true);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                MenuItem changeContent = new MenuItem(treeMenu, 8);
                changeContent.setText(Messages.RemoteStoreEditor_ChangeContent_XMEN);
                changeContent.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        InputDialog dialog = new InputDialog(RemoteStoreEditor.this.getSite().getShell(), Messages.RemoteStoreEditor_EnterContent_XGRP, Messages.RemoteStoreEditor_NewContent_XFLD, "", null);
                        if (dialog.open() == 0) {
                            try {
                                ByteArrayInputStream is = new ByteArrayInputStream(dialog.getValue().getBytes("UTF-8"));
                                Util.transferStreams((InputStream)is, (OutputStream)file.getOutputStream(false), null);
                                RemoteStoreEditor.this.markDirty(true);
                            }
                            catch (UnsupportedEncodingException e1) {
                                MessageDialog.openError((Shell)RemoteStoreEditor.this.getSite().getShell(), (String)Messages.RemoteStoreEditor_Error_XGRP, (String)e1.getMessage());
                            }
                            catch (CoreException e1) {
                                MessageDialog.openError((Shell)RemoteStoreEditor.this.getSite().getShell(), (String)Messages.RemoteStoreEditor_Error_XGRP, (String)e1.getMessage());
                            }
                            RemoteStoreEditor.this.tv.setSelection((ISelection)new StructuredSelection((Object)file), true);
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
        }
    }
}

