/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.layouts.control;

import org.eclipse.e4.xwt.converters.StringToInteger;
import org.eclipse.e4.xwt.tools.ui.designer.layouts.control.FieldEditor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class RadioGroupFieldEditor
extends FieldEditor {
    private String[][] labelsAndValues;
    private Button[] radioButtons;
    private String value;
    private String groupName;

    public RadioGroupFieldEditor(String fieldName, String[][] labelsAndValues, Composite parent, String groupName) {
        this.init(fieldName, "");
        this.labelsAndValues = labelsAndValues;
        this.groupName = groupName;
        this.createControl(parent);
    }

    protected Control createEditor(Composite parent) {
        Composite radioBox;
        if (this.groupName == null) {
            radioBox = new Composite(parent, 0);
        } else {
            radioBox = new Group(parent, 0);
            ((Group)radioBox).setText(this.groupName);
        }
        this.adapt((Control)radioBox);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        radioBox.setLayout((Layout)layout);
        if (this.labelsAndValues != null) {
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    String oldValue = RadioGroupFieldEditor.this.value;
                    RadioGroupFieldEditor.this.value = (String)event.widget.getData();
                    RadioGroupFieldEditor.this.dispatchEvent(oldValue, RadioGroupFieldEditor.this.value);
                }
            };
            this.radioButtons = new Button[this.labelsAndValues.length];
            int i = 0;
            while (i < this.labelsAndValues.length) {
                Button radio;
                this.radioButtons[i] = radio = new Button(radioBox, 16400);
                String[] labelAndValue = this.labelsAndValues[i];
                radio.setText(labelAndValue[0]);
                radio.setData((Object)labelAndValue[1]);
                radio.addListener(13, listener);
                this.adapt((Control)radio);
                ++i;
            }
        }
        return radioBox;
    }

    protected void update(String selected) {
        this.value = selected;
        if (this.radioButtons == null) {
            return;
        }
        if (this.value != null) {
            boolean found = false;
            int i = 0;
            while (i < this.radioButtons.length) {
                Button radio = this.radioButtons[i];
                boolean selection = false;
                String data = (String)radio.getData();
                Object intValue = StringToInteger.instance.convert((Object)data);
                if (data.equals(this.value) || this.value.equals(intValue.toString())) {
                    selection = true;
                    found = true;
                }
                radio.setSelection(selection);
                ++i;
            }
            if (found) {
                return;
            }
        }
        if (this.radioButtons.length > 0) {
            this.radioButtons[0].setSelection(true);
            this.value = (String)this.radioButtons[0].getData();
        }
    }
}

