/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.swt.modeling;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.internal.expressions.ReferenceExpression;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MCoreExpression;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MRenderedMenu;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ExpressionContext;
import org.eclipse.e4.ui.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuServiceFilter
implements Listener {
    private static final String TMP_ORIGINAL_CONTEXT = "MenuServiceFilter.original.context";
    public static final String MC_POPUP = "menuContribution:popup";
    public static final String MC_MENU = "menuContribution:menu";
    private static Method aboutToShow;
    @Inject
    private MApplication application;
    @Inject
    private IPresentationEngine renderer;
    @Inject
    EModelService modelService;
    private HashMap<Menu, Runnable> pendingCleanup = new HashMap();

    private static void trace(String msg, Widget menu, MMenu menuModel) {
        WorkbenchSWTActivator.trace("/trace/menus", String.valueOf(msg) + ": " + menu + ": " + menuModel, null);
    }

    public static Method getAboutToShow() {
        if (aboutToShow == null) {
            try {
                aboutToShow = MenuManager.class.getDeclaredMethod("handleAboutToShow", new Class[0]);
                aboutToShow.setAccessible(true);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        return aboutToShow;
    }

    public void handleEvent(Event event) {
        if (!(event.widget instanceof Menu)) {
            return;
        }
        Menu menu = (Menu)event.widget;
        Object obj = menu.getData("modelElement");
        if (obj == null && menu.getParentItem() != null) {
            obj = menu.getParentItem().getData("modelElement");
        }
        if (obj instanceof MRenderedMenu) {
            this.handlerRenderedMenu(event, menu, (MRenderedMenu)obj);
        } else if (obj instanceof MPopupMenu) {
            this.handleContextMenu(event, menu, (MPopupMenu)obj);
        } else if (obj instanceof MMenu) {
            this.handleMenu(event, menu, (MMenu)obj);
        }
    }

    private void handleMenu(Event event, Menu menu, MMenu menuModel) {
        if ((menu.getStyle() & 2) != 0) {
            return;
        }
        switch (event.type) {
            case 22: {
                MenuServiceFilter.trace("handleMenu.Show", (Widget)menu, menuModel);
                this.cleanUp(menu);
                this.showMenu(event, menu, menuModel);
                break;
            }
            case 23: {
                MenuServiceFilter.trace("handleMenu.Hide", (Widget)menu, menuModel);
                break;
            }
            case 12: {
                MenuServiceFilter.trace("handleMenu.Dispose", (Widget)menu, menuModel);
                this.cleanUp(menu);
            }
        }
    }

    public void showMenu(Event event, final Menu menu, final MMenu menuModel) {
        IEclipseContext parentContext = this.modelService.getContainingContext((MUIElement)menuModel);
        ArrayList<MMenuContribution> toContribute = new ArrayList<MMenuContribution>();
        final ArrayList menuContributionsToRemove = new ArrayList();
        ExpressionContext eContext = new ExpressionContext(parentContext);
        this.gatherMenuContributions(menuModel, menuModel.getElementId(), toContribute, eContext, false);
        ContributionsAnalyzer.addMenuContributions((MMenu)menuModel, toContribute, menuContributionsToRemove);
        this.pendingCleanup.put(menu, new Runnable(){

            public void run() {
                if (!menu.isDisposed()) {
                    MenuServiceFilter.this.unrender(menuContributionsToRemove);
                }
                MenuServiceFilter.this.removeMenuContributions(menuModel, menuContributionsToRemove);
            }
        });
        this.render(menu, menuModel);
    }

    private void handleContextMenu(Event event, Menu menu, MPopupMenu menuModel) {
        switch (event.type) {
            case 22: {
                MenuServiceFilter.trace("handleContextMenu.Show", (Widget)menu, (MMenu)menuModel);
                this.cleanUp(menu);
                this.showPopup(event, menu, menuModel);
                break;
            }
            case 23: {
                MenuServiceFilter.trace("handleContextMenu.Hide", (Widget)menu, (MMenu)menuModel);
                this.hidePopup(event, menu, menuModel);
                break;
            }
            case 12: {
                MenuServiceFilter.trace("handleContextMenu.Dispose", (Widget)menu, (MMenu)menuModel);
                this.cleanUp(menu);
            }
        }
    }

    public void hidePopup(Event event, Menu menu, MPopupMenu menuModel) {
        IEclipseContext popupContext = menuModel.getContext();
        final IEclipseContext parentContext = popupContext.getParent();
        final IEclipseContext originalChild = (IEclipseContext)popupContext.get(TMP_ORIGINAL_CONTEXT);
        popupContext.remove(TMP_ORIGINAL_CONTEXT);
        if (!menu.isDisposed()) {
            menu.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    parentContext.set("activeChildContext", (Object)originalChild);
                }
            });
        }
    }

    public void showPopup(Event event, final Menu menu, final MPopupMenu menuModel) {
        IEclipseContext popupContext = menuModel.getContext();
        IEclipseContext parentContext = popupContext.getParent();
        IEclipseContext originalChild = (IEclipseContext)parentContext.getLocal("activeChildContext");
        parentContext.set("activeChildContext", (Object)popupContext);
        popupContext.set(TMP_ORIGINAL_CONTEXT, (Object)originalChild);
        ArrayList<MMenuContribution> toContribute = new ArrayList<MMenuContribution>();
        final ArrayList menuContributionsToRemove = new ArrayList();
        ExpressionContext eContext = new ExpressionContext(popupContext);
        this.gatherMenuContributions((MMenu)menuModel, menuModel.getElementId(), toContribute, eContext, true);
        for (String tag : menuModel.getTags()) {
            if (!tag.startsWith("popup:") || tag.length() <= 6) continue;
            this.gatherMenuContributions((MMenu)menuModel, tag.substring(6), toContribute, eContext, false);
        }
        ContributionsAnalyzer.addMenuContributions((MMenu)menuModel, toContribute, menuContributionsToRemove);
        this.pendingCleanup.put(menu, new Runnable(){

            public void run() {
                if (!menu.isDisposed()) {
                    MenuServiceFilter.this.unrender(menuContributionsToRemove);
                }
                MenuServiceFilter.this.removeMenuContributions((MMenu)menuModel, menuContributionsToRemove);
            }
        });
        this.render(menu, (MMenu)menuModel);
    }

    private void render(Menu menu, MMenu menuModel) {
        MenuServiceFilter.trace("render", (Widget)menu, menuModel);
        for (MMenuElement element : menuModel.getChildren()) {
            this.renderer.createGui((MUIElement)element, (Object)menu);
        }
    }

    private void unrender(List<MMenuElement> menuModel) {
        MenuServiceFilter.trace("unrender", null, null);
        for (MMenuElement element : menuModel) {
            this.renderer.removeGui((MUIElement)element);
        }
    }

    private void gatherMenuContributions(MMenu menuModel, String id, ArrayList<MMenuContribution> toContribute, ExpressionContext eContext, boolean includePopups) {
        for (MMenuContribution menuContribution : this.application.getMenuContributions()) {
            String parentID = menuContribution.getParentID();
            boolean popup = parentID.equals("popup") && menuModel instanceof MPopupMenu && includePopups;
            boolean filtered = this.isFiltered(menuModel, menuContribution);
            if (filtered || !popup && !parentID.equals(id) || !menuContribution.isToBeRendered() || !this.isVisible(menuContribution, eContext)) continue;
            toContribute.add(menuContribution);
        }
    }

    private boolean isFiltered(MMenu menuModel, MMenuContribution menuContribution) {
        if (menuModel.getTags().contains(MC_POPUP)) {
            return !menuContribution.getTags().contains(MC_POPUP) && menuContribution.getTags().contains(MC_MENU);
        }
        if (menuModel.getTags().contains(MC_MENU)) {
            return !menuContribution.getTags().contains(MC_MENU) && menuContribution.getTags().contains(MC_POPUP);
        }
        return false;
    }

    private void removeMenuContributions(MMenu menuModel, ArrayList<MMenuElement> menuContributionsToRemove) {
        for (MMenuElement item : menuContributionsToRemove) {
            MenuServiceFilter.trace("removeMenuContributions " + item, (Widget)menuModel.getWidget(), menuModel);
            menuModel.getChildren().remove(item);
        }
    }

    private void handlerRenderedMenu(Event event, Menu menu, MRenderedMenu menuModel) {
        switch (event.type) {
            case 22: {
                MenuServiceFilter.trace("handlerRenderedMenu.Show", (Widget)menu, (MMenu)menuModel);
                this.cleanUp(menu);
                this.showRenderedMenu(event, menu, menuModel);
                break;
            }
            case 23: {
                MenuServiceFilter.trace("handlerRenderedMenu.Hide", (Widget)menu, (MMenu)menuModel);
                break;
            }
            case 12: {
                MenuServiceFilter.trace("handlerRenderedMenu.Dispose", (Widget)menu, (MMenu)menuModel);
                this.cleanUp(menu);
            }
        }
    }

    public void showRenderedMenu(Event event, Menu menu, MRenderedMenu menuModel) {
        if (!(menuModel.getContributionManager() instanceof MenuManager)) {
            return;
        }
        MenuManager manager = (MenuManager)menuModel.getContributionManager();
        Method handleAboutToShow = MenuServiceFilter.getAboutToShow();
        try {
            handleAboutToShow.invoke((Object)manager, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        if (menuModel.getChildren().size() == 1 && menuModel.getChildren().get(0) instanceof MPopupMenu) {
            this.showPopup(event, menu, (MPopupMenu)menuModel.getChildren().get(0));
        } else {
            this.showMenu(event, menu, (MMenu)menuModel);
        }
        event.type = 0;
        event.doit = false;
    }

    public void cleanUp(Menu menu) {
        MenuServiceFilter.trace("cleanUp", (Widget)menu, null);
        if (this.pendingCleanup.isEmpty()) {
            return;
        }
        Runnable cleanUp = this.pendingCleanup.remove(menu);
        if (cleanUp != null) {
            MenuServiceFilter.trace("cleanUp.run()", (Widget)menu, null);
            cleanUp.run();
        }
    }

    private boolean isVisible(MMenuContribution menuContribution, ExpressionContext eContext) {
        if (menuContribution.getVisibleWhen() == null) {
            return true;
        }
        MCoreExpression exp = (MCoreExpression)menuContribution.getVisibleWhen();
        Expression ref = null;
        if (exp.getCoreExpression() instanceof Expression) {
            ref = (Expression)exp.getCoreExpression();
        } else {
            ref = new ReferenceExpression(exp.getCoreExpressionId());
            exp.setCoreExpression((Object)ref);
        }
        try {
            return ref.evaluate((IEvaluationContext)eContext) != EvaluationResult.FALSE;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void dispose() {
        Menu[] keys;
        Menu[] menuArray = keys = this.pendingCleanup.keySet().toArray(new Menu[this.pendingCleanup.size()]);
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Menu menu = menuArray[n2];
            this.cleanUp(menu);
            ++n2;
        }
    }
}

