/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class CTabRendering
extends CTabFolderRenderer {
    static final int LEFT_TOP = 0;
    static final int LEFT_BOTTOM = 1;
    static final int RIGHT_TOP = 2;
    static final int RIGHT_BOTTOM = 3;
    static final int SIDE_DROP_WIDTH = 3;
    static final int BOTTOM_DROP_WIDTH = 4;
    static final int OUTER_KEYLINE = 1;
    static final int INNER_KEYLINE = 0;
    static final int TOP_KEYLINE = 0;
    static final int ITEM_TOP_MARGIN = 2;
    static final int ITEM_BOTTOM_MARGIN = 6;
    static final int ITEM_LEFT_MARGIN = 4;
    static final int ITEM_RIGHT_MARGIN = 4;
    static final int INTERNAL_SPACING = 4;
    static final String E4_SHADOW_IMAGE = "org.eclipse.e4.renderer.shadow_image";
    static final String E4_TOOLBAR_ACTIVE_IMAGE = "org.eclipse.e4.renderer.toolbar_background_active_image";
    static final String E4_TOOLBAR_INACTIVE_IMAGE = "org.eclipse.e4.renderer.toolbar_background_inactive_image";
    static int[] shape;
    Image shadowImage;
    Image toolbarActiveImage;
    Image toolbarInactiveImage;
    int cornerSize = 14;
    boolean shadowEnabled = true;
    Color outerKeyline;
    Color innerKeyline;
    Color[] activeToolbar;
    int[] activePercents;
    Color[] inactiveToolbar;
    int[] inactivePercents;
    boolean active;

    @Inject
    public CTabRendering(CTabFolder parent) {
        super(parent);
    }

    protected Rectangle computeTrim(int part, int state, int x, int y, int width, int height) {
        GC gc = new GC((Drawable)this.parent);
        gc.dispose();
        int borderTop = 1;
        int borderBottom = 1;
        int marginWidth = this.parent.marginWidth;
        int marginHeight = this.parent.marginHeight;
        int sideDropWidth = this.shadowEnabled ? 3 : 0;
        switch (part) {
            case -1: {
                x = x - marginWidth - 1 - 0 - sideDropWidth - this.cornerSize / 2;
                width = width + 2 + 0 + 2 * marginWidth + 2 * sideDropWidth + this.cornerSize;
                int tabHeight = this.parent.getTabHeight() + 1;
                if (this.parent.getMinimized()) {
                    y = y - tabHeight - borderTop - 5;
                    height = borderTop + borderBottom + tabHeight;
                    break;
                }
                y = y - marginHeight - tabHeight - borderTop - this.cornerSize / 4;
                height = height + borderBottom + borderTop + 2 * marginHeight + tabHeight + this.cornerSize / 2 + this.cornerSize / 4 + (this.shadowEnabled ? 4 : 0);
                break;
            }
            case -2: {
                x = x - 1 - sideDropWidth;
                width += 2 * (1 + sideDropWidth);
                break;
            }
            case -3: {
                x = x - 0 - 1 - sideDropWidth - this.cornerSize / 4;
                width = width + 2 * (1 + sideDropWidth) + this.cornerSize / 2;
                y -= borderTop;
                height = height + borderTop + borderBottom;
                break;
            }
            default: {
                if (part < 0 || part >= this.parent.getItemCount()) break;
                x -= 4;
                width = width + 4 + 4 + 1;
                y -= 2;
                height = height + 2 + 6;
            }
        }
        return new Rectangle(x, y, width, height);
    }

    protected void dispose() {
        super.dispose();
    }

    protected void draw(int part, int state, Rectangle bounds, GC gc) {
        switch (part) {
            case -1: {
                this.drawTabBody(gc, bounds, state);
                return;
            }
            case -2: {
                this.drawTabHeader(gc, bounds, state);
                return;
            }
        }
        if (part >= 0 && part < this.parent.getItemCount()) {
            if (bounds.width == 0 || bounds.height == 0) {
                return;
            }
            if ((state & 2) != 0) {
                this.drawSelectedTab(part, gc, bounds, state);
                super.draw(part, state &= 0xFFFFFFF7, bounds, gc);
            } else {
                this.drawUnselectedTab(part, gc, bounds, state);
                if ((state & 0x20) == 0 && !this.active) {
                    gc.setAdvanced(true);
                    gc.setAlpha(127);
                    super.draw(part, state &= 0xFFFFFFF7, bounds, gc);
                    gc.setAdvanced(false);
                } else {
                    super.draw(part, state &= 0xFFFFFFF7, bounds, gc);
                }
            }
            return;
        }
        super.draw(part, state, bounds, gc);
    }

    void drawTabHeader(GC gc, Rectangle bounds, int state) {
        int[] points = new int[1024];
        int index = 0;
        int radius = this.cornerSize / 2;
        int marginWidth = this.parent.marginWidth;
        int marginHeight = this.parent.marginHeight;
        int delta = 1 + 2 * (this.shadowEnabled ? 3 : 0) + 2 * marginWidth;
        int width = bounds.width - delta;
        int height = bounds.height - 0 - 1 - 2 * marginHeight - (this.shadowEnabled ? 4 : 0);
        int circX = bounds.x + delta / 2 + radius;
        int circY = bounds.y + radius;
        Region clipping = new Region();
        gc.getClipping(clipping);
        Region region = new Region();
        region.add(shape);
        region.intersect(clipping);
        gc.setClipping(region);
        int header = 3;
        Rectangle trim = this.computeTrim(-2, state, 0, 0, 0, 0);
        trim.width = bounds.width - trim.width;
        trim.height = this.parent.getTabHeight() + 1 + header - trim.height;
        trim.x = -trim.x;
        trim.y = -trim.y;
        this.draw(-4, 0, trim, gc);
        gc.setClipping(clipping);
        clipping.dispose();
        region.dispose();
        int[] ltt = CTabRendering.drawCircle(circX + 1, circY + 1, radius, 0);
        System.arraycopy(ltt, 0, points, index, ltt.length);
        int[] lbb = CTabRendering.drawCircle(circX + 1, circY + height - radius * 2 - 2, radius, 1);
        System.arraycopy(lbb, 0, points, index += ltt.length, lbb.length);
        int[] rb = CTabRendering.drawCircle(circX + width - radius * 2 - 2, circY + height - radius * 2 - 2, radius, 3);
        System.arraycopy(rb, 0, points, index += lbb.length, rb.length);
        int[] rt = CTabRendering.drawCircle(circX + width - radius * 2 - 2, circY + 1, radius, 2);
        System.arraycopy(rt, 0, points, index += rb.length, rt.length);
        index += rt.length;
        points[index++] = points[0];
        points[index++] = points[1];
        int[] tempPoints = new int[index];
        System.arraycopy(points, 0, tempPoints, 0, index);
        if (this.outerKeyline == null) {
            this.outerKeyline = gc.getDevice().getSystemColor(2);
        }
        gc.setForeground(this.outerKeyline);
        gc.drawPolyline(shape);
    }

    void drawTabBody(GC gc, Rectangle bounds, int state) {
        int[] points = new int[1024];
        int index = 0;
        int radius = this.cornerSize / 2;
        int marginWidth = this.parent.marginWidth;
        int marginHeight = this.parent.marginHeight;
        int delta = 1 + 2 * (this.shadowEnabled ? 3 : 0) + 2 * marginWidth;
        int width = bounds.width - delta;
        int height = Math.max(this.parent.getTabHeight() + 0 + 1 + (this.shadowEnabled ? 4 : 0), bounds.height - 0 - 1 - 2 * marginHeight - (this.shadowEnabled ? 4 : 0));
        int circX = bounds.x + delta / 2 + radius;
        int circY = bounds.y + radius;
        index = 0;
        int[] ltt = CTabRendering.drawCircle(circX, circY, radius, 0);
        System.arraycopy(ltt, 0, points, index, ltt.length);
        int[] lbb = CTabRendering.drawCircle(circX, circY + height - radius * 2, radius, 1);
        System.arraycopy(lbb, 0, points, index += ltt.length, lbb.length);
        int[] rb = CTabRendering.drawCircle(circX + width - radius * 2, circY + height - radius * 2, radius, 3);
        System.arraycopy(rb, 0, points, index += lbb.length, rb.length);
        int[] rt = CTabRendering.drawCircle(circX + width - radius * 2, circY, radius, 2);
        System.arraycopy(rt, 0, points, index += rb.length, rt.length);
        index += rt.length;
        points[index++] = circX;
        points[index++] = circY - radius;
        int[] tempPoints = new int[index];
        System.arraycopy(points, 0, tempPoints, 0, index);
        shape = tempPoints;
        gc.fillPolygon(shape);
        Region r = new Region();
        r.add(bounds);
        r.subtract(shape);
        gc.setBackground(this.parent.getParent().getBackground());
        Display display = this.parent.getDisplay();
        Region clipping = new Region();
        gc.getClipping(clipping);
        r.intersect(clipping);
        gc.setClipping(r);
        Rectangle mappedBounds = display.map((Control)this.parent, (Control)this.parent.getParent(), bounds);
        this.parent.getParent().drawBackground(gc, bounds.x, bounds.y, bounds.width, bounds.height, mappedBounds.x, mappedBounds.y);
        if (this.shadowEnabled) {
            this.drawShadow(display, bounds, gc);
        }
        gc.setClipping(clipping);
        clipping.dispose();
        r.dispose();
    }

    void drawSelectedTab(int itemIndex, GC gc, Rectangle bounds, int state) {
        int selectionY2;
        int selectionX2;
        int selectionY1;
        int selectionX1;
        int width = bounds.width;
        int[] points = new int[1024];
        int index = 0;
        int radius = this.cornerSize / 2;
        int circX = bounds.x + radius;
        int circY = bounds.y - 1 + radius;
        if (itemIndex == 0) {
            points[index++] = --circX - radius;
            points[index++] = bounds.y + bounds.height;
            points[index++] = selectionX1 = circX - radius;
            points[index++] = selectionY1 = bounds.y + bounds.height;
        } else {
            points[index++] = this.shadowEnabled ? 3 : 1;
            points[index++] = bounds.y + bounds.height;
            points[index++] = selectionX1 = bounds.x;
            points[index++] = selectionY1 = bounds.y + bounds.height;
        }
        int[] ltt = CTabRendering.drawCircle(circX, circY, radius, 0);
        int i = 0;
        while (i < ltt.length / 2) {
            int tmp = ltt[i];
            ltt[i] = ltt[ltt.length - i - 2];
            ltt[ltt.length - i - 2] = tmp;
            tmp = ltt[i + 1];
            ltt[i + 1] = ltt[ltt.length - i - 1];
            ltt[ltt.length - i - 1] = tmp;
            i += 2;
        }
        System.arraycopy(ltt, 0, points, index, ltt.length);
        index += ltt.length;
        int[] rt = CTabRendering.drawCircle(circX + width - radius * 2, circY, radius, 2);
        int i2 = 0;
        while (i2 < rt.length / 2) {
            int tmp = rt[i2];
            rt[i2] = rt[rt.length - i2 - 2];
            rt[rt.length - i2 - 2] = tmp;
            tmp = rt[i2 + 1];
            rt[i2 + 1] = rt[rt.length - i2 - 1];
            rt[rt.length - i2 - 1] = tmp;
            i2 += 2;
        }
        System.arraycopy(rt, 0, points, index, rt.length);
        index += rt.length;
        points[index++] = selectionX2 = bounds.width + circX - radius;
        points[index++] = selectionY2 = bounds.y + bounds.height;
        points[index++] = this.parent.getSize().x - (this.shadowEnabled ? 3 : 1);
        points[index++] = bounds.y + bounds.height;
        gc.setClipping(0, bounds.y, this.parent.getSize().x - (this.shadowEnabled ? 3 : 1), bounds.y + bounds.height);
        Color selectionFillColor = gc.getDevice().getSystemColor(1);
        gc.setBackground(selectionFillColor);
        gc.setForeground(selectionFillColor);
        int[] tmpPoints = new int[index];
        System.arraycopy(points, 0, tmpPoints, 0, index);
        gc.fillPolygon(tmpPoints);
        gc.drawLine(selectionX1, selectionY1, selectionX2, selectionY2);
        Color tempBorder = new Color(gc.getDevice(), 182, 188, 204);
        gc.setForeground(tempBorder);
        tempBorder.dispose();
        if (this.active) {
            gc.drawPolyline(tmpPoints);
        }
        Rectangle rect = null;
        gc.setClipping(rect);
        if (this.outerKeyline == null) {
            this.outerKeyline = gc.getDevice().getSystemColor(2);
        }
        gc.setForeground(this.outerKeyline);
        gc.drawPolyline(shape);
    }

    void drawUnselectedTab(int itemIndex, GC gc, Rectangle bounds, int state) {
        if ((state & 0x20) != 0) {
            int width = bounds.width;
            int[] points = new int[1024];
            int[] inactive = new int[8];
            int index = 0;
            int inactive_index = 0;
            int radius = this.cornerSize / 2;
            int circX = bounds.x + radius;
            int circY = bounds.y - 1 + radius;
            int leftIndex = circX;
            if (itemIndex == 0) {
                if (this.parent.getSelectionIndex() != 0) {
                    --leftIndex;
                }
                points[index++] = leftIndex - radius;
                points[index++] = bounds.y + bounds.height;
            } else {
                points[index++] = bounds.x;
                points[index++] = bounds.y + bounds.height;
            }
            if (!this.active) {
                System.arraycopy(points, 0, inactive, 0, index);
                inactive_index += 2;
            }
            int[] ltt = CTabRendering.drawCircle(leftIndex, circY, radius, 0);
            int i = 0;
            while (i < ltt.length / 2) {
                int tmp = ltt[i];
                ltt[i] = ltt[ltt.length - i - 2];
                ltt[ltt.length - i - 2] = tmp;
                tmp = ltt[i + 1];
                ltt[i + 1] = ltt[ltt.length - i - 1];
                ltt[ltt.length - i - 1] = tmp;
                i += 2;
            }
            System.arraycopy(ltt, 0, points, index, ltt.length);
            index += ltt.length;
            if (!this.active) {
                System.arraycopy(ltt, 0, inactive, inactive_index, 2);
                inactive_index += 2;
            }
            int rightIndex = circX - 1;
            int[] rt = CTabRendering.drawCircle(rightIndex + width - radius * 2, circY, radius, 2);
            int i2 = 0;
            while (i2 < rt.length / 2) {
                int tmp = rt[i2];
                rt[i2] = rt[rt.length - i2 - 2];
                rt[rt.length - i2 - 2] = tmp;
                tmp = rt[i2 + 1];
                rt[i2 + 1] = rt[rt.length - i2 - 1];
                rt[rt.length - i2 - 1] = tmp;
                i2 += 2;
            }
            System.arraycopy(rt, 0, points, index, rt.length);
            index += rt.length;
            if (!this.active) {
                System.arraycopy(rt, rt.length - 4, inactive, inactive_index, 2);
                int n = inactive_index;
                inactive[n] = inactive[n] - 1;
                inactive_index += 2;
            }
            points[index++] = bounds.width + rightIndex - radius;
            points[index++] = bounds.y + bounds.height;
            if (!this.active) {
                System.arraycopy(points, index - 2, inactive, inactive_index, 2);
                int n = inactive_index;
                inactive[n] = inactive[n] - 1;
                inactive_index += 2;
            }
            gc.setClipping(points[0], bounds.y, this.parent.getSize().x - (this.shadowEnabled ? 3 : 1), bounds.y + bounds.height);
            gc.setBackground(gc.getDevice().getSystemColor(1));
            int[] tmpPoints = new int[index];
            System.arraycopy(points, 0, tmpPoints, 0, index);
            gc.fillPolygon(tmpPoints);
            Color tempBorder = new Color(gc.getDevice(), 182, 188, 204);
            gc.setForeground(tempBorder);
            tempBorder.dispose();
            if (this.active) {
                gc.drawPolyline(tmpPoints);
            } else {
                gc.drawLine(inactive[0], inactive[1], inactive[2], inactive[3]);
                gc.drawLine(inactive[4], inactive[5], inactive[6], inactive[7]);
            }
            Rectangle rect = null;
            gc.setClipping(rect);
            if (this.outerKeyline == null) {
                this.outerKeyline = gc.getDevice().getSystemColor(2);
            }
        }
    }

    static int[] drawCircle(int xC, int yC, int r, int circlePart) {
        int x = 0;
        int y = r;
        int u = 1;
        int v = 2 * r - 1;
        int e = 0;
        int[] points = new int[1024];
        int[] pointsMirror = new int[1024];
        int loop = 0;
        int loopMirror = 0;
        while (x < y) {
            if (circlePart == 3) {
                points[loop++] = xC + x;
                points[loop++] = yC + y;
            }
            if (circlePart == 2) {
                points[loop++] = xC + y;
                points[loop++] = yC - x;
            }
            if (circlePart == 0) {
                points[loop++] = xC - x;
                points[loop++] = yC - y;
            }
            if (circlePart == 1) {
                points[loop++] = xC - y;
                points[loop++] = yC + x;
            }
            ++x;
            if (v < 2 * (e += (u += 2))) {
                --y;
                e -= v;
                v -= 2;
            }
            if (x > y) break;
            if (circlePart == 3) {
                pointsMirror[loopMirror++] = xC + y;
                pointsMirror[loopMirror++] = yC + x;
            }
            if (circlePart == 2) {
                pointsMirror[loopMirror++] = xC + x;
                pointsMirror[loopMirror++] = yC - y;
            }
            if (circlePart == 0) {
                pointsMirror[loopMirror++] = xC - y;
                pointsMirror[loopMirror++] = yC - x;
            }
            if (circlePart == 1) {
                pointsMirror[loopMirror++] = xC - x;
                pointsMirror[loopMirror++] = yC + y;
            }
            if (loop + 1 <= points.length) continue;
            int length = points.length * 2;
            int[] newPointTable = new int[length];
            int[] newPointTableMirror = new int[length];
            System.arraycopy(points, 0, newPointTable, 0, points.length);
            points = newPointTable;
            System.arraycopy(pointsMirror, 0, newPointTableMirror, 0, pointsMirror.length);
            pointsMirror = newPointTableMirror;
        }
        int[] finalArray = new int[loop + loopMirror];
        System.arraycopy(points, 0, finalArray, 0, loop);
        int i = loopMirror - 1;
        int j = loop;
        while (i > 0) {
            int tempX;
            int tempY = pointsMirror[i];
            finalArray[j] = tempX = pointsMirror[i - 1];
            finalArray[j + 1] = tempY;
            i -= 2;
            j += 2;
        }
        return finalArray;
    }

    void drawShadow(Display display, Rectangle bounds, GC gc) {
        if (this.shadowImage == null) {
            this.createShadow(display);
        }
        int x = bounds.x;
        int y = bounds.y;
        int SIZE = this.shadowImage.getBounds().width / 3;
        int height = Math.max(bounds.height, SIZE * 2);
        int width = Math.max(bounds.width, SIZE * 2);
        gc.drawImage(this.shadowImage, 0, 0, SIZE, SIZE, 2, 10, SIZE, 20);
        int fillHeight = height - SIZE * 2;
        int fillWidth = width + 5 - SIZE * 2;
        int xFill = 0;
        int i = SIZE;
        while (i < fillHeight) {
            xFill = i;
            gc.drawImage(this.shadowImage, 0, SIZE, SIZE, SIZE, 2, i, SIZE, SIZE);
            i += SIZE;
        }
        gc.drawImage(this.shadowImage, 0, SIZE, SIZE, fillHeight - xFill, 2, xFill + SIZE, SIZE, fillHeight - xFill);
        gc.drawImage(this.shadowImage, 0, 40, 20, 20, 2, y + height - SIZE, 20, 20);
        int yFill = 0;
        int i2 = SIZE;
        while (i2 <= fillWidth) {
            yFill = i2;
            gc.drawImage(this.shadowImage, SIZE, SIZE * 2, SIZE, SIZE, i2, y + height - SIZE, SIZE, SIZE);
            i2 += SIZE;
        }
        gc.drawImage(this.shadowImage, SIZE, SIZE * 2, fillWidth - yFill, SIZE, yFill + SIZE, y + height - SIZE, fillWidth - yFill, SIZE);
        gc.drawImage(this.shadowImage, SIZE * 2, SIZE * 2, SIZE, SIZE, x + width - SIZE - 1, y + height - SIZE, SIZE, SIZE);
        gc.drawImage(this.shadowImage, SIZE * 2, 0, SIZE, SIZE, x + width - SIZE - 1, 10, SIZE, SIZE);
        xFill = 0;
        i2 = SIZE;
        while (i2 < fillHeight) {
            xFill = i2;
            gc.drawImage(this.shadowImage, SIZE * 2, SIZE, SIZE, SIZE, x + width - SIZE - 1, i2, SIZE, SIZE);
            i2 += SIZE;
        }
        gc.drawImage(this.shadowImage, SIZE * 2, SIZE, SIZE, fillHeight - xFill, x + width - SIZE - 1, xFill + SIZE, SIZE, fillHeight - xFill);
    }

    void createShadow(final Display display) {
        Object obj = display.getData(E4_SHADOW_IMAGE);
        if (obj != null) {
            this.shadowImage = (Image)obj;
        } else {
            ImageData data = new ImageData(60, 60, 32, new PaletteData(0xFF0000, 65280, 255));
            Image tmpImage = this.shadowImage = new Image((Device)display, data);
            GC gc = new GC((Drawable)tmpImage);
            Color shadowColor = new Color((Device)display, new RGB(128, 128, 128));
            gc.setBackground(shadowColor);
            this.drawTabBody(gc, new Rectangle(0, 0, 60, 60), 0);
            ImageData blured = this.blur(tmpImage, 5, 25);
            this.shadowImage = new Image((Device)display, blured);
            display.setData(E4_SHADOW_IMAGE, (Object)this.shadowImage);
            tmpImage.dispose();
            shadowColor.dispose();
            display.disposeExec(new Runnable(){

                public void run() {
                    Object obj = display.getData(CTabRendering.E4_SHADOW_IMAGE);
                    if (obj != null) {
                        Image tmp = (Image)obj;
                        tmp.dispose();
                        display.setData(CTabRendering.E4_SHADOW_IMAGE, null);
                    }
                }
            });
        }
    }

    void createActiveToolbarImages(final Display display) {
        Object active = display.getData(E4_TOOLBAR_ACTIVE_IMAGE);
        if (active != null) {
            this.toolbarActiveImage = (Image)active;
        } else {
            if (this.activeToolbar == null || this.activePercents == null) {
                return;
            }
            int width = 5;
            int height = this.parent.getTabHeight() + 4;
            int x = 0;
            int y = -1;
            this.toolbarActiveImage = new Image((Device)display, width, 30);
            GC gc = new GC((Drawable)this.toolbarActiveImage);
            Color lastColor = this.activeToolbar[0];
            if (lastColor == null) {
                lastColor = this.parent.getBackground();
            }
            int pos = 0;
            int i = 0;
            while (i < this.activePercents.length) {
                gc.setForeground(lastColor);
                lastColor = this.activeToolbar[i + 1];
                if (lastColor == null) {
                    lastColor = this.parent.getBackground();
                }
                gc.setBackground(lastColor);
                int percentage = i > 0 ? this.activePercents[i] - this.activePercents[i - 1] : this.activePercents[i];
                int gradientHeight = percentage * height / 100;
                gc.fillGradientRectangle(x, y + pos, width, gradientHeight, true);
                pos += gradientHeight;
                ++i;
            }
            if (pos < height) {
                gc.setBackground(this.parent.getBackground());
                gc.fillRectangle(x, pos, width, height - pos + 1);
            }
            gc.dispose();
            display.setData(E4_TOOLBAR_ACTIVE_IMAGE, (Object)this.toolbarActiveImage);
            display.disposeExec(new Runnable(){

                public void run() {
                    Object obj = display.getData(CTabRendering.E4_TOOLBAR_ACTIVE_IMAGE);
                    if (obj != null) {
                        Image tmp = (Image)obj;
                        tmp.dispose();
                        display.setData(CTabRendering.E4_TOOLBAR_ACTIVE_IMAGE, null);
                    }
                }
            });
        }
    }

    void createInactiveToolbarImages(final Display display) {
        Object inactive = display.getData(E4_TOOLBAR_INACTIVE_IMAGE);
        if (inactive != null) {
            this.toolbarInactiveImage = (Image)inactive;
        } else {
            if (this.inactiveToolbar == null || this.inactivePercents == null) {
                return;
            }
            int width = 5;
            int height = this.parent.getTabHeight() + 4;
            int x = 0;
            int y = -4;
            this.toolbarInactiveImage = new Image((Device)display, 5, 30);
            GC gc = new GC((Drawable)this.toolbarInactiveImage);
            Color lastColor = this.inactiveToolbar[0];
            if (lastColor == null) {
                lastColor = this.parent.getBackground();
            }
            int pos = 0;
            int i = 0;
            while (i < this.inactivePercents.length) {
                gc.setForeground(lastColor);
                lastColor = this.inactiveToolbar[i + 1];
                if (lastColor == null) {
                    lastColor = this.parent.getBackground();
                }
                gc.setBackground(lastColor);
                int percentage = i > 0 ? this.inactivePercents[i] - this.inactivePercents[i - 1] : this.inactivePercents[i];
                int gradientHeight = percentage * height / 100;
                gc.fillGradientRectangle(x, y + pos, width, gradientHeight, true);
                pos += gradientHeight;
                ++i;
            }
            if (pos < height) {
                gc.setBackground(this.parent.getBackground());
                gc.fillRectangle(x, pos, width, height - pos + 1);
            }
            gc.dispose();
            display.setData(E4_TOOLBAR_INACTIVE_IMAGE, (Object)this.toolbarInactiveImage);
            display.disposeExec(new Runnable(){

                public void run() {
                    Object obj = display.getData(CTabRendering.E4_TOOLBAR_INACTIVE_IMAGE);
                    if (obj != null) {
                        Image tmp = (Image)obj;
                        tmp.dispose();
                        display.setData(CTabRendering.E4_TOOLBAR_INACTIVE_IMAGE, null);
                    }
                }
            });
        }
    }

    public ImageData blur(Image src, int radius, int sigma) {
        float[] kernel = this.create1DKernel(radius, sigma);
        ImageData imgPixels = src.getImageData();
        int width = imgPixels.width;
        int height = imgPixels.height;
        int[] inPixels = new int[width * height];
        int[] outPixels = new int[width * height];
        int offset = 0;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                RGB rgb = imgPixels.palette.getRGB(imgPixels.getPixel(x, y));
                inPixels[offset] = rgb.red == 255 && rgb.green == 255 && rgb.blue == 255 ? rgb.red << 16 | rgb.green << 8 | rgb.blue : imgPixels.getAlpha(x, y) << 24 | rgb.red << 16 | rgb.green << 8 | rgb.blue;
                ++offset;
                ++x;
            }
            ++y;
        }
        this.convolve(kernel, inPixels, outPixels, width, height, true);
        this.convolve(kernel, outPixels, inPixels, height, width, true);
        ImageData dst = new ImageData(imgPixels.width, imgPixels.height, 24, new PaletteData(0xFF0000, 65280, 255));
        dst.setPixels(0, 0, inPixels.length, inPixels, 0);
        offset = 0;
        int y2 = 0;
        while (y2 < height) {
            int x = 0;
            while (x < width) {
                if (inPixels[offset] == -1) {
                    dst.setAlpha(x, y2, 0);
                } else {
                    int a = inPixels[offset] >> 24 & 0xFF;
                    dst.setAlpha(x, y2, a);
                }
                ++offset;
                ++x;
            }
            ++y2;
        }
        return dst;
    }

    private void convolve(float[] kernel, int[] inPixels, int[] outPixels, int width, int height, boolean alpha) {
        int kernelWidth = kernel.length;
        int kernelMid = kernelWidth / 2;
        int y = 0;
        while (y < height) {
            int index = y;
            int currentLine = y * width;
            int x = 0;
            while (x < width) {
                float a = 0.0f;
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                int k = -kernelMid;
                while (k <= kernelMid) {
                    float val = kernel[k + kernelMid];
                    int xcoord = x + k;
                    if (xcoord < 0) {
                        xcoord = 0;
                    }
                    if (xcoord >= width) {
                        xcoord = width - 1;
                    }
                    int pixel = inPixels[currentLine + xcoord];
                    a += val * (float)(pixel >> 24 & 0xFF);
                    r += val * (float)(pixel >> 16 & 0xFF);
                    g += val * (float)(pixel >> 8 & 0xFF);
                    b += val * (float)(pixel & 0xFF);
                    ++k;
                }
                int ia = alpha ? this.clamp((int)((double)a + 0.5)) : 255;
                int ir = this.clamp((int)((double)r + 0.5));
                int ig = this.clamp((int)((double)g + 0.5));
                int ib = this.clamp((int)((double)b + 0.5));
                outPixels[index] = ia << 24 | ir << 16 | ig << 8 | ib;
                index += height;
                ++x;
            }
            ++y;
        }
    }

    private int clamp(int value) {
        if (value > 255) {
            return 255;
        }
        if (value < 0) {
            return 0;
        }
        return value;
    }

    private float[] create1DKernel(int radius, int sigma) {
        int size = radius * 2 + 1;
        float[] kernel = new float[size];
        int radiusSquare = radius * radius;
        float sigmaSquare = 2 * sigma * sigma;
        float piSigma = (float)Math.PI * 2 * (float)sigma;
        float sqrtSigmaPi2 = (float)Math.sqrt(piSigma);
        int start = size / 2;
        int index = 0;
        float total = 0.0f;
        int i = -start;
        while (i <= start) {
            float d = i * i;
            kernel[index] = d > (float)radiusSquare ? 0.0f : (float)Math.exp(-d / sigmaSquare) / sqrtSigmaPi2;
            total += kernel[index];
            ++index;
            ++i;
        }
        i = 0;
        while (i < size) {
            int n = i++;
            kernel[n] = kernel[n] / total;
        }
        return kernel;
    }

    @Inject
    @Optional
    public void setCornerRadius(@Named(value="radius") Integer radius) {
        this.cornerSize = radius;
        this.parent.redraw();
    }

    @Inject
    @Optional
    public void setShadowVisible(@Named(value="shadowVisible") Boolean visible) {
        this.shadowEnabled = visible;
        this.parent.redraw();
    }

    @Inject
    @Optional
    public void setOuterKeyline(@Named(value="outerKeyline") Color color) {
        this.outerKeyline = color;
        this.setActive(color.getRed() != 255 || color.getGreen() != 255 || color.getBlue() != 255);
        this.parent.redraw();
    }

    @Inject
    @Optional
    public void setInnerKeyline(@Named(value="innerKeyline") Color color) {
        this.innerKeyline = color;
        this.parent.redraw();
    }

    @Inject
    @Optional
    public void setActiveToolbarGradient(@Named(value="activeToolbarColors") Color[] color, @Named(value="activeToolbarPercents") int[] percents) {
        this.activeToolbar = color;
        this.activePercents = percents;
    }

    @Inject
    @Optional
    public void setInactiveToolbarGradient(@Named(value="inactiveToolbarColors") Color[] color, @Named(value="inactiveToolbarPercents") int[] percents) {
        this.inactiveToolbar = color;
        this.inactivePercents = percents;
    }

    public void setActive(boolean active) {
        this.active = active;
        Control topRight = this.parent.getTopRight();
        if (topRight != null) {
            if (active && this.toolbarActiveImage == null) {
                this.createActiveToolbarImages(Display.getCurrent());
            }
            if (!active && this.toolbarInactiveImage == null) {
                this.createInactiveToolbarImages(Display.getCurrent());
            }
            topRight.setBackgroundImage(active ? this.toolbarActiveImage : this.toolbarInactiveImage);
            this.parent.redraw();
        }
    }
}

