/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.ui.workbench.modeling.ModelDelta;
import org.eclipse.e4.ui.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerParameterTest
extends ModelReconcilerTest {
    private void testHandledToolItem_Parameters_Name(String before, String after) {
        MApplication application = this.createApplication();
        MCommand command = CommandsFactoryImpl.eINSTANCE.createCommand();
        application.getCommands().add(command);
        MWindow window = this.createWindow(application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        part.setToolbar(toolBar);
        MHandledToolItem handledToolItem = MenuFactoryImpl.eINSTANCE.createHandledToolItem();
        toolBar.getChildren().add(handledToolItem);
        MParameter parameter = CommandsFactoryImpl.eINSTANCE.createParameter();
        parameter.setName(before);
        handledToolItem.getParameters().add(parameter);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        parameter.setName(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        command = (MCommand)application.getCommands().get(0);
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        toolBar = part.getToolbar();
        handledToolItem = (MHandledToolItem)toolBar.getChildren().get(0);
        parameter = (MParameter)handledToolItem.getParameters().get(0);
        ModelReconcilerParameterTest.assertEquals((String)before, (String)parameter.getName());
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerParameterTest.assertEquals((String)before, (String)parameter.getName());
        this.applyAll(deltas);
        ModelReconcilerParameterTest.assertEquals((String)after, (String)parameter.getName());
    }

    public void testHandledToolItem_Parameters_Name_NullNull() {
        this.testHandledToolItem_Parameters_Name(null, null);
    }

    public void testHandledToolItem_Parameters_Name_NullEmpty() {
        this.testHandledToolItem_Parameters_Name(null, "");
    }

    public void testHandledToolItem_Parameters_Name_NullString() {
        this.testHandledToolItem_Parameters_Name(null, "name");
    }

    public void testHandledToolItem_Parameters_Name_EmptyNull() {
        this.testHandledToolItem_Parameters_Name("", null);
    }

    public void testHandledToolItem_Parameters_Name_EmptyEmpty() {
        this.testHandledToolItem_Parameters_Name("", "");
    }

    public void testHandledToolItem_Parameters_Name_EmptyString() {
        this.testHandledToolItem_Parameters_Name("", "name");
    }

    public void testHandledToolItem_Parameters_Name_StringNull() {
        this.testHandledToolItem_Parameters_Name("name", null);
    }

    public void testHandledToolItem_Parameters_Name_StringEmpty() {
        this.testHandledToolItem_Parameters_Name("name", "");
    }

    public void testHandledToolItem_Parameters_Name_StringStringUnchanged() {
        this.testHandledToolItem_Parameters_Name("name", "name");
    }

    public void testHandledToolItem_Parameters_Name_StringStringChanged() {
        this.testHandledToolItem_Parameters_Name("name", "name2");
    }

    private void testHandledToolItem_Parameters_Value(String before, String after) {
        MApplication application = this.createApplication();
        MCommand command = CommandsFactoryImpl.eINSTANCE.createCommand();
        application.getCommands().add(command);
        MWindow window = this.createWindow(application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        part.setToolbar(toolBar);
        MHandledToolItem handledToolItem = MenuFactoryImpl.eINSTANCE.createHandledToolItem();
        toolBar.getChildren().add(handledToolItem);
        MParameter parameter = CommandsFactoryImpl.eINSTANCE.createParameter();
        parameter.setValue(before);
        handledToolItem.getParameters().add(parameter);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        parameter.setValue(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        command = (MCommand)application.getCommands().get(0);
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        toolBar = part.getToolbar();
        handledToolItem = (MHandledToolItem)toolBar.getChildren().get(0);
        parameter = (MParameter)handledToolItem.getParameters().get(0);
        ModelReconcilerParameterTest.assertEquals((String)before, (String)parameter.getValue());
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerParameterTest.assertEquals((String)before, (String)parameter.getValue());
        this.applyAll(deltas);
        ModelReconcilerParameterTest.assertEquals((String)after, (String)parameter.getValue());
    }

    public void testHandledToolItem_Parameters_Value_NullNull() {
        this.testHandledToolItem_Parameters_Value(null, null);
    }

    public void testHandledToolItem_Parameters_Value_NullEmpty() {
        this.testHandledToolItem_Parameters_Value(null, "");
    }

    public void testHandledToolItem_Parameters_Value_NullString() {
        this.testHandledToolItem_Parameters_Value(null, "name");
    }

    public void testHandledToolItem_Parameters_Value_EmptyNull() {
        this.testHandledToolItem_Parameters_Value("", null);
    }

    public void testHandledToolItem_Parameters_Value_EmptyEmpty() {
        this.testHandledToolItem_Parameters_Value("", "");
    }

    public void testHandledToolItem_Parameters_Value_EmptyString() {
        this.testHandledToolItem_Parameters_Value("", "name");
    }

    public void testHandledToolItem_Parameters_Value_StringNull() {
        this.testHandledToolItem_Parameters_Value("name", null);
    }

    public void testHandledToolItem_Parameters_Value_StringEmpty() {
        this.testHandledToolItem_Parameters_Value("name", "");
    }

    public void testHandledToolItem_Parameters_Value_StringStringUnchanged() {
        this.testHandledToolItem_Parameters_Value("name", "name");
    }

    public void testHandledToolItem_Parameters_Value_StringStringChanged() {
        this.testHandledToolItem_Parameters_Value("name", "name2");
    }

    private void testHandledMenuItem_Parameters_Name(String before, String after) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        window.setMainMenu(menu);
        MHandledMenuItem handledMenuItem = MenuFactoryImpl.eINSTANCE.createHandledMenuItem();
        menu.getChildren().add(handledMenuItem);
        MParameter parameter = CommandsFactoryImpl.eINSTANCE.createParameter();
        parameter.setName(before);
        handledMenuItem.getParameters().add(parameter);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        parameter.setName(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        menu = window.getMainMenu();
        handledMenuItem = (MHandledMenuItem)menu.getChildren().get(0);
        parameter = (MParameter)handledMenuItem.getParameters().get(0);
        ModelReconcilerParameterTest.assertEquals((int)1, (int)handledMenuItem.getParameters().size());
        ModelReconcilerParameterTest.assertEquals((Object)parameter, handledMenuItem.getParameters().get(0));
        ModelReconcilerParameterTest.assertEquals((String)before, (String)parameter.getName());
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerParameterTest.assertEquals((int)1, (int)handledMenuItem.getParameters().size());
        ModelReconcilerParameterTest.assertEquals((Object)parameter, handledMenuItem.getParameters().get(0));
        ModelReconcilerParameterTest.assertEquals((String)before, (String)parameter.getName());
        this.applyAll(deltas);
        ModelReconcilerParameterTest.assertEquals((int)1, (int)handledMenuItem.getParameters().size());
        ModelReconcilerParameterTest.assertEquals((Object)parameter, handledMenuItem.getParameters().get(0));
        ModelReconcilerParameterTest.assertEquals((String)after, (String)parameter.getName());
    }

    public void testHandledMenuItem_Parameters_Name_NullNull() {
        this.testHandledMenuItem_Parameters_Name(null, null);
    }

    public void testHandledMenuItem_Parameters_Name_NullEmpty() {
        this.testHandledMenuItem_Parameters_Name(null, "");
    }

    public void testHandledMenuItem_Parameters_Name_NullString() {
        this.testHandledMenuItem_Parameters_Name(null, "name");
    }

    public void testHandledMenuItem_Parameters_Name_EmptyNull() {
        this.testHandledMenuItem_Parameters_Name("", null);
    }

    public void testHandledMenuItem_Parameters_Name_EmptyEmpty() {
        this.testHandledMenuItem_Parameters_Name("", "");
    }

    public void testHandledMenuItem_Parameters_Name_EmptyString() {
        this.testHandledMenuItem_Parameters_Name("", "name");
    }

    public void testHandledMenuItem_Parameters_Name_StringNull() {
        this.testHandledMenuItem_Parameters_Name("name", null);
    }

    public void testHandledMenuItem_Parameters_Name_StringEmpty() {
        this.testHandledMenuItem_Parameters_Name("name", "");
    }

    public void testHandledMenuItem_Parameters_Name_StringStringUnchanged() {
        this.testHandledMenuItem_Parameters_Name("name", "name");
    }

    public void testHandledMenuItem_Parameters_Name_StringStringChanged() {
        this.testHandledMenuItem_Parameters_Name("name", "name2");
    }

    private void testHandledMenuItem_Parameters_Value(String before, String after) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        window.setMainMenu(menu);
        MHandledMenuItem handledMenuItem = MenuFactoryImpl.eINSTANCE.createHandledMenuItem();
        menu.getChildren().add(handledMenuItem);
        MParameter parameter = CommandsFactoryImpl.eINSTANCE.createParameter();
        parameter.setValue(before);
        handledMenuItem.getParameters().add(parameter);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        parameter.setValue(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        menu = window.getMainMenu();
        handledMenuItem = (MHandledMenuItem)menu.getChildren().get(0);
        parameter = (MParameter)handledMenuItem.getParameters().get(0);
        ModelReconcilerParameterTest.assertEquals((int)1, (int)handledMenuItem.getParameters().size());
        ModelReconcilerParameterTest.assertEquals((Object)parameter, handledMenuItem.getParameters().get(0));
        ModelReconcilerParameterTest.assertEquals((String)before, (String)parameter.getValue());
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerParameterTest.assertEquals((int)1, (int)handledMenuItem.getParameters().size());
        ModelReconcilerParameterTest.assertEquals((Object)parameter, handledMenuItem.getParameters().get(0));
        ModelReconcilerParameterTest.assertEquals((String)before, (String)parameter.getValue());
        this.applyAll(deltas);
        ModelReconcilerParameterTest.assertEquals((int)1, (int)handledMenuItem.getParameters().size());
        ModelReconcilerParameterTest.assertEquals((Object)parameter, handledMenuItem.getParameters().get(0));
        ModelReconcilerParameterTest.assertEquals((String)after, (String)parameter.getValue());
    }

    public void testHandledMenuItem_Parameters_Value_NullNull() {
        this.testHandledMenuItem_Parameters_Value(null, null);
    }

    public void testHandledMenuItem_Parameters_Value_NullEmpty() {
        this.testHandledMenuItem_Parameters_Value(null, "");
    }

    public void testHandledMenuItem_Parameters_Value_NullString() {
        this.testHandledMenuItem_Parameters_Value(null, "name");
    }

    public void testHandledMenuItem_Parameters_Value_EmptyNull() {
        this.testHandledMenuItem_Parameters_Value("", null);
    }

    public void testHandledMenuItem_Parameters_Value_EmptyEmpty() {
        this.testHandledMenuItem_Parameters_Value("", "");
    }

    public void testHandledMenuItem_Parameters_Value_EmptyString() {
        this.testHandledMenuItem_Parameters_Value("", "name");
    }

    public void testHandledMenuItem_Parameters_Value_StringNull() {
        this.testHandledMenuItem_Parameters_Value("name", null);
    }

    public void testHandledMenuItem_Parameters_Value_StringEmpty() {
        this.testHandledMenuItem_Parameters_Value("name", "");
    }

    public void testHandledMenuItem_Parameters_Value_StringStringUnchanged() {
        this.testHandledMenuItem_Parameters_Value("name", "name");
    }

    public void testHandledMenuItem_Parameters_Value_StringStringChanged() {
        this.testHandledMenuItem_Parameters_Value("name", "name2");
    }
}

