/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.ui.workbench.modeling.ModelDelta;
import org.eclipse.e4.ui.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerMenuContributionTest
extends ModelReconcilerTest {
    private void testMenuContribution_PositionInParent(String before, String after) {
        MApplication application = this.createApplication();
        MMenuContribution contribution = MenuFactoryImpl.eINSTANCE.createMenuContribution();
        application.getMenuContributions().add(contribution);
        contribution.setPositionInParent(before);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        contribution.setPositionInParent(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        contribution = (MMenuContribution)application.getMenuContributions().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerMenuContributionTest.assertEquals((int)1, (int)application.getMenuContributions().size());
        ModelReconcilerMenuContributionTest.assertEquals((Object)contribution, application.getMenuContributions().get(0));
        ModelReconcilerMenuContributionTest.assertEquals((String)before, (String)contribution.getPositionInParent());
        this.applyAll(deltas);
        ModelReconcilerMenuContributionTest.assertEquals((int)1, (int)application.getMenuContributions().size());
        ModelReconcilerMenuContributionTest.assertEquals((Object)contribution, application.getMenuContributions().get(0));
        ModelReconcilerMenuContributionTest.assertEquals((String)after, (String)contribution.getPositionInParent());
    }

    public void testMenuContribution_PositionInParent_EmptyEmpty() {
        this.testMenuContribution_PositionInParent("", "");
    }

    public void testMenuContribution_PositionInParent_EmptyString() {
        this.testMenuContribution_PositionInParent("", "id");
    }

    public void testMenuContribution_PositionInParent_StringEmpty() {
        this.testMenuContribution_PositionInParent("id", "");
    }

    public void testMenuContribution_PositionInParent_StringStringUnchanged() {
        this.testMenuContribution_PositionInParent("id", "id");
    }

    public void testMenuContribution_PositionInParent_StringStringChanged() {
        this.testMenuContribution_PositionInParent("id", "id2");
    }

    private void testMenuContribution_ParentID(String before, String after) {
        MApplication application = this.createApplication();
        MMenuContribution contribution = MenuFactoryImpl.eINSTANCE.createMenuContribution();
        application.getMenuContributions().add(contribution);
        contribution.setParentID(before);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        contribution.setParentID(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        contribution = (MMenuContribution)application.getMenuContributions().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerMenuContributionTest.assertEquals((int)1, (int)application.getMenuContributions().size());
        ModelReconcilerMenuContributionTest.assertEquals((Object)contribution, application.getMenuContributions().get(0));
        ModelReconcilerMenuContributionTest.assertEquals((String)before, (String)contribution.getParentID());
        this.applyAll(deltas);
        ModelReconcilerMenuContributionTest.assertEquals((int)1, (int)application.getMenuContributions().size());
        ModelReconcilerMenuContributionTest.assertEquals((Object)contribution, application.getMenuContributions().get(0));
        ModelReconcilerMenuContributionTest.assertEquals((String)after, (String)contribution.getParentID());
    }

    public void testMenuContribution_ParentID_NullNull() {
        this.testMenuContribution_ParentID(null, null);
    }

    public void testMenuContribution_ParentID_NullEmpty() {
        this.testMenuContribution_ParentID(null, "");
    }

    public void testMenuContribution_ParentID_NullString() {
        this.testMenuContribution_ParentID(null, "id");
    }

    public void testMenuContribution_ParentID_EmptyNull() {
        this.testMenuContribution_ParentID("", null);
    }

    public void testMenuContribution_ParentID_EmptyEmpty() {
        this.testMenuContribution_ParentID("", "");
    }

    public void testMenuContribution_ParentID_EmptyString() {
        this.testMenuContribution_ParentID("", "id");
    }

    public void testMenuContribution_ParentID_StringNull() {
        this.testMenuContribution_ParentID("id", null);
    }

    public void testMenuContribution_ParentID_StringEmpty() {
        this.testMenuContribution_ParentID("id", "");
    }

    public void testMenuContribution_ParentID_StringStringUnchanged() {
        this.testMenuContribution_ParentID("id", "id");
    }

    public void testMenuContribution_ParentID_StringStringChanged() {
        this.testMenuContribution_ParentID("id", "id2");
    }
}

