/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.swt.ResourceUtility;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindowElement;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.tests.application.HeadlessApplicationTest;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.widgets.Display;

public abstract class UIStartupTest
extends HeadlessApplicationTest {
    protected Display display;

    protected void setUp() throws Exception {
        this.display = Display.getDefault();
        super.setUp();
        while (this.display.readAndDispatch()) {
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected boolean needsActiveChildEventHandling() {
        return false;
    }

    protected String getEngineURI() {
        return "platform:/plugin/org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine";
    }

    public void testGet_ActiveChild() throws Exception {
        IEclipseContext context = this.application.getContext();
        UIStartupTest.assertNotNull((Object)context.get("activeChildContext"));
    }

    public void testGet_ActiveShell() throws Exception {
        IEclipseContext context = this.application.getContext();
        UIStartupTest.assertNull((Object)context.get("activeShell"));
    }

    public void testGet_ActivePart() throws Exception {
        IEclipseContext context = this.application.getContext();
        UIStartupTest.assertNotNull((Object)context.get("e4ActivePart"));
    }

    public void testGet_ActivePartId() throws Exception {
        IEclipseContext context = this.application.getContext();
        UIStartupTest.assertNotNull((Object)context.get("activePartId"));
    }

    public void testGet_ActiveContexts2() throws Exception {
        IEclipseContext context = UIStartupTest.getActiveChildContext(this.application);
        UIStartupTest.assertNotNull((Object)context.get("activeContexts"));
    }

    public void testGet_Selection2() throws Exception {
        IEclipseContext context = UIStartupTest.getActiveChildContext(this.application);
        UIStartupTest.assertNull((Object)context.get("selection"));
    }

    public void testGet_ActiveChild2() throws Exception {
        IEclipseContext context = UIStartupTest.getActiveChildContext(this.application);
        UIStartupTest.assertNotNull((Object)context.get("activeChildContext"));
    }

    public void testGet_ActivePart2() throws Exception {
        IEclipseContext context = UIStartupTest.getActiveChildContext(this.application);
        UIStartupTest.assertNotNull((Object)context.get("e4ActivePart"));
    }

    public void testGet_ActiveShell2() throws Exception {
        IEclipseContext context = UIStartupTest.getActiveChildContext(this.application);
        UIStartupTest.assertNull((Object)context.get("activeShell"));
    }

    public void testGet_PersistedState2() throws Exception {
        IEclipseContext context = UIStartupTest.getActiveChildContext(this.application);
        UIStartupTest.assertNull((Object)context.get("persistedState"));
    }

    public void testGetFirstPart_GetContext() {
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)this.display), (Runnable)new Runnable(){

            public void run() {
                UIStartupTest.super.testGetFirstPart_GetContext();
            }
        });
    }

    public void testGetSecondPart_GetContext() {
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)this.display), (Runnable)new Runnable(){

            public void run() {
                UIStartupTest.super.testGetSecondPart_GetContext();
            }
        });
    }

    public void test_SwitchActivePartsInContext() throws Exception {
        final IEclipseContext context = this.application.getContext();
        final MPart[] parts = this.getTwoParts();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)this.display), (Runnable)new Runnable(){

            public void run() {
                context.set("e4ActivePart", (Object)parts[0]);
                while (UIStartupTest.this.display.readAndDispatch()) {
                }
                UIStartupTest.assertEquals((Object)parts[0].getElementId(), (Object)context.get("activePartId"));
                context.set("e4ActivePart", (Object)parts[1]);
                while (UIStartupTest.this.display.readAndDispatch()) {
                }
                UIStartupTest.assertEquals((Object)parts[1].getElementId(), (Object)context.get("activePartId"));
            }
        });
    }

    public void test_SwitchActivePartsInContext2() throws Exception {
        final IEclipseContext context = UIStartupTest.getActiveChildContext(this.application);
        final MPart[] parts = this.getTwoParts();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)this.display), (Runnable)new Runnable(){

            public void run() {
                EPartService service = (EPartService)context.get(EPartService.class.getName());
                service.activate(parts[0]);
                while (UIStartupTest.this.display.readAndDispatch()) {
                }
                UIStartupTest.assertEquals((Object)parts[0].getElementId(), (Object)context.get("activePartId"));
                service.activate(parts[1]);
                while (UIStartupTest.this.display.readAndDispatch()) {
                }
                UIStartupTest.assertEquals((Object)parts[1].getElementId(), (Object)context.get("activePartId"));
            }
        });
    }

    private static MWindowElement getNonContainer(MWindowElement activeChild) {
        if (activeChild instanceof MElementContainer) {
            activeChild = (MWindowElement)((MElementContainer)activeChild).getSelectedElement();
            UIStartupTest.assertNotNull((Object)activeChild);
            activeChild = UIStartupTest.getNonContainer(activeChild);
        }
        return activeChild;
    }

    private static IEclipseContext getActiveChildContext(MApplication application) {
        MWindowElement nonContainer = UIStartupTest.getNonContainer((MWindowElement)((MWindow)application.getSelectedElement()).getSelectedElement());
        return ((MContext)nonContainer).getContext();
    }

    protected IEclipseContext createApplicationContext(final IEclipseContext osgiContext) {
        final IEclipseContext[] contexts = new IEclipseContext[1];
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)this.display), (Runnable)new Runnable(){

            public void run() {
                contexts[0] = UIStartupTest.super.createApplicationContext(osgiContext);
                contexts[0].set(IResourceUtilities.class.getName(), (Object)new ResourceUtility());
                contexts[0].set(IStylingEngine.class.getName(), (Object)new IStylingEngine(){

                    public void style(Object widget) {
                    }

                    public void setId(Object widget, String id) {
                    }

                    public void setClassname(Object widget, String classname) {
                    }
                });
            }
        });
        return contexts[0];
    }

    protected void createGUI(final MUIElement uiRoot) {
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)this.display), (Runnable)new Runnable(){

            public void run() {
                UIStartupTest.super.createGUI(uiRoot);
            }
        });
    }
}

