/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.E4XMIResource;
import org.eclipse.e4.ui.internal.workbench.ResourceHandler;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindowElement;
import org.eclipse.e4.ui.tests.application.HeadlessStartupTest;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class ResourceHandlerTest
extends HeadlessStartupTest {
    private ServiceTracker locationTracker;

    public Location getInstanceLocation() {
        if (this.locationTracker == null) {
            BundleContext context = FrameworkUtil.getBundle(ResourceHandlerTest.class).getBundleContext();
            Filter filter = null;
            try {
                filter = context.createFilter(Location.INSTANCE_FILTER);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
            this.locationTracker = new ServiceTracker(context, filter, null);
            this.locationTracker.open();
        }
        return (Location)this.locationTracker.getService();
    }

    private ResourceHandler createHandler(URI uri) {
        IEclipseContext localContext = this.applicationContext.createChild();
        localContext.set("instanceLocation", (Object)this.getInstanceLocation());
        localContext.set("saveAndRestore", (Object)true);
        localContext.set("initialWorkbenchModelURI", (Object)uri);
        return (ResourceHandler)ContextInjectionFactory.make(ResourceHandler.class, (IEclipseContext)localContext);
    }

    public void testLoadMostRecent() {
        URI uri = URI.createPlatformPluginURI((String)"org.eclipse.e4.ui.tests/xmi/InvalidContainment.e4xmi", (boolean)true);
        ResourceHandler handler = this.createHandler(uri);
        Resource resource = handler.loadMostRecentModel();
        ResourceHandlerTest.assertNotNull((Object)resource);
        ResourceHandlerTest.assertEquals(E4XMIResource.class, resource.getClass());
        this.checkData(resource);
    }

    public void testLoadBaseModel() {
        URI uri = URI.createPlatformPluginURI((String)"org.eclipse.e4.ui.tests/xmi/InvalidContainment.e4xmi", (boolean)true);
        ResourceHandler handler = this.createHandler(uri);
        Resource resource = handler.loadBaseModel();
        ResourceHandlerTest.assertNotNull((Object)resource);
        ResourceHandlerTest.assertEquals(E4XMIResource.class, resource.getClass());
        this.checkData(resource);
    }

    private void checkData(Resource resource) {
        ResourceHandlerTest.assertNotNull((Object)resource);
        ResourceHandlerTest.assertEquals((int)1, (int)resource.getContents().size());
        MApplication app = (MApplication)resource.getContents().get(0);
        ResourceHandlerTest.assertEquals((int)1, (int)app.getChildren().size());
        MWindow w = (MWindow)app.getChildren().get(0);
        ResourceHandlerTest.assertEquals((String)"window1", (String)w.getElementId());
        ResourceHandlerTest.assertEquals((int)2, (int)w.getChildren().size());
        MPartStack stack = (MPartStack)w.getChildren().get(0);
        ResourceHandlerTest.assertEquals((String)"window1.partstack1", (String)stack.getElementId());
        ResourceHandlerTest.assertEquals((int)2, (int)stack.getChildren().size());
        ResourceHandlerTest.assertEquals((String)"window1.partstack1.part1", (String)((MStackElement)stack.getChildren().get(0)).getElementId());
        ResourceHandlerTest.assertEquals((String)"window1.partstack1.inputpart1", (String)((MStackElement)stack.getChildren().get(1)).getElementId());
        stack = (MPartStack)w.getChildren().get(1);
        ResourceHandlerTest.assertEquals((String)"window1.partstack2", (String)stack.getElementId());
        ResourceHandlerTest.assertEquals((int)1, (int)stack.getChildren().size());
        ResourceHandlerTest.assertEquals((String)"window1.partstack2.part1", (String)((MStackElement)stack.getChildren().get(0)).getElementId());
    }

    public void testModelProcessor() {
        URI uri = URI.createPlatformPluginURI((String)"org.eclipse.e4.ui.tests/xmi/modelprocessor/base.e4xmi", (boolean)true);
        ResourceHandler handler = this.createHandler(uri);
        Resource resource = handler.loadMostRecentModel();
        MApplication application = (MApplication)resource.getContents().get(0);
        ResourceHandlerTest.assertNotNull((Object)application);
        ResourceHandlerTest.assertEquals((int)2, (int)application.getChildren().size());
        ResourceHandlerTest.assertEquals((String)"fragment.contributedWindow", (String)((MWindow)application.getChildren().get(1)).getElementId());
        ResourceHandlerTest.assertEquals((int)1, (int)application.getHandlers().size());
        ResourceHandlerTest.assertSame(application.getCommands().get(0), (Object)((MHandler)application.getHandlers().get(0)).getCommand());
        ResourceHandlerTest.assertEquals((int)2, (int)((MCommand)application.getCommands().get(0)).getParameters().size());
        ResourceHandlerTest.assertEquals((int)1, (int)((MWindow)application.getChildren().get(1)).getVariables().size());
        ResourceHandlerTest.assertNotNull((Object)((MWindow)application.getChildren().get(0)).getMainMenu());
        ResourceHandlerTest.assertEquals((int)8, (int)((MWindow)application.getChildren().get(0)).getChildren().size());
        ResourceHandlerTest.assertEquals((String)"fragment.contributedPosFirst", (String)((MWindowElement)((MWindow)application.getChildren().get(0)).getChildren().get(0)).getElementId());
        ResourceHandlerTest.assertEquals((String)"fragment.contributedPos1", (String)((MWindowElement)((MWindow)application.getChildren().get(0)).getChildren().get(1)).getElementId());
        ResourceHandlerTest.assertEquals((String)"fragment.contributedBeforePart1", (String)((MWindowElement)((MWindow)application.getChildren().get(0)).getChildren().get(2)).getElementId());
        ResourceHandlerTest.assertEquals((String)"fragment.contributedAfterPart1", (String)((MWindowElement)((MWindow)application.getChildren().get(0)).getChildren().get(4)).getElementId());
        ResourceHandlerTest.assertEquals((String)"fragment.contributedBeforePart2", (String)((MWindowElement)((MWindow)application.getChildren().get(0)).getChildren().get(5)).getElementId());
        ResourceHandlerTest.assertEquals((String)"fragment.contributedAfterPart2", (String)((MWindowElement)((MWindow)application.getChildren().get(0)).getChildren().get(7)).getElementId());
    }
}

