/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.internal.theme;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.engine.CSSErrorHandler;
import org.eclipse.e4.ui.css.core.util.impl.resources.OSGiResourceLocator;
import org.eclipse.e4.ui.css.core.util.resources.IResourceLocator;
import org.eclipse.e4.ui.css.swt.engine.CSSSWTEngineImpl;
import org.eclipse.e4.ui.css.swt.internal.theme.Theme;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThemeEngine
implements IThemeEngine {
    private List<Theme> themes = new ArrayList<Theme>();
    private CSSEngine engine;
    private ITheme currentTheme;
    private Display display;
    private List<String> globalStyles = new ArrayList<String>();
    private List<IResourceLocator> globalSourceLocators = new ArrayList<IResourceLocator>();
    private HashMap<String, List<String>> stylesheets = new HashMap();
    private HashMap<String, List<IResourceLocator>> sourceLocators = new HashMap();
    private static final String THEMEID_KEY = "themeid";

    public ThemeEngine(Display display) {
        IConfigurationElement ce;
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        IExtension e;
        this.engine = new CSSSWTEngineImpl(display, true);
        this.display = display;
        this.engine.setErrorHandler(new CSSErrorHandler(){

            public void error(Exception e) {
                e.printStackTrace();
            }
        });
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.e4.ui.css.swt.theme");
        IExtension[] iExtensionArray = extPoint.getExtensions();
        int n3 = iExtensionArray.length;
        int n4 = 0;
        while (n4 < n3) {
            e = iExtensionArray[n4];
            iConfigurationElementArray = this.getPlatformMatches(e.getConfigurationElements());
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                ce = iConfigurationElementArray[n];
                if (ce.getName().equals("theme")) {
                    this.registerTheme(ce.getAttribute("id"), ce.getAttribute("label"), "platform:/plugin/" + ce.getContributor().getName() + "/" + ce.getAttribute("basestylesheeturi"));
                }
                ++n;
            }
            ++n4;
        }
        iExtensionArray = extPoint.getExtensions();
        n3 = iExtensionArray.length;
        n4 = 0;
        while (n4 < n3) {
            e = iExtensionArray[n4];
            iConfigurationElementArray = this.getPlatformMatches(e.getConfigurationElements());
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                ce = iConfigurationElementArray[n];
                if (ce.getName().equals("stylesheet")) {
                    int n5;
                    IConfigurationElement[] cces = ce.getChildren(THEMEID_KEY);
                    if (cces.length == 0) {
                        this.registerStylsheet("platform:/plugin/" + ce.getContributor().getName() + "/" + ce.getAttribute("uri"), new String[0]);
                        IConfigurationElement[] iConfigurationElementArray2 = ce.getChildren("osgiresourcelocator");
                        n5 = iConfigurationElementArray2.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IConfigurationElement resourceEl = iConfigurationElementArray2[n6];
                            String uri = resourceEl.getAttribute("uri");
                            if (uri != null) {
                                this.registerResourceLocator((IResourceLocator)new OSGiResourceLocator(uri), new String[0]);
                            }
                            ++n6;
                        }
                    } else {
                        String[] themes = new String[cces.length];
                        int i = 0;
                        while (i < cces.length) {
                            themes[i] = cces[i].getAttribute("refid");
                            ++i;
                        }
                        this.registerStylsheet("platform:/plugin/" + ce.getContributor().getName() + "/" + ce.getAttribute("uri"), themes);
                        IConfigurationElement[] iConfigurationElementArray3 = ce.getChildren("osgiresourcelocator");
                        int n7 = iConfigurationElementArray3.length;
                        n5 = 0;
                        while (n5 < n7) {
                            IConfigurationElement resourceEl = iConfigurationElementArray3[n5];
                            String uri = resourceEl.getAttribute("uri");
                            if (uri != null) {
                                this.registerResourceLocator((IResourceLocator)new OSGiResourceLocator(uri), new String[0]);
                            }
                            ++n5;
                        }
                    }
                }
                ++n;
            }
            ++n4;
        }
        display.setData("org.eclipse.e4.ui.css.core.engine", (Object)this.engine);
    }

    @Override
    public synchronized ITheme registerTheme(String id, String label, String basestylesheetURI) {
        for (Theme t : this.themes) {
            if (!t.getId().equals(id)) continue;
            throw new IllegalArgumentException("A theme with the id '" + id + "' is already registered");
        }
        Theme theme = new Theme(id, label);
        this.themes.add(theme);
        this.registerStyle(id, basestylesheetURI);
        return theme;
    }

    @Override
    public synchronized void registerStylsheet(String uri, String ... themes) {
        Bundle bundle = FrameworkUtil.getBundle(ThemeEngine.class);
        String osname = bundle.getBundleContext().getProperty("osgi.os");
        String wsname = bundle.getBundleContext().getProperty("ogsi.ws");
        uri = uri.replaceAll("\\$os\\$", osname).replaceAll("\\$ws\\$", wsname);
        if (themes.length == 0) {
            this.globalStyles.add(uri);
        } else {
            String[] stringArray = themes;
            int n = themes.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                this.registerStyle(t, uri);
                ++n2;
            }
        }
    }

    @Override
    public synchronized void registerResourceLocator(IResourceLocator locator, String ... themes) {
        if (themes.length == 0) {
            this.globalSourceLocators.add(locator);
        } else {
            String[] stringArray = themes;
            int n = themes.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                List<IResourceLocator> list = this.sourceLocators.get(t);
                if (list == null) {
                    list = new ArrayList<IResourceLocator>();
                    this.sourceLocators.put(t, list);
                }
                list.add(locator);
                ++n2;
            }
        }
    }

    private void registerStyle(String id, String stylesheet) {
        List<String> s = this.stylesheets.get(id);
        if (s == null) {
            s = new ArrayList<String>();
            this.stylesheets.put(id, s);
        }
        s.add(stylesheet);
    }

    private List<String> getAllStyles(String id) {
        List<String> s = this.stylesheets.get(id);
        if (s == null) {
            s = Collections.emptyList();
        }
        s = new ArrayList<String>(s);
        s.addAll(this.globalStyles);
        return s;
    }

    private List<IResourceLocator> getResourceLocators(String id) {
        ArrayList<IResourceLocator> list = new ArrayList<IResourceLocator>(this.globalSourceLocators);
        List<IResourceLocator> s = this.sourceLocators.get(id);
        if (s != null) {
            list.addAll(s);
        }
        return list;
    }

    private IConfigurationElement[] getPlatformMatches(IConfigurationElement[] elements) {
        Bundle bundle = FrameworkUtil.getBundle(ThemeEngine.class);
        String osname = bundle.getBundleContext().getProperty("osgi.os");
        String wsname = bundle.getBundleContext().getProperty("ogsi.ws");
        ArrayList<IConfigurationElement> matchingElements = new ArrayList<IConfigurationElement>();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            String elementOs = element.getAttribute("os");
            String elementWs = element.getAttribute("ws");
            if (osname != null && (elementOs == null || elementOs.contains(osname))) {
                if (wsname != null && wsname.equalsIgnoreCase(elementWs)) {
                    matchingElements.add(element);
                } else {
                    matchingElements.add(element);
                }
            } else if (wsname != null && wsname.equalsIgnoreCase(elementWs)) {
                matchingElements.add(element);
            }
            ++i;
        }
        return matchingElements.toArray(new IConfigurationElement[matchingElements.size()]);
    }

    @Override
    public void setTheme(String themeId, boolean restore) {
        for (Theme t : this.themes) {
            if (!t.getId().equals(themeId)) continue;
            this.setTheme(t, restore);
            break;
        }
    }

    @Override
    public void setTheme(ITheme theme, boolean restore) {
        Assert.isNotNull((Object)theme, (String)"The theme must not be null");
        if (this.currentTheme != theme) {
            Shell[] shells;
            if (this.currentTheme != null) {
                for (IResourceLocator l : this.getResourceLocators(this.currentTheme.getId())) {
                    this.engine.getResourcesLocatorManager().unregisterResourceLocator(l);
                }
            }
            this.currentTheme = theme;
            this.engine.reset();
            for (IResourceLocator l : this.getResourceLocators(theme.getId())) {
                this.engine.getResourcesLocatorManager().registerResourceLocator(l);
            }
            for (String stylesheet : this.getAllStyles(theme.getId())) {
                InputStream stream = null;
                try {
                    URL url = FileLocator.resolve((URL)new URL(stylesheet.toString()));
                    stream = url.openStream();
                    this.engine.parseStyleSheet(stream);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    if (stream == null) continue;
                    try {
                        stream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace();
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException e3) {
                                e3.printStackTrace();
                            }
                        }
                    }
                }
                if (stream == null) continue;
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Shell[] shellArray = shells = this.display.getShells();
            int n = shells.length;
            int n2 = 0;
            while (n2 < n) {
                block30: {
                    Shell s = shellArray[n2];
                    try {
                        try {
                            s.setRedraw(false);
                            s.reskin(1);
                            this.applyStyles((Widget)s, true);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            s.setRedraw(true);
                            break block30;
                        }
                    }
                    catch (Throwable throwable) {
                        s.setRedraw(true);
                        throw throwable;
                    }
                    s.setRedraw(true);
                }
                ++n2;
            }
        }
        if (restore) {
            IEclipsePreferences pref = this.getPreferences();
            pref.put(THEMEID_KEY, theme.getId());
            try {
                pref.flush();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public synchronized List<ITheme> getThemes() {
        return Collections.unmodifiableList(new ArrayList<Theme>(this.themes));
    }

    @Override
    public void applyStyles(Widget widget, boolean applyStylesToChildNodes) {
        this.engine.applyStyles((Object)widget, applyStylesToChildNodes);
    }

    @Override
    public CSSEngine getCSSEngine() {
        return this.engine;
    }

    private String getPreferenceThemeId() {
        return this.getPreferences().get(THEMEID_KEY, null);
    }

    private IEclipsePreferences getPreferences() {
        return new InstanceScope().getNode(FrameworkUtil.getBundle(ThemeEngine.class).getSymbolicName());
    }

    @Override
    public void restore(String alternateTheme) {
        String prefThemeId = this.getPreferenceThemeId();
        boolean flag = true;
        if (prefThemeId != null) {
            for (ITheme t : this.getThemes()) {
                if (!prefThemeId.equals(t.getId())) continue;
                this.setTheme(t, false);
                flag = false;
                break;
            }
        }
        if (alternateTheme != null && flag) {
            this.setTheme(alternateTheme, false);
        }
    }

    @Override
    public ITheme getActiveTheme() {
        return this.currentTheme;
    }
}

