/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.compat.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.contributions.IContributionFactorySpi;
import org.eclipse.e4.core.services.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class ReflectionContributionFactory
implements IContributionFactory {
    private IExtensionRegistry registry;
    private Map<String, Object> languages;
    @Inject
    private PackageAdmin packageAdmin;
    @Inject
    private Logger logger;

    @Inject
    public ReflectionContributionFactory(IExtensionRegistry registry) {
        this.registry = registry;
        this.processLanguages();
    }

    public Object call(Object object, String uriString, String methodName, IEclipseContext context, Object defaultValue) {
        if (uriString != null) {
            URI uri = new URI(uriString);
            if (uri.segments.length > 3) {
                String prefix = uri.segments[2];
                IContributionFactorySpi factory = (IContributionFactorySpi)this.languages.get(prefix);
                return factory.call(object, methodName, context, defaultValue);
            }
        }
        Method targetMethod = null;
        Method[] methods = object.getClass().getMethods();
        if (methods.length == 1) {
            targetMethod = methods[0];
        } else {
            ArrayList<Method> toSort = new ArrayList<Method>();
            int i = 0;
            while (i < methods.length) {
                Method method = methods[i];
                if ((method.getModifiers() & 1) != 0 && method.getName().equals(methodName)) {
                    toSort.add(method);
                }
                ++i;
            }
            Collections.sort(toSort, new Comparator<Method>(){

                @Override
                public int compare(Method m1, Method m2) {
                    int l1 = m1.getParameterTypes().length;
                    int l2 = m2.getParameterTypes().length;
                    return l1 - l2;
                }
            });
            Iterator iter = toSort.iterator();
            while (iter.hasNext() && targetMethod == null) {
                Method next = (Method)iter.next();
                boolean satisfiable = true;
                Class<?>[] params = next.getParameterTypes();
                int i2 = 0;
                while (i2 < params.length && satisfiable) {
                    Class<?> clazz = params[i2];
                    if (!context.containsKey(clazz.getName()) && !IEclipseContext.class.equals(clazz)) {
                        satisfiable = false;
                    }
                    ++i2;
                }
                if (!satisfiable) continue;
                targetMethod = next;
            }
        }
        if (targetMethod == null) {
            if (defaultValue != null) {
                return defaultValue;
            }
            throw new RuntimeException("could not find satisfiable method " + methodName + " in class " + object.getClass());
        }
        Class<?>[] paramKeys = targetMethod.getParameterTypes();
        try {
            this.logger.debug("calling: " + methodName);
            Object[] params = new Object[paramKeys.length];
            int i = 0;
            while (i < params.length) {
                params[i] = IEclipseContext.class.equals(paramKeys[i]) ? context : context.get(paramKeys[i].getName());
                ++i;
            }
            return targetMethod.invoke(object, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Object create(String uriString, IEclipseContext context) {
        Object contribution;
        if (uriString == null) {
            return null;
        }
        URI uri = new URI(uriString);
        Bundle bundle = this.getBundle(uri);
        if (bundle != null) {
            contribution = this.createFromBundle(bundle, context, uri);
        } else {
            contribution = null;
            this.logger.error("Unable to retrive the bundle from the URI: " + uriString);
        }
        return contribution;
    }

    protected Object createFromBundle(Bundle bundle, IEclipseContext context, URI uri) {
        Object contribution;
        if (uri.segments.length > 3) {
            String prefix = uri.segments[2];
            IContributionFactorySpi factory = (IContributionFactorySpi)this.languages.get(prefix);
            StringBuffer resource = new StringBuffer(uri.segments[3]);
            int i = 4;
            while (i < uri.segments.length) {
                resource.append('/');
                resource.append(uri.segments[i]);
                ++i;
            }
            contribution = factory.create(bundle, resource.toString(), context);
        } else {
            String clazz = uri.segments[2];
            try {
                Class targetClass = bundle.loadClass(clazz);
                contribution = ContextInjectionFactory.make((Class)targetClass, (IEclipseContext)context);
                if (contribution == null) {
                    String message = "Unable to load class '" + clazz + "' from bundle '" + bundle.getBundleId() + "'";
                    this.logger.error(message);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                contribution = null;
                String message = "Unable to load class '" + clazz + "' from bundle '" + bundle.getBundleId() + "'";
                this.logger.error(message);
            }
            catch (InjectionException injectionException) {
                contribution = null;
                String message = "Unable to create class '" + clazz + "' from bundle '" + bundle.getBundleId() + "'";
                this.logger.error(message);
            }
        }
        return contribution;
    }

    protected void processLanguages() {
        this.languages = new HashMap<String, Object>();
        String extId = "org.eclipse.e4.languages";
        IConfigurationElement[] languageElements = this.registry.getConfigurationElementsFor(extId);
        int i = 0;
        while (i < languageElements.length) {
            IConfigurationElement languageElement = languageElements[i];
            try {
                this.languages.put(languageElement.getAttribute("name"), languageElement.createExecutableExtension("contributionFactory"));
            }
            catch (InvalidRegistryObjectException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    protected Bundle getBundle(URI platformURI) {
        return this.getBundleForName(platformURI.segments[1]);
    }

    public Bundle getBundle(String uriString) {
        return this.getBundle(new URI(uriString));
    }

    public Bundle getBundleForName(String bundlename) {
        Bundle[] bundles;
        if (this.packageAdmin == null) {
            Bundle bundle = FrameworkUtil.getBundle(this.getClass());
            BundleContext context = bundle.getBundleContext();
            ServiceReference reference = context.getServiceReference(PackageAdmin.class.getName());
            this.packageAdmin = (PackageAdmin)context.getService(reference);
        }
        if ((bundles = this.packageAdmin.getBundles(bundlename, null)) == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    static class URI {
        String[] segments;
        String uri;

        private URI(String uriString) {
            this.segments = uriString.substring(uriString.indexOf(47) + 1).split("/");
        }
    }
}

