/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class ParentContextDisposalTest
extends TestCase {
    public void testParentContextDisposal() {
        IEclipseContext context = EclipseContextFactory.create();
        IEclipseContext child = context.createChild();
        child.set("o", new Object());
        Target target = (Target)ContextInjectionFactory.make(Target.class, (IEclipseContext)child);
        ParentContextDisposalTest.assertEquals((int)1, (int)target.pc);
        context.dispose();
        ParentContextDisposalTest.assertEquals((int)1, (int)target.pd);
    }

    static class Target {
        int pc = 0;
        int pd = 0;
        @Inject
        @Named(value="o")
        Object o;

        Target() {
        }

        @PostConstruct
        void pc() {
            ++this.pc;
        }

        @PreDestroy
        void pd() {
            ++this.pd;
        }
    }
}

