/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.internal.property;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.platform.discovery.util.internal.property.IProperty;
import org.eclipse.platform.discovery.util.internal.property.IPropertyAttributeListener;
import org.eclipse.platform.discovery.util.internal.property.PropertyAttributeChangedEvent;

class PropertyAttribute<A> {
    private Collection<IPropertyAttributeListener<A>> attributeListeners = new LinkedList<IPropertyAttributeListener<A>>();
    private A attributeValue;
    private final IProperty<?> parentProperty;

    public PropertyAttribute(A attributeValue, IProperty<?> parentProperty) {
        if (parentProperty == null) {
            throw new NullPointerException();
        }
        this.attributeValue = attributeValue;
        this.parentProperty = parentProperty;
    }

    public A get() {
        return this.attributeValue;
    }

    public void set(A attributeValue) {
        if (attributeValue == this.get()) {
            return;
        }
        if (attributeValue != null && attributeValue.equals(this.get())) {
            return;
        }
        PropertyAttributeChangedEvent<A> ace = new PropertyAttributeChangedEvent<A>(this.parentProperty, this.get(), attributeValue);
        this.attributeValue = attributeValue;
        for (IPropertyAttributeListener<A> l : this.attributeListeners) {
            l.attributeChanged(ace);
        }
    }

    public void registerListener(IPropertyAttributeListener<A> l, boolean current) {
        if (current) {
            l.attributeChanged(new PropertyAttributeChangedEvent<A>(this.parentProperty, this.get(), this.get()));
        }
        this.attributeListeners.add(l);
    }

    public boolean removeListener(IPropertyAttributeListener<A> l) {
        return this.attributeListeners.remove(l);
    }
}

